/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.mixin.common.SinglePoolElementAccessor;
import dev.worldgen.lithostitched.mixin.common.StructureTemplatePoolAccessor;
import dev.worldgen.lithostitched.worldgen.LithostitchedCodecs;
import dev.worldgen.lithostitched.worldgen.modifier.Modifier;
import dev.worldgen.lithostitched.worldgen.poolelement.DelegatingPoolElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.pools.SinglePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorList;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;

public record SetPoolElementProcessorsModifier(HolderSet<StructureTemplatePool> templatePools, Optional<List<ResourceLocation>> locations, Holder<StructureProcessorList> processorList, boolean append) implements Modifier
{
    public static final MapCodec<SetPoolElementProcessorsModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LithostitchedCodecs.registrySet(Registries.TEMPLATE_POOL, "template_pools").forGetter(SetPoolElementProcessorsModifier::templatePools), (App)LithostitchedCodecs.compactList(ResourceLocation.CODEC).optionalFieldOf("locations").forGetter(SetPoolElementProcessorsModifier::locations), (App)StructureProcessorType.LIST_CODEC.fieldOf("processor_list").forGetter(SetPoolElementProcessorsModifier::processorList), (App)Codec.BOOL.fieldOf("append").orElse((Object)true).forGetter(SetPoolElementProcessorsModifier::append)).apply((Applicative)instance, SetPoolElementProcessorsModifier::new));

    @Override
    public void applyModifier() {
        for (Holder templatePool : this.templatePools) {
            StructureTemplatePoolAccessor pool = (StructureTemplatePoolAccessor)templatePool.value();
            for (StructurePoolElement element : pool.getRawTemplates().stream().map(Pair::getFirst).toList()) {
                this.applyModifier(element);
            }
        }
    }

    private void applyModifier(StructurePoolElement element) {
        if (element instanceof SinglePoolElement) {
            SinglePoolElementAccessor accessor = (SinglePoolElementAccessor)element;
            Optional template = accessor.getTemplate().left();
            if (this.locations.isEmpty() || template.isPresent() && this.locations.get().contains(template.get())) {
                this.addProcessor(accessor);
            }
        } else if (element instanceof DelegatingPoolElement) {
            DelegatingPoolElement delegating = (DelegatingPoolElement)element;
            this.applyModifier(delegating.delegate());
        }
    }

    private void addProcessor(SinglePoolElementAccessor element) {
        ArrayList processors = new ArrayList();
        if (this.append) {
            processors.addAll(((StructureProcessorList)element.getProcessors().value()).list());
        }
        processors.addAll(((StructureProcessorList)this.processorList.value()).list());
        element.setProcessors((Holder<StructureProcessorList>)Holder.direct((Object)new StructureProcessorList(processors)));
    }

    @Override
    public Modifier.ModifierPhase getPhase() {
        return this.append ? Modifier.ModifierPhase.REPLACE : Modifier.ModifierPhase.ADD;
    }

    @Override
    public MapCodec<? extends Modifier> codec() {
        return CODEC;
    }
}

