/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.mixin.common.StructureSetAccessor;
import dev.worldgen.lithostitched.worldgen.LithostitchedCodecs;
import dev.worldgen.lithostitched.worldgen.modifier.Modifier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.level.levelgen.structure.StructureSet;

public record AddStructureSetEntriesModifier(HolderSet<StructureSet> structureSets, List<StructureSet.StructureSelectionEntry> entries) implements Modifier
{
    public static final MapCodec<AddStructureSetEntriesModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LithostitchedCodecs.registrySet(Registries.STRUCTURE_SET, "structure_sets").forGetter(AddStructureSetEntriesModifier::structureSets), (App)StructureSet.StructureSelectionEntry.CODEC.listOf().fieldOf("entries").forGetter(AddStructureSetEntriesModifier::entries)).apply((Applicative)instance, AddStructureSetEntriesModifier::new));

    @Override
    public Modifier.ModifierPhase getPhase() {
        return Modifier.ModifierPhase.ADD;
    }

    @Override
    public void applyModifier() {
        this.structureSets.stream().map(Holder::value).forEach(this::applyModifier);
    }

    public void applyModifier(StructureSet structureSet) {
        StructureSetAccessor structureSetAccessor = (StructureSetAccessor)structureSet;
        ArrayList<StructureSet.StructureSelectionEntry> structureSelectionEntries = new ArrayList<StructureSet.StructureSelectionEntry>(structureSet.structures());
        structureSelectionEntries.addAll(this.entries());
        structureSetAccessor.setStructures(structureSelectionEntries);
    }

    @Override
    public MapCodec<? extends Modifier> codec() {
        return CODEC;
    }
}

