/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.villager_merchant;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.listings.EnchantedBookForCoinsTrade;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.listings.EnchantedItemForCoinsTrade;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.listings.ItemsForMapTrade;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.listings.RandomTrade;
import io.github.lightman314.lightmanscurrency.common.villager_merchant.listings.SimpleTrade;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.npc.VillagerTrades;

public class ItemListingSerializer {
    private static final Map<Class<? extends VillagerTrades.ItemListing>, IItemListingSerializer> serializers = new HashMap<Class<? extends VillagerTrades.ItemListing>, IItemListingSerializer>();
    private static final Map<ResourceLocation, IItemListingDeserializer> deserializers = new HashMap<ResourceLocation, IItemListingDeserializer>();

    public static <L extends VillagerTrades.ItemListing, T extends IItemListingSerializer & IItemListingDeserializer> void registerItemListing(@Nonnull ResourceLocation type, @Nonnull Class<L> clazz, @Nonnull T serializer) {
        ItemListingSerializer.registerItemListing(type, clazz, serializer, serializer);
    }

    public static <T extends VillagerTrades.ItemListing> void registerItemListing(@Nonnull ResourceLocation type, Class<T> clazz, @Nonnull IItemListingSerializer serializer, @Nonnull IItemListingDeserializer deserializer) {
        if (serializers.containsKey(clazz)) {
            LightmansCurrency.LogWarning("Attempted to register a duplicate ItemListing Serializer of class '" + clazz.getName() + "'!");
        } else if (deserializers.containsKey(type)) {
            LightmansCurrency.LogWarning("Attempted to register a duplicate ItemListing Deserializer of type '" + String.valueOf(type) + "'!");
        } else {
            serializers.put(clazz, serializer);
            deserializers.put(type, deserializer);
            LightmansCurrency.LogInfo("Registered Item Listing serializer '" + String.valueOf(type) + "'");
        }
    }

    public static JsonObject serialize(Map<Integer, List<VillagerTrades.ItemListing>> trades, int count, @Nonnull HolderLookup.Provider lookup) {
        JsonObject json = new JsonObject();
        for (int i = 1; i <= count; ++i) {
            json.add("TradesLevel" + i, (JsonElement)ItemListingSerializer.serializeList(trades.getOrDefault(i, new ArrayList()), lookup));
        }
        return json;
    }

    public static Map<Integer, List<VillagerTrades.ItemListing>> deserialize(@Nonnull JsonObject json, @Nonnull HolderLookup.Provider lookup) {
        HashMap<Integer, List<VillagerTrades.ItemListing>> result = new HashMap<Integer, List<VillagerTrades.ItemListing>>();
        for (int i = 1; i <= 5; ++i) {
            JsonElement jsonElement;
            if (json.has("TradesLevel" + i) && (jsonElement = json.get("TradesLevel" + i)) instanceof JsonArray) {
                JsonArray jsonList = (JsonArray)jsonElement;
                result.put(i, ItemListingSerializer.deserializeList(jsonList, lookup));
                continue;
            }
            result.put(i, new ArrayList());
        }
        return result;
    }

    public static JsonArray serializeList(@Nonnull List<VillagerTrades.ItemListing> trades, @Nonnull HolderLookup.Provider lookup) {
        JsonArray list = new JsonArray();
        for (VillagerTrades.ItemListing trade : trades) {
            JsonObject tj = ItemListingSerializer.serializeTrade(trade, lookup);
            if (tj == null) continue;
            list.add((JsonElement)tj);
        }
        return list;
    }

    public static List<VillagerTrades.ItemListing> deserializeList(@Nonnull JsonArray jsonList, @Nonnull HolderLookup.Provider lookup) {
        ArrayList<VillagerTrades.ItemListing> list = new ArrayList<VillagerTrades.ItemListing>();
        for (int i = 0; i < jsonList.size(); ++i) {
            try {
                VillagerTrades.ItemListing trade = ItemListingSerializer.deserializeTrade(jsonList.get(i).getAsJsonObject(), lookup);
                list.add(trade);
                continue;
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error deserializing item listing at index " + i + "!", t);
            }
        }
        return list;
    }

    public static <T extends VillagerTrades.ItemListing> JsonObject serializeTrade(T listing, @Nonnull HolderLookup.Provider lookup) {
        if (listing == null) {
            return null;
        }
        IItemListingSerializer serializer = serializers.get(listing.getClass());
        if (serializer == null) {
            return null;
        }
        return serializer.serialize(listing, lookup);
    }

    public static VillagerTrades.ItemListing deserializeTrade(@Nonnull JsonObject json, @Nonnull HolderLookup.Provider lookup) throws JsonSyntaxException, ResourceLocationException {
        ResourceLocation type = VersionUtil.parseResource(GsonHelper.getAsString((JsonObject)json, (String)"Type"));
        IItemListingDeserializer deserializer = deserializers.get(type);
        if (deserializer == null) {
            throw new JsonSyntaxException("Could not deserialize entry as no deserializer was found of type '" + String.valueOf(type) + "'!");
        }
        VillagerTrades.ItemListing trade = deserializer.deserialize(json, lookup);
        if (trade == null) {
            throw new JsonSyntaxException("An unknown error occurred while deserializing entry!");
        }
        return trade;
    }

    public static void registerDefaultSerializers() {
        ItemListingSerializer.registerItemListing(SimpleTrade.TYPE, SimpleTrade.class, SimpleTrade.SERIALIZER);
        ItemListingSerializer.registerItemListing(RandomTrade.TYPE, RandomTrade.class, RandomTrade.SERIALIZER);
        ItemListingSerializer.registerItemListing(EnchantedItemForCoinsTrade.TYPE, EnchantedItemForCoinsTrade.class, EnchantedItemForCoinsTrade.SERIALIZER);
        ItemListingSerializer.registerItemListing(EnchantedBookForCoinsTrade.TYPE, EnchantedBookForCoinsTrade.class, EnchantedBookForCoinsTrade.SERIALIZER);
        ItemListingSerializer.registerItemListing(ItemsForMapTrade.TYPE, ItemsForMapTrade.class, ItemsForMapTrade.SERIALIZER);
    }

    public static interface IItemListingDeserializer {
        @Nonnull
        public VillagerTrades.ItemListing deserialize(@Nonnull JsonObject var1, @Nonnull HolderLookup.Provider var2) throws JsonSyntaxException, ResourceLocationException;
    }

    public static interface IItemListingSerializer {
        public ResourceLocation getType();

        @Nullable
        default public JsonObject serialize(@Nonnull VillagerTrades.ItemListing trade, @Nonnull HolderLookup.Provider lookup) {
            JsonObject json = new JsonObject();
            json.addProperty("Type", this.getType().toString());
            return this.serializeInternal(json, trade, lookup);
        }

        @Nullable
        public JsonObject serializeInternal(@Nonnull JsonObject var1, @Nonnull VillagerTrades.ItemListing var2, @Nonnull HolderLookup.Provider var3);
    }
}

