/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.rules.types;

import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.rules.TradeRuleType;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.rule_tabs.PlayerTradeLimitTab;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.TimeUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class PlayerTradeLimit
extends TradeRule {
    public static final TradeRuleType<PlayerTradeLimit> TYPE = new TradeRuleType<PlayerTradeLimit>(VersionUtil.lcResource("player_trade_limit"), PlayerTradeLimit::new);
    private int limit = 1;
    private long timeLimit = 0L;
    Map<UUID, List<Long>> memory = new HashMap<UUID, List<Long>>();

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int newLimit) {
        this.limit = MathUtil.clamp(newLimit, 1, 100);
    }

    private boolean enforceTimeLimit() {
        return this.timeLimit > 0L;
    }

    public long getTimeLimit() {
        return this.timeLimit;
    }

    public void setTimeLimit(long timeLimit) {
        this.timeLimit = timeLimit;
    }

    public void resetMemory() {
        this.memory.clear();
    }

    private PlayerTradeLimit() {
        super(TYPE);
    }

    @Override
    public IconData getIcon() {
        return IconUtil.ICON_COUNT_PLAYER;
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        int tradeCount = this.getTradeCount(event.getPlayerReference().id);
        if (tradeCount >= this.limit) {
            if (this.enforceTimeLimit()) {
                event.addDenial(LCText.TRADE_RULE_PLAYER_TRADE_LIMIT_DENIAL_TIMED.get(tradeCount, new TimeUtil.TimeData(this.getTimeLimit()).getString()));
            } else {
                event.addDenial(LCText.TRADE_RULE_PLAYER_TRADE_LIMIT_DENIAL.get(tradeCount));
            }
            event.addDenial(LCText.TRADE_RULE_PLAYER_TRADE_LIMIT_DENIAL_LIMIT.get(this.limit));
        } else if (this.enforceTimeLimit()) {
            event.addHelpful(LCText.TRADE_RULE_PLAYER_TRADE_LIMIT_INFO_TIMED.get(tradeCount, this.limit, new TimeUtil.TimeData(this.getTimeLimit()).getString()));
        } else {
            event.addHelpful(LCText.TRADE_RULE_PLAYER_TRADE_LIMIT_INFO.get(tradeCount, this.limit));
        }
    }

    @Override
    public void afterTrade(TradeEvent.PostTradeEvent event) {
        this.addEvent(event.getPlayerReference().id, TimeUtil.getCurrentTime());
        this.clearExpiredData();
        event.markDirty();
    }

    private void addEvent(UUID player, Long time) {
        List<Long> eventTimes = new ArrayList<Long>();
        if (this.memory.containsKey(player)) {
            eventTimes = this.memory.get(player);
        }
        eventTimes.add(time);
        this.memory.put(player, eventTimes);
    }

    private void clearExpiredData() {
        if (!this.enforceTimeLimit()) {
            return;
        }
        ArrayList emptyEntries = new ArrayList();
        this.memory.forEach((id, eventTimes) -> {
            for (int i = 0; i < eventTimes.size(); ++i) {
                if (TimeUtil.compareTime(this.timeLimit, (Long)eventTimes.get(i))) continue;
                eventTimes.remove(i);
                --i;
            }
            if (eventTimes.isEmpty()) {
                emptyEntries.add(id);
            }
        });
        emptyEntries.forEach(id -> this.memory.remove(id));
    }

    private int getTradeCount(UUID playerID) {
        int count = 0;
        if (this.memory.containsKey(playerID)) {
            List<Long> eventTimes = this.memory.get(playerID);
            if (!this.enforceTimeLimit()) {
                return eventTimes.size();
            }
            for (Long eventTime : eventTimes) {
                if (!TimeUtil.compareTime(this.timeLimit, eventTime)) continue;
                ++count;
            }
        }
        return count;
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider lookup) {
        compound.putInt("Limit", this.limit);
        ListTag memoryList = new ListTag();
        this.memory.forEach((id, eventTimes) -> {
            CompoundTag thisMemory = new CompoundTag();
            thisMemory.putUUID("id", id);
            thisMemory.putLongArray("times", eventTimes);
            memoryList.add((Object)thisMemory);
        });
        compound.put("Memory", (Tag)memoryList);
        compound.putLong("ForgetTime", this.timeLimit);
    }

    @Override
    public JsonObject saveToJson(JsonObject json, HolderLookup.Provider lookup) {
        json.addProperty("Limit", (Number)this.limit);
        if (this.enforceTimeLimit()) {
            json.addProperty("ForgetTime", (Number)this.timeLimit);
        }
        return json;
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider lookup) {
        if (compound.contains("Limit", 3)) {
            this.limit = compound.getInt("Limit");
        }
        if (compound.contains("Memory", 9)) {
            this.memory.clear();
            ListTag memoryList = compound.getList("Memory", 10);
            for (int i = 0; i < memoryList.size(); ++i) {
                CompoundTag thisMemory = memoryList.getCompound(i);
                UUID id = null;
                ArrayList<Long> eventTimes = new ArrayList<Long>();
                if (thisMemory.contains("id")) {
                    id = thisMemory.getUUID("id");
                }
                if (thisMemory.contains("count", 3)) {
                    int count = thisMemory.getInt("count");
                    for (int z = 0; z < count; ++z) {
                        eventTimes.add(TimeUtil.getCurrentTime());
                    }
                }
                if (thisMemory.contains("times", 12)) {
                    for (long time : thisMemory.getLongArray("times")) {
                        eventTimes.add(time);
                    }
                }
                this.memory.put(id, eventTimes);
            }
        }
        if (compound.contains("ForgetTime", 4)) {
            this.timeLimit = compound.getLong("ForgetTime");
        }
    }

    @Override
    public void handleUpdateMessage(Player player, LazyPacketData updateInfo) {
        if (updateInfo.contains("Limit")) {
            this.limit = updateInfo.getInt("Limit");
        } else if (updateInfo.contains("TimeLimit")) {
            this.timeLimit = updateInfo.getLong("TimeLimit");
        } else if (updateInfo.contains("ClearMemory")) {
            this.resetMemory();
        }
    }

    @Override
    public CompoundTag savePersistentData(HolderLookup.Provider lookup) {
        CompoundTag data = new CompoundTag();
        ListTag memoryList = new ListTag();
        this.memory.forEach((id, eventTimes) -> {
            CompoundTag thisMemory = new CompoundTag();
            thisMemory.putUUID("id", id);
            thisMemory.putLongArray("times", eventTimes);
            memoryList.add((Object)thisMemory);
        });
        data.put("Memory", (Tag)memoryList);
        return data;
    }

    @Override
    public void loadPersistentData(CompoundTag data, HolderLookup.Provider lookup) {
        if (data.contains("Memory", 9)) {
            this.memory.clear();
            ListTag memoryList = data.getList("Memory", 10);
            for (int i = 0; i < memoryList.size(); ++i) {
                CompoundTag thisMemory = memoryList.getCompound(i);
                UUID id = null;
                ArrayList<Long> eventTimes = new ArrayList<Long>();
                if (thisMemory.contains("id")) {
                    id = thisMemory.getUUID("id");
                }
                if (thisMemory.contains("count", 3)) {
                    int count = thisMemory.getInt("count");
                    for (int z = 0; z < count; ++z) {
                        eventTimes.add(0L);
                    }
                }
                if (thisMemory.contains("times", 12)) {
                    for (long time : thisMemory.getLongArray("times")) {
                        eventTimes.add(time);
                    }
                }
                this.memory.put(id, eventTimes);
            }
        }
    }

    @Override
    public void loadFromJson(JsonObject json, HolderLookup.Provider lookup) {
        if (json.has("Limit")) {
            this.limit = json.get("Limit").getAsInt();
        }
        if (json.has("ForgetTime")) {
            this.timeLimit = json.get("ForgetTime").getAsLong();
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TradeRulesClientSubTab createTab(TradeRulesClientTab<?> parent) {
        return new PlayerTradeLimitTab(parent);
    }
}

