/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.rules.types;

import com.google.common.collect.ImmutableList;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.rules.TradeRuleType;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.rule_tabs.PlayerListingTab;
import io.github.lightman314.lightmanscurrency.common.traders.rules.IRuleLoadListener;
import io.github.lightman314.lightmanscurrency.common.traders.rules.ITradeRuleHost;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import it.unimi.dsi.fastutil.Pair;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class PlayerListing
extends TradeRule {
    public static final TradeRuleType<PlayerListing> TYPE = new TradeRuleType<PlayerListing>(VersionUtil.lcResource("player_list"), PlayerListing::new);
    public static final IRuleLoadListener LISTENER = new DataListener();
    boolean whitelistMode = true;
    List<PlayerReference> playerList = new ArrayList<PlayerReference>();

    public boolean isWhitelistMode() {
        return this.whitelistMode;
    }

    public boolean isBlacklistMode() {
        return !this.whitelistMode;
    }

    public ImmutableList<PlayerReference> getPlayerList() {
        return ImmutableList.copyOf(this.playerList);
    }

    private PlayerListing() {
        super(TYPE);
    }

    @Override
    public IconData getIcon() {
        return this.isWhitelistMode() ? IconUtil.ICON_WHITELIST : IconUtil.ICON_BLACKLIST;
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        if (this.isBlacklistMode() && this.isInList(event.getPlayerReference())) {
            event.addDenial(LCText.TRADE_RULE_PLAYER_LISTING_DENIAL_BLACKLIST.get(new Object[0]));
        } else if (this.isWhitelistMode()) {
            if (this.isInList(event.getPlayerReference())) {
                event.addHelpful(LCText.TRADE_RULE_PLAYER_LISTING_ALLOWED.get(new Object[0]));
            } else {
                event.addDenial(LCText.TRADE_RULE_PLAYER_LISTING_DENIAL_WHITELIST.get(new Object[0]));
            }
        }
    }

    public boolean isInList(PlayerReference player) {
        return PlayerReference.isInList(this.playerList, player);
    }

    public boolean addToWhitelist(ServerPlayer player) {
        boolean changed = false;
        PlayerReference pr = PlayerReference.of((Player)player);
        if (this.isBlacklistMode()) {
            this.playerList.clear();
            changed = true;
        }
        if (!this.whitelistMode) {
            this.whitelistMode = true;
        }
        if (!this.isInList(pr)) {
            this.playerList.add(pr);
            changed = true;
        }
        return changed;
    }

    @Override
    protected void saveAdditional(CompoundTag compound, HolderLookup.Provider lookup) {
        compound.putBoolean("WhitelistMode", this.whitelistMode);
        PlayerReference.saveList(compound, this.playerList, "Players");
    }

    @Override
    protected void loadAdditional(CompoundTag compound, HolderLookup.Provider lookup) {
        if (compound.contains("Players", 9)) {
            this.playerList = PlayerReference.loadList(compound, "Players");
        }
        if (compound.contains("WhitelistMode")) {
            this.whitelistMode = compound.getBoolean("WhitelistMode");
        }
    }

    @Override
    public JsonObject saveToJson(JsonObject json, HolderLookup.Provider lookup) {
        return json;
    }

    @Override
    public void loadFromJson(JsonObject json, HolderLookup.Provider lookup) throws JsonSyntaxException, ResourceLocationException {
    }

    @Override
    public CompoundTag savePersistentData(HolderLookup.Provider lookup) {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag, lookup);
        return tag;
    }

    @Override
    public void loadPersistentData(CompoundTag data, HolderLookup.Provider lookup) {
        this.loadAdditional(data, lookup);
    }

    @Override
    protected void handleUpdateMessage(Player player, LazyPacketData updateInfo) {
        if (updateInfo.contains("AddPlayer")) {
            PlayerReference added = PlayerReference.load(updateInfo.getNBT("AddPlayer"));
            if (added == null || this.isInList(added)) {
                return;
            }
            this.playerList.add(added);
        }
        if (updateInfo.contains("RemovePlayer")) {
            PlayerReference removed = PlayerReference.load(updateInfo.getNBT("RemovePlayer"));
            if (removed == null || !this.isInList(removed)) {
                return;
            }
            PlayerReference.removeFromList(this.playerList, removed);
        }
        if (updateInfo.contains("ChangeMode")) {
            this.whitelistMode = updateInfo.getBoolean("ChangeMode");
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TradeRulesClientSubTab createTab(TradeRulesClientTab<?> parent) {
        return new PlayerListingTab(parent, TYPE);
    }

    private static final class DataListener
    implements IRuleLoadListener {
        private DataListener() {
        }

        @Override
        public void afterLoading(@Nullable ITradeRuleHost host, List<CompoundTag> allData, List<TradeRule> rules) {
            if (TradeRule.getRule(PlayerListing.TYPE.type, rules) == null) {
                PlayerListing rule = new PlayerListing();
                if (host == null || host.allowTradeRule(rule) && rule.allowHost(host)) {
                    rule.setHost(host);
                    Pair whitelistState = Pair.of((Object)false, (Object)false);
                    Pair blacklistState = Pair.of((Object)false, (Object)false);
                    for (CompoundTag tag : allData) {
                        boolean active;
                        boolean relevant;
                        if (!tag.contains("Type")) continue;
                        String type = tag.getString("Type");
                        if (type.equals("lightmanscurrency:whitelist") && tag.contains("WhitelistedPlayers") && !((Boolean)whitelistState.first()).booleanValue()) {
                            List<PlayerReference> whitelist = PlayerReference.loadList(tag, "WhitelistedPlayers");
                            relevant = !whitelist.isEmpty();
                            for (PlayerReference pr : whitelist) {
                                if (PlayerReference.isInList(rule.playerList, pr)) continue;
                                rule.playerList.add(pr);
                            }
                            active = tag.contains("Active") && tag.getBoolean("Active");
                            whitelistState = Pair.of((Object)relevant, (Object)active);
                        }
                        if (!type.equals("lightmanscurrency:blacklist") || !tag.contains("BannedPlayers") || ((Boolean)blacklistState.first()).booleanValue()) continue;
                        List<PlayerReference> blacklist = PlayerReference.loadList(tag, "BannedPlayers");
                        relevant = !blacklist.isEmpty();
                        for (PlayerReference pr : blacklist) {
                            if (PlayerReference.isInList(rule.playerList, pr)) continue;
                            rule.playerList.add(pr);
                        }
                        active = tag.contains("Active") && tag.getBoolean("Active");
                        blacklistState = Pair.of((Object)relevant, (Object)active);
                    }
                    if (((Boolean)whitelistState.first()).booleanValue() || ((Boolean)blacklistState.first()).booleanValue()) {
                        LightmansCurrency.LogDebug("Successfully loaded data from the old whitelist/blacklist rules!");
                        if (whitelistState.first() != blacklistState.first()) {
                            rule.setActive((Boolean)whitelistState.first() != false ? (Boolean)whitelistState.second() : (Boolean)blacklistState.second());
                        }
                    }
                }
            }
        }
    }
}

