/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.rules;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.rules.TradeRuleType;
import io.github.lightman314.lightmanscurrency.api.traders.trade.TradeData;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.trade_rules.TradeRulesClientTab;
import io.github.lightman314.lightmanscurrency.common.traders.rules.IRuleLoadListener;
import io.github.lightman314.lightmanscurrency.common.traders.rules.ITradeRuleHost;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public abstract class TradeRule {
    private static final List<IRuleLoadListener> LISTENERS = new ArrayList<IRuleLoadListener>();
    private static final List<String> IGNORE_MISSING = new ArrayList<String>();
    public final TradeRuleType<?> type;
    private ITradeRuleHost host = null;
    private boolean isActive = false;

    public static void addLoadListener(IRuleLoadListener listener) {
        if (LISTENERS.contains(listener)) {
            return;
        }
        LISTENERS.add(listener);
    }

    public static void addIgnoreMissing(String oldType) {
        if (IGNORE_MISSING.contains(oldType)) {
            return;
        }
        IGNORE_MISSING.add(oldType);
    }

    public static String translationKeyOfType(ResourceLocation ruleType) {
        return "traderule." + ruleType.getNamespace() + "." + ruleType.getPath();
    }

    public static MutableComponent nameOfType(ResourceLocation ruleType) {
        return Component.translatable((String)TradeRule.translationKeyOfType(ruleType));
    }

    public final MutableComponent getName() {
        return TradeRule.nameOfType(this.type.type);
    }

    public abstract IconData getIcon();

    @Nullable
    protected ITradeRuleHost getHost() {
        return this.host;
    }

    protected void setHost(@Nullable ITradeRuleHost host) {
        this.host = host;
    }

    public boolean isActive() {
        return this.canActivate(this.host) && this.isActive;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    protected boolean allowHost(ITradeRuleHost host) {
        if (this.onlyAllowOnTraders() && !host.isTrader()) {
            return false;
        }
        return !this.onlyAllowOnTrades() || host.isTrade();
    }

    public boolean canActivate() {
        return this.canActivate(this.host);
    }

    protected boolean canActivate(@Nullable ITradeRuleHost host) {
        return this.allowHost(host);
    }

    public boolean canPlayerActivate(Player player) {
        return this.canActivate();
    }

    protected boolean onlyAllowOnTraders() {
        return false;
    }

    protected boolean onlyAllowOnTrades() {
        return false;
    }

    public void beforeTrade(TradeEvent.PreTradeEvent event) {
    }

    public void tradeCost(TradeEvent.TradeCostEvent event) {
    }

    public void afterTrade(TradeEvent.PostTradeEvent event) {
    }

    protected void tradeBaseCost(InternalPriceEvent query) {
    }

    protected TradeRule(TradeRuleType<?> type) {
        this.type = type;
    }

    public CompoundTag save(HolderLookup.Provider lookup) {
        CompoundTag compound = new CompoundTag();
        compound.putString("Type", this.type.toString());
        compound.putBoolean("Active", this.isActive);
        this.saveAdditional(compound, lookup);
        return compound;
    }

    protected abstract void saveAdditional(CompoundTag var1, HolderLookup.Provider var2);

    public final void load(CompoundTag compound, HolderLookup.Provider lookup) {
        this.isActive = compound.getBoolean("Active");
        this.loadAdditional(compound, lookup);
    }

    protected abstract void loadAdditional(CompoundTag var1, HolderLookup.Provider var2);

    public abstract JsonObject saveToJson(JsonObject var1, HolderLookup.Provider var2);

    public abstract void loadFromJson(JsonObject var1, HolderLookup.Provider var2) throws JsonSyntaxException, ResourceLocationException;

    public abstract CompoundTag savePersistentData(HolderLookup.Provider var1);

    public abstract void loadPersistentData(CompoundTag var1, HolderLookup.Provider var2);

    public final void receiveUpdateMessage(Player player, LazyPacketData data) {
        if (data.contains("SetActive")) {
            boolean active = data.getBoolean("SetActive");
            this.isActive = active ? this.isActive || this.canPlayerActivate(player) : false;
        }
        this.handleUpdateMessage(player, data);
    }

    protected abstract void handleUpdateMessage(Player var1, LazyPacketData var2);

    public static void saveRules(CompoundTag compound, List<TradeRule> rules, String tag, HolderLookup.Provider lookup) {
        ListTag ruleData = new ListTag();
        for (TradeRule rule : rules) {
            ruleData.add((Object)rule.save(lookup));
        }
        compound.put(tag, (Tag)ruleData);
    }

    public static boolean savePersistentData(CompoundTag compound, List<TradeRule> rules, String tag, HolderLookup.Provider lookup) {
        ListTag ruleData = new ListTag();
        for (TradeRule rule : rules) {
            CompoundTag thisRuleData = rule.savePersistentData(lookup);
            if (thisRuleData == null) continue;
            thisRuleData.putString("Type", rule.type.toString());
            ruleData.add((Object)thisRuleData);
        }
        if (ruleData.isEmpty()) {
            return false;
        }
        compound.put(tag, (Tag)ruleData);
        return true;
    }

    public static JsonArray saveRulesToJson(List<TradeRule> rules, HolderLookup.Provider lookup) {
        JsonArray ruleData = new JsonArray();
        for (TradeRule rule : rules) {
            JsonObject thisRuleData;
            if (!rule.isActive || (thisRuleData = rule.saveToJson(new JsonObject(), lookup)) == null) continue;
            thisRuleData.addProperty("Type", rule.type.toString());
            ruleData.add((JsonElement)thisRuleData);
        }
        return ruleData;
    }

    public static List<TradeRule> loadRules(CompoundTag compound, String tag, @Nullable ITradeRuleHost host, HolderLookup.Provider lookup) {
        ArrayList<TradeRule> rules = new ArrayList<TradeRule>();
        if (compound.contains(tag, 9)) {
            ListTag ruleData = compound.getList(tag, 10);
            ArrayList<CompoundTag> allData = new ArrayList<CompoundTag>();
            for (int i = 0; i < ruleData.size(); ++i) {
                allData.add(ruleData.getCompound(i));
            }
            LISTENERS.forEach(l -> l.beforeLoading(host, allData, rules));
            for (CompoundTag data : allData) {
                TradeRule thisRule = TradeRule.Deserialize(data, lookup);
                if (thisRule == null) continue;
                rules.add(thisRule);
                thisRule.host = host;
            }
            LISTENERS.forEach(l -> l.afterLoading(host, allData, rules));
        }
        return rules;
    }

    public static void loadPersistentData(CompoundTag compound, List<TradeRule> tradeRules, String tag, HolderLookup.Provider lookup) {
        if (compound.contains(tag, 9)) {
            ListTag ruleData = compound.getList(tag, 10);
            for (int i = 0; i < ruleData.size(); ++i) {
                CompoundTag thisRuleData = ruleData.getCompound(i);
                boolean query = true;
                for (int r = 0; query && r < tradeRules.size(); ++r) {
                    if (!tradeRules.get((int)r).type.toString().contentEquals(thisRuleData.getString("Type"))) continue;
                    tradeRules.get(r).loadPersistentData(thisRuleData, lookup);
                    query = false;
                }
            }
        }
    }

    public static List<TradeRule> Parse(JsonArray tradeRuleData, @Nullable ITradeRuleHost host, HolderLookup.Provider lookup) {
        ArrayList<TradeRule> rules = new ArrayList<TradeRule>();
        for (int i = 0; i < tradeRuleData.size(); ++i) {
            try {
                JsonObject thisRuleData = tradeRuleData.get(i).getAsJsonObject();
                TradeRule thisRule = TradeRule.Deserialize(thisRuleData, lookup);
                thisRule.host = host;
                rules.add(thisRule);
                continue;
            }
            catch (Throwable t) {
                LightmansCurrency.LogError("Error loading Trade Rule at index " + i + ".", t);
            }
        }
        return rules;
    }

    public static boolean ValidateTradeRuleList(List<TradeRule> rules, ITradeRuleHost host) {
        boolean changed = false;
        for (TradeRuleType<?> ruleType : TraderAPI.API.GetAllTradeRuleTypes()) {
            Object rule = ruleType.createNew();
            if (rule == null || !host.allowTradeRule((TradeRule)rule) || !((TradeRule)rule).allowHost(host) || TradeRule.HasTradeRule(rules, ((TradeRule)rule).type.type)) continue;
            rules.add((TradeRule)rule);
            ((TradeRule)rule).host = host;
            changed = true;
        }
        for (int i = 0; i < rules.size(); ++i) {
            TradeRule r1 = rules.get(i);
            for (int j = i + 1; j < rules.size(); ++j) {
                if (rules.get((int)j).type != r1.type) continue;
                rules.remove(j--);
                changed = true;
            }
        }
        return changed;
    }

    public static boolean ValidateTradeRuleActiveStates(List<TradeRule> rules) {
        boolean changed = false;
        for (TradeRule rule : rules) {
            if (!rule.isActive || rule.canActivate()) continue;
            rule.isActive = false;
            changed = true;
        }
        return changed;
    }

    public static boolean HasTradeRule(List<TradeRule> rules, ResourceLocation type) {
        return TradeRule.GetTradeRule(rules, type) != null;
    }

    @Nullable
    public static TradeRule GetTradeRule(List<TradeRule> rules, ResourceLocation type) {
        for (TradeRule rule : rules) {
            if (!rule.type.type.equals((Object)type)) continue;
            return rule;
        }
        return null;
    }

    @OnlyIn(value=Dist.CLIENT)
    public abstract TradeRulesClientSubTab createTab(TradeRulesClientTab<?> var1);

    public static TradeRule CreateRule(ResourceLocation type) {
        TradeRuleType<?> ruleType = TraderAPI.API.GetTradeRuleType(type);
        if (ruleType != null) {
            return ruleType.createNew();
        }
        LightmansCurrency.LogError("Could not find a TradeRuleType of type '" + String.valueOf(type) + "'. Unable to create the Trade Rule.");
        return null;
    }

    public static TradeRule Deserialize(CompoundTag compound, HolderLookup.Provider lookup) {
        String thisType = compound.contains("Type") ? compound.getString("Type") : compound.getString("type");
        TradeRuleType<?> ruleType = TraderAPI.API.GetTradeRuleType(VersionUtil.parseResource(thisType));
        if (ruleType != null) {
            return ruleType.load(compound, lookup);
        }
        if (IGNORE_MISSING.contains(thisType)) {
            return null;
        }
        LightmansCurrency.LogError("Could not find a TradeRuleType of type '" + thisType + "'. Unable to load the Trade Rule.");
        return null;
    }

    public static TradeRule Deserialize(JsonObject json, HolderLookup.Provider lookup) throws JsonSyntaxException, ResourceLocationException {
        String thisType = GsonHelper.getAsString((JsonObject)json, (String)"Type");
        TradeRuleType<?> ruleType = TraderAPI.API.GetTradeRuleType(VersionUtil.parseResource(thisType));
        if (ruleType != null) {
            Object rule = ruleType.loadFromJson(json, lookup);
            ((TradeRule)rule).setActive(true);
            return rule;
        }
        throw new JsonSyntaxException("Could not find a deserializer of type '" + thisType + "'.");
    }

    @Nullable
    public static TradeRule getRule(ResourceLocation type, List<TradeRule> rules) {
        for (TradeRule rule : rules) {
            if (!rule.type.type.equals((Object)type)) continue;
            return rule;
        }
        return null;
    }

    public static CompoundTag CreateRuleMessage() {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("Create", true);
        return tag;
    }

    public static CompoundTag RemoveRuleMessage() {
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("Remove", true);
        return tag;
    }

    public static boolean isCreateMessage(CompoundTag tag) {
        return tag.contains("Create") && tag.getBoolean("Create");
    }

    public static boolean isRemoveMessage(CompoundTag tag) {
        return tag.contains("Remove") && tag.getBoolean("Remove");
    }

    public static MoneyValue getBaseCost(TradeData trade, TradeContext context) {
        if (!context.hasTrader() || !trade.validCost()) {
            return trade.getCost();
        }
        InternalPriceEvent event = new InternalPriceEvent(trade, context);
        for (TradeRule rule : trade.getRules()) {
            if (!rule.isActive()) continue;
            rule.tradeBaseCost(event);
        }
        return event.getBaseCost();
    }

    protected static class InternalPriceEvent {
        public final TradeData trade;
        public final TradeContext context;
        private MoneyValue baseCost;

        public MoneyValue getBaseCost() {
            return this.baseCost;
        }

        public void setBaseCost(MoneyValue baseCost) {
            this.baseCost = Objects.requireNonNullElse(baseCost, MoneyValue.empty());
        }

        private InternalPriceEvent(TradeData trade, TradeContext context) {
            this.trade = trade;
            this.context = context;
            this.baseCost = trade.getCost();
        }
    }
}

