/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.client;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.trade.client.TradeRenderManager;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.AlertData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayData;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.DisplayEntry;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.display.EmptySlotEntry;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.display.ItemAndBackgroundEntry;
import io.github.lightman314.lightmanscurrency.client.util.ScreenPosition;
import io.github.lightman314.lightmanscurrency.common.menus.slots.easy.EasySlot;
import io.github.lightman314.lightmanscurrency.common.traders.item.ItemTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ItemTradeButtonRenderer
extends TradeRenderManager<ItemTradeData> {
    public static final ResourceLocation NBT_SLOT = VersionUtil.lcResource("item/empty_nbt_highlight");
    public static final Pair<ResourceLocation, ResourceLocation> NBT_BACKGROUND = Pair.of((Object)InventoryMenu.BLOCK_ATLAS, (Object)NBT_SLOT);

    public ItemTradeButtonRenderer(ItemTradeData trade) {
        super(trade);
    }

    @Override
    public int tradeButtonWidth(TradeContext context) {
        return 94;
    }

    @Override
    public Optional<ScreenPosition> arrowPosition(TradeContext context) {
        return ScreenPosition.ofOptional(36, 1);
    }

    @Override
    public DisplayData inputDisplayArea(TradeContext context) {
        return new DisplayData(1, 1, 34, 16);
    }

    @Override
    public List<DisplayEntry> getInputDisplays(TradeContext context) {
        if (((ItemTradeData)this.trade).isSale()) {
            return this.lazyPriceDisplayList(context);
        }
        if (((ItemTradeData)this.trade).isPurchase()) {
            return this.getSaleItemEntries(context);
        }
        if (((ItemTradeData)this.trade).isBarter()) {
            return this.getBarterItemEntries(context);
        }
        return new ArrayList<DisplayEntry>();
    }

    @Override
    public DisplayData outputDisplayArea(TradeContext context) {
        return new DisplayData(59, 1, 34, 16);
    }

    @Override
    public List<DisplayEntry> getOutputDisplays(TradeContext context) {
        if (((ItemTradeData)this.trade).isSale() || ((ItemTradeData)this.trade).isBarter()) {
            return this.getSaleItemEntries(context);
        }
        if (((ItemTradeData)this.trade).isPurchase()) {
            return this.lazyPriceDisplayList(context);
        }
        return new ArrayList<DisplayEntry>();
    }

    private List<DisplayEntry> getSaleItemEntries(TradeContext context) {
        ArrayList<DisplayEntry> entries = new ArrayList<DisplayEntry>();
        for (int i = 0; i < 2; ++i) {
            ItemStack item = ((ItemTradeData)this.trade).getSellItem(i);
            if (!item.isEmpty()) {
                entries.add(ItemAndBackgroundEntry.of(item, this.getSaleItemTooltip(item, ((ItemTradeData)this.trade).getCustomName(i), ((ItemTradeData)this.trade).getEnforceNBT(i), context), this.getNBTHightlight(((ItemTradeData)this.trade).getEnforceNBT(i))));
                continue;
            }
            if (!context.isStorageMode) continue;
            entries.add(this.makeEmptySlot(((ItemTradeData)this.trade).getRestriction().getEmptySlotBG(), context));
        }
        return entries;
    }

    private Consumer<List<Component>> getSaleItemTooltip(ItemStack stack, String customName, boolean enforceNBT, TradeContext context) {
        return tooltips -> {
            TraderData patt0$temp;
            Component originalName = null;
            if (!customName.isEmpty() && (((ItemTradeData)this.trade).isSale() || ((ItemTradeData)this.trade).isBarter())) {
                originalName = stack.getHoverName();
                tooltips.set(0, EasyText.literal(customName).withStyle(ChatFormatting.GOLD));
            }
            this.addNBTWarning((List<Component>)tooltips, ((ItemTradeData)this.trade).isPurchase(), enforceNBT);
            this.addItemEditInfo((List<Component>)tooltips, context.isStorageMode, context);
            if (context.isStorageMode && originalName == null) {
                return;
            }
            tooltips.add(LCText.TOOLTIP_TRADE_INFO_TITLE.getWithStyle(ChatFormatting.GOLD));
            if (originalName != null) {
                tooltips.add(LCText.TOOLTIP_TRADE_INFO_ORIGINAL_NAME.get(originalName).withStyle(ChatFormatting.GOLD));
            }
            if (context.hasTrader() && context.hasPlayerReference() && (patt0$temp = context.getTrader()) instanceof ItemTraderData) {
                ItemTraderData trader = (ItemTraderData)patt0$temp;
                tooltips.add(this.getStockTooltip(trader.isCreative(), ((ItemTradeData)this.trade).getStock(context)));
            }
        };
    }

    private List<DisplayEntry> getBarterItemEntries(TradeContext context) {
        ArrayList<DisplayEntry> entries = new ArrayList<DisplayEntry>();
        for (int i = 0; i < 2; ++i) {
            ItemStack item = ((ItemTradeData)this.trade).getBarterItem(i);
            if (!item.isEmpty()) {
                entries.add(ItemAndBackgroundEntry.of(item, this.getBarterTooltips(((ItemTradeData)this.trade).getEnforceNBT(i + 2), context.isStorageMode, context), this.getNBTHightlight(((ItemTradeData)this.trade).getEnforceNBT(i + 2))));
                continue;
            }
            if (!context.isStorageMode) continue;
            entries.add(this.makeEmptySlot(EasySlot.BACKGROUND, context));
        }
        return entries;
    }

    private DisplayEntry makeEmptySlot(Pair<ResourceLocation, ResourceLocation> background, TradeContext context) {
        return EmptySlotEntry.of(background, this.hasPermission(context, "editTrades") ? LCText.TOOLTIP_TRADE_ITEM_EDIT_EMPTY.getAsListWithStyle(ChatFormatting.YELLOW) : null);
    }

    private Pair<ResourceLocation, ResourceLocation> getNBTHightlight(boolean enforceNBT) {
        return enforceNBT ? null : NBT_BACKGROUND;
    }

    private void addItemEditInfo(@Nonnull List<Component> tooltips, boolean isStorageMode, TradeContext context) {
        if (isStorageMode && this.hasPermission(context, "editTrades")) {
            tooltips.addFirst((Component)LCText.TOOLTIP_TRADE_ITEM_EDIT_SHIFT.getWithStyle(ChatFormatting.YELLOW));
        }
    }

    private void addNBTWarning(@Nonnull List<Component> tooltips, boolean purchase, boolean enforceNBT) {
        if (!enforceNBT) {
            tooltips.addFirst((Component)(purchase ? LCText.TOOLTIP_TRADE_ITEM_NBT_WARNING_PURCHASE.get(new Object[0]) : LCText.TOOLTIP_TRADE_ITEM_NBT_WARNING_SALE.get(new Object[0])).withStyle(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.BOLD}));
        }
    }

    private Consumer<List<Component>> getBarterTooltips(boolean enforceNBT, boolean isStorageMode, TradeContext context) {
        return tooltips -> {
            this.addNBTWarning((List<Component>)tooltips, true, enforceNBT);
            this.addItemEditInfo((List<Component>)tooltips, isStorageMode, context);
        };
    }

    @Override
    protected void getAdditionalAlertData(TradeContext context, List<AlertData> alerts) {
        TraderData traderData;
        if (context.hasTrader() && (traderData = context.getTrader()) instanceof ItemTraderData) {
            ItemTraderData trader = (ItemTraderData)traderData;
            if (!trader.isCreative()) {
                if (((ItemTradeData)this.trade).outOfStock(context)) {
                    alerts.add(AlertData.warn(LCText.TOOLTIP_OUT_OF_STOCK));
                }
                if (((ItemTradeData)this.trade).isPurchase() && !((ItemTradeData)this.trade).hasSpace(trader, context.getCollectableItems(((ItemTradeData)this.trade).getItemRequirement(0), ((ItemTradeData)this.trade).getItemRequirement(1)))) {
                    alerts.add(AlertData.warn(LCText.TOOLTIP_OUT_OF_SPACE));
                }
                if (((ItemTradeData)this.trade).isBarter() && !((ItemTradeData)this.trade).hasSpace(trader, context.getCollectableItems(((ItemTradeData)this.trade).getItemRequirement(2), ((ItemTradeData)this.trade).getItemRequirement(3)))) {
                    alerts.add(AlertData.warn(LCText.TOOLTIP_OUT_OF_SPACE));
                }
            }
            if (!((ItemTradeData)this.trade).canAfford(context)) {
                alerts.add(AlertData.warn(LCText.TOOLTIP_CANNOT_AFFORD));
            }
        }
    }
}

