/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.traders.item;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.stats.StatKeys;
import io.github.lightman314.lightmanscurrency.api.traders.IFlexibleOfferTrader;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TradeResult;
import io.github.lightman314.lightmanscurrency.api.traders.TraderType;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.upgrades.UpgradeType;
import io.github.lightman314.lightmanscurrency.common.blockentity.handler.TraderItemHandler;
import io.github.lightman314.lightmanscurrency.common.items.UpgradeItem;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.item.ItemStorageTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.item.ItemTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.notifications.types.settings.AddRemoveTradeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.ItemTradeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.trader.OutOfStockNotification;
import io.github.lightman314.lightmanscurrency.common.player.LCAdminMode;
import io.github.lightman314.lightmanscurrency.common.traders.InputTraderData;
import io.github.lightman314.lightmanscurrency.common.traders.item.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.common.traders.item.tradedata.restrictions.ItemTradeRestriction;
import io.github.lightman314.lightmanscurrency.common.traders.permissions.Permissions;
import io.github.lightman314.lightmanscurrency.common.traders.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.common.upgrades.Upgrades;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.capacity.CapacityUpgrade;
import io.github.lightman314.lightmanscurrency.common.upgrades.types.capacity.TradeOfferUpgrade;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import io.github.lightman314.lightmanscurrency.util.FileUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ItemTraderData
extends InputTraderData
implements TraderItemStorage.ITraderItemFilter,
IFlexibleOfferTrader,
TraderItemHandler.IItemStorageProvider {
    public static final List<UpgradeType> ALLOWED_UPGRADES = Lists.newArrayList((Object[])new UpgradeType[]{Upgrades.ITEM_CAPACITY, Upgrades.TRADE_OFFERS});
    public static final int DEFAULT_STACK_LIMIT = 576;
    public static final TraderType<ItemTraderData> TYPE = new TraderType<ItemTraderData>(VersionUtil.lcResource("item_trader"), ItemTraderData::new);
    TraderItemHandler<ItemTraderData> itemHandler = new TraderItemHandler<ItemTraderData>(this);
    protected TraderItemStorage storage = new TraderItemStorage(this);
    private int baseTradeCount = 0;
    protected List<ItemTradeData> trades;

    public IItemHandler getItemHandler(Direction relativeSide) {
        return this.itemHandler.getHandler(relativeSide);
    }

    @Override
    @Nonnull
    public final TraderItemStorage getStorage() {
        return this.storage;
    }

    @Override
    public void markStorageDirty() {
        this.markDirty(this::saveStorage);
    }

    @Override
    public boolean allowAdditionalUpgradeType(UpgradeType type) {
        return ALLOWED_UPGRADES.contains(type);
    }

    private ItemTraderData() {
        this(TYPE);
    }

    protected ItemTraderData(TraderType<?> type) {
        super(type);
        this.trades = ItemTradeData.listOfSize(1, true);
        this.validateTradeRestrictions();
    }

    public ItemTraderData(int tradeCount, Level level, BlockPos pos) {
        this(TYPE, tradeCount, level, pos);
    }

    protected ItemTraderData(TraderType<?> type, int tradeCount, Level level, BlockPos pos) {
        super(type, level, pos);
        this.trades = ItemTradeData.listOfSize(tradeCount, true);
        this.baseTradeCount = tradeCount;
        this.validateTradeRestrictions();
    }

    @Override
    protected boolean allowVoidUpgrade() {
        return true;
    }

    @Override
    public void saveAdditional(CompoundTag compound, HolderLookup.Provider lookup) {
        super.saveAdditional(compound, lookup);
        this.saveStorage(compound, lookup);
        this.saveTrades(compound, lookup);
    }

    protected final void saveStorage(CompoundTag compound, HolderLookup.Provider lookup) {
        this.storage.save(compound, "ItemStorage", lookup);
    }

    @Override
    protected final void saveTrades(CompoundTag compound, HolderLookup.Provider lookup) {
        compound.putInt("BaseTradeCount", this.baseTradeCount);
        ItemTradeData.saveAllData(compound, this.trades, lookup);
    }

    @Override
    public void loadAdditional(CompoundTag compound, HolderLookup.Provider lookup) {
        super.loadAdditional(compound, lookup);
        if (compound.contains("ItemStorage")) {
            this.storage.load(compound, "ItemStorage", lookup);
        }
        if (compound.contains("Trades")) {
            this.trades = ItemTradeData.loadAllData(compound, !this.isPersistent(), lookup);
            this.validateTradeRestrictions();
        }
        if (compound.contains("BaseTradeCount")) {
            this.baseTradeCount = compound.getInt("BaseTradeCount");
        }
        if (this.baseTradeCount <= 0) {
            this.baseTradeCount = this.trades.size();
        }
    }

    @Override
    public int getTradeCount() {
        return this.trades.size();
    }

    @Override
    public void addTrade(Player requestor) {
        if (this.isClient()) {
            return;
        }
        if (LCAdminMode.isAdminPlayer(requestor) && this.baseTradeCount < 100) {
            ++this.baseTradeCount;
            this.refactorTrades();
            this.pushLocalNotification(new AddRemoveTradeNotification(PlayerReference.of(requestor), true, this.getTradeCount()));
        } else {
            Permissions.PermissionWarning(requestor, "add a trade slot", "LC_ADMIN_MODE");
        }
    }

    @Override
    public void removeTrade(Player requestor) {
        if (this.isClient()) {
            return;
        }
        if (LCAdminMode.isAdminPlayer(requestor) && this.baseTradeCount > 1) {
            --this.baseTradeCount;
            this.refactorTrades();
            this.pushLocalNotification(new AddRemoveTradeNotification(PlayerReference.of(requestor), false, this.getTradeCount()));
        } else {
            Permissions.PermissionWarning(requestor, "remove a trade slot", "LC_ADMIN_MODE");
        }
    }

    @Override
    public final void refactorTrades() {
        int newCount = MathUtil.clamp(this.baseTradeCount + TradeOfferUpgrade.getBonusTrades(this.getUpgrades()), 1, 100);
        if (newCount != this.trades.size()) {
            this.overrideTradeCount(newCount);
        }
    }

    public void overrideTradeCount(int newTradeCount) {
        int tradeCount = MathUtil.clamp(newTradeCount, 1, 100);
        if (this.trades.size() == tradeCount) {
            return;
        }
        List<ItemTradeData> oldTrades = this.trades;
        this.trades = ItemTradeData.listOfSize(tradeCount, !this.isPersistent());
        for (int i = 0; i < oldTrades.size() && i < this.trades.size(); ++i) {
            this.trades.set(i, oldTrades.get(i));
        }
        this.validateTradeRestrictions();
        if (this.isServer()) {
            this.markTradesDirty();
        }
    }

    public final void validateTradeRestrictions() {
        for (int i = 0; i < this.trades.size(); ++i) {
            ItemTradeData trade = this.trades.get(i);
            trade.setRestriction(this.getTradeRestriction(i));
        }
    }

    protected ItemTradeRestriction getTradeRestriction(int tradeIndex) {
        return ItemTradeRestriction.NONE;
    }

    @Override
    public ItemTradeData getTrade(int tradeSlot) {
        if (tradeSlot < 0 || tradeSlot >= this.trades.size()) {
            LightmansCurrency.LogError("Cannot get trade in index " + tradeSlot + " from a trader with only " + this.trades.size() + " trades.");
            return new ItemTradeData(false);
        }
        return this.trades.get(tradeSlot);
    }

    public List<ItemTradeData> getTradeData() {
        return this.trades;
    }

    @Override
    public int getTradeStock(int tradeSlot) {
        ItemTradeData trade = this.getTrade(tradeSlot);
        if (trade.sellItemsDefined()) {
            if (this.isCreative()) {
                return Integer.MAX_VALUE;
            }
            return trade.stockCount(this);
        }
        return 0;
    }

    @Override
    public IconData inputSettingsTabIcon() {
        return IconData.of((ItemLike)Items.HOPPER);
    }

    @Override
    public MutableComponent inputSettingsTabTooltip() {
        return LCText.TOOLTIP_TRADER_SETTINGS_INPUT_ITEM.get(new Object[0]);
    }

    @Override
    public IconData getIcon() {
        return IconUtil.ICON_TRADER;
    }

    @Override
    protected void saveAdditionalToJson(JsonObject json, HolderLookup.Provider lookup) {
        JsonArray trades = new JsonArray();
        for (ItemTradeData trade : this.trades) {
            JsonArray ruleData;
            if (!trade.isValid()) continue;
            JsonObject tradeData = new JsonObject();
            JsonArray ignoreNBTData = new JsonArray();
            tradeData.addProperty("TradeType", trade.getTradeDirection().name());
            if (trade.getSellItem(0).isEmpty()) {
                tradeData.add("SellItem", FileUtil.convertItemStack(trade.getSellItem(1), lookup));
                if (trade.hasCustomName(1)) {
                    tradeData.addProperty("DisplayName", trade.getCustomName(1));
                }
                if (!trade.getEnforceNBT(1)) {
                    ignoreNBTData.add((Number)0);
                }
            } else {
                tradeData.add("SellItem", FileUtil.convertItemStack(trade.getSellItem(0), lookup));
                if (trade.hasCustomName(0)) {
                    tradeData.addProperty("DisplayName", trade.getCustomName(0));
                }
                if (!trade.getEnforceNBT(0)) {
                    ignoreNBTData.add((Number)0);
                }
                if (!trade.getSellItem(1).isEmpty()) {
                    tradeData.add("SellItem2", FileUtil.convertItemStack(trade.getSellItem(1), lookup));
                    if (trade.hasCustomName(1)) {
                        tradeData.addProperty("DisplayName2", trade.getCustomName(1));
                    }
                    if (!trade.getEnforceNBT(1)) {
                        ignoreNBTData.add((Number)1);
                    }
                }
            }
            if (trade.isSale() || trade.isPurchase()) {
                tradeData.add("Price", (JsonElement)trade.getCost().toJson());
            }
            if (trade.isBarter()) {
                if (trade.getBarterItem(0).isEmpty()) {
                    tradeData.add("BarterItem", FileUtil.convertItemStack(trade.getBarterItem(1), lookup));
                    if (!trade.getEnforceNBT(3)) {
                        ignoreNBTData.add((Number)2);
                    }
                } else {
                    tradeData.add("BarterItem", FileUtil.convertItemStack(trade.getBarterItem(0), lookup));
                    if (!trade.getEnforceNBT(2)) {
                        ignoreNBTData.add((Number)2);
                    }
                    if (!trade.getBarterItem(1).isEmpty()) {
                        tradeData.add("BarterItem2", FileUtil.convertItemStack(trade.getBarterItem(1), lookup));
                        if (!trade.getEnforceNBT(3)) {
                            ignoreNBTData.add((Number)3);
                        }
                    }
                }
            }
            if (!ignoreNBTData.isEmpty()) {
                tradeData.add("IgnoreNBT", (JsonElement)ignoreNBTData);
            }
            if (!(ruleData = TradeRule.saveRulesToJson(trade.getRules(), lookup)).isEmpty()) {
                tradeData.add("Rules", (JsonElement)ruleData);
            }
            trades.add((JsonElement)tradeData);
        }
        JsonArray storageData = new JsonArray();
        for (ItemStack item : this.storage.getContents()) {
            boolean shouldWrite = false;
            for (int i = 0; i < this.trades.size() && !shouldWrite; ++i) {
                ItemTradeData trade = this.trades.get(i);
                if (!trade.isValid() || !trade.shouldStorageItemBeSaved(item)) continue;
                shouldWrite = true;
            }
            if (!shouldWrite) continue;
            storageData.add(FileUtil.convertItemStack(item, lookup));
        }
        if (!storageData.isEmpty()) {
            json.add("RelevantStorage", (JsonElement)storageData);
        }
        json.add("Trades", (JsonElement)trades);
    }

    @Override
    protected void loadAdditionalFromJson(JsonObject json, HolderLookup.Provider lookup) throws JsonSyntaxException, ResourceLocationException {
        JsonArray trades = GsonHelper.getAsJsonArray((JsonObject)json, (String)"Trades");
        this.trades = new ArrayList<ItemTradeData>();
        for (int i = 0; i < trades.size() && this.trades.size() < 100; ++i) {
            try {
                JsonObject tradeData = trades.get(i).getAsJsonObject();
                ItemTradeData newTrade = new ItemTradeData(false);
                newTrade.setItem(FileUtil.parseItemStack(GsonHelper.getAsJsonObject((JsonObject)tradeData, (String)"SellItem"), lookup), 0);
                if (tradeData.has("SellItem2")) {
                    newTrade.setItem(FileUtil.parseItemStack(GsonHelper.getAsJsonObject((JsonObject)tradeData, (String)"SellItem2"), lookup), 1);
                }
                if (tradeData.has("TradeType")) {
                    newTrade.setTradeType(ItemTradeData.loadTradeType(GsonHelper.getAsString((JsonObject)tradeData, (String)"TradeType")));
                }
                if (tradeData.has("Price")) {
                    if (newTrade.isBarter()) {
                        LightmansCurrency.LogWarning("Price is being defined for a barter trade. Price will be ignored.");
                    } else {
                        newTrade.setCost(MoneyValue.loadFromJson(tradeData.get("Price")));
                    }
                } else if (!newTrade.isBarter()) {
                    LightmansCurrency.LogWarning("Price is not defined on a non-barter trade. Price will be assumed to be free.");
                    newTrade.setCost(MoneyValue.free());
                }
                if (tradeData.has("BarterItem")) {
                    if (newTrade.isBarter()) {
                        newTrade.setItem(FileUtil.parseItemStack(GsonHelper.getAsJsonObject((JsonObject)tradeData, (String)"BarterItem"), lookup), 2);
                        if (tradeData.has("BarterItem2")) {
                            newTrade.setItem(FileUtil.parseItemStack(GsonHelper.getAsJsonObject((JsonObject)tradeData, (String)"BarterItem2"), lookup), 3);
                        }
                    } else {
                        LightmansCurrency.LogWarning("BarterItem is being defined for a non-barter trade. Barter item will be ignored.");
                    }
                }
                if (tradeData.has("DisplayName")) {
                    newTrade.setCustomName(0, GsonHelper.getAsString((JsonObject)tradeData, (String)"DisplayName"));
                }
                if (tradeData.has("DisplayName2")) {
                    newTrade.setCustomName(1, GsonHelper.getAsString((JsonObject)tradeData, (String)"DisplayName2"));
                }
                if (tradeData.has("Rules")) {
                    newTrade.setRules(TradeRule.Parse(GsonHelper.getAsJsonArray((JsonObject)tradeData, (String)"Rules"), newTrade, lookup));
                }
                if (tradeData.has("IgnoreNBT")) {
                    JsonArray ignoreNBTData = GsonHelper.getAsJsonArray((JsonObject)tradeData, (String)"IgnoreNBT");
                    for (int j = 0; j < ignoreNBTData.size(); ++j) {
                        int slot = ignoreNBTData.get(j).getAsInt();
                        newTrade.setEnforceNBT(slot, false);
                    }
                }
                this.trades.add(newTrade);
                continue;
            }
            catch (Exception e) {
                LightmansCurrency.LogError("Error parsing item trade at index " + i, e);
            }
        }
        if (this.trades.isEmpty()) {
            throw new JsonSyntaxException("Trader has no valid trades!");
        }
        ArrayList<ItemStack> storage = new ArrayList<ItemStack>();
        if (json.has("RelevantStorage")) {
            JsonArray storageData = json.getAsJsonArray("RelevantStorage");
            for (int i = 0; i < storageData.size(); ++i) {
                try {
                    ItemStack item = FileUtil.parseItemStack(storageData.get(i).getAsJsonObject(), lookup);
                    storage.add(item);
                    continue;
                }
                catch (JsonSyntaxException | ResourceLocationException e) {
                    LightmansCurrency.LogError("Error parsing storage item at index " + i, e);
                }
            }
        }
        this.storage = new TraderItemStorage.LockedTraderStorage(this, storage);
    }

    @Override
    protected void saveAdditionalPersistentData(CompoundTag compound, HolderLookup.Provider lookup) {
        ListTag tradePersistentData = new ListTag();
        boolean tradesAreRelevant = false;
        Iterator<ItemTradeData> iterator = this.trades.iterator();
        while (iterator.hasNext()) {
            CompoundTag ptTag = new CompoundTag();
            ItemTradeData trade = iterator.next();
            if (TradeRule.savePersistentData(ptTag, trade.getRules(), "RuleData", lookup)) {
                tradesAreRelevant = true;
            }
            tradePersistentData.add((Object)ptTag);
        }
        if (tradesAreRelevant) {
            compound.put("PersistentTradeData", (Tag)tradePersistentData);
        }
    }

    @Override
    protected void loadAdditionalPersistentData(CompoundTag compound, HolderLookup.Provider lookup) {
        if (compound.contains("PersistentTradeData")) {
            ListTag tradePersistentData = compound.getList("PersistentTradeData", 10);
            for (int i = 0; i < tradePersistentData.size() && i < this.trades.size(); ++i) {
                ItemTradeData trade = this.trades.get(i);
                CompoundTag ptTag = tradePersistentData.getCompound(i);
                TradeRule.loadPersistentData(ptTag, trade.getRules(), "RuleData", lookup);
            }
        }
    }

    @Override
    protected void getAdditionalContents(List<ItemStack> results) {
        results.addAll(this.storage.getSplitContents());
    }

    @Override
    protected TradeResult ExecuteTrade(TradeContext context, int tradeIndex) {
        ItemTradeData trade = this.getTrade(tradeIndex);
        if (trade == null) {
            return TradeResult.FAIL_INVALID_TRADE;
        }
        if (!trade.isValid()) {
            return TradeResult.FAIL_INVALID_TRADE;
        }
        if (!context.hasPlayerReference()) {
            return TradeResult.FAIL_NULL;
        }
        if (this.runPreTradeEvent(trade, context).isCanceled()) {
            return TradeResult.FAIL_TRADE_RULE_DENIAL;
        }
        MoneyValue price = trade.getCost(context);
        if (trade.isSale()) {
            if (trade.outOfStock(context) && !this.isCreative()) {
                return TradeResult.FAIL_OUT_OF_STOCK;
            }
            List<ItemStack> soldItems = trade.getRandomSellItems(this);
            if (soldItems == null) {
                return TradeResult.FAIL_OUT_OF_STOCK;
            }
            if (!context.canFitItems(soldItems)) {
                return TradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            if (!context.getPayment(price)) {
                return TradeResult.FAIL_CANNOT_AFFORD;
            }
            for (int i = 0; i < soldItems.size(); ++i) {
                if (context.putItem(soldItems.get(i))) continue;
                LightmansCurrency.LogError("Not enough room for the output item. Giving refund & aborting Trade!");
                for (int x = 0; x < i; ++x) {
                    context.collectItem(soldItems.get(x));
                }
                context.givePayment(price);
                return TradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            MoneyValue taxesPaid = MoneyValue.empty();
            if (this.canStoreMoney()) {
                taxesPaid = this.addStoredMoney(price, true);
            }
            if (!this.isCreative()) {
                trade.RemoveItemsFromStorage(this.getStorage(), soldItems);
                this.markStorageDirty();
                if (!trade.hasStock(this)) {
                    this.pushNotification(OutOfStockNotification.create(this.getNotificationCategory(), tradeIndex));
                }
            }
            this.incrementStat(StatKeys.Traders.MONEY_EARNED, price);
            if (!taxesPaid.isEmpty()) {
                this.incrementStat(StatKeys.Taxables.TAXES_PAID, taxesPaid);
            }
            this.pushNotification(ItemTradeNotification.create(trade, price, context.getPlayerReference(), this.getNotificationCategory(), taxesPaid));
            this.runPostTradeEvent(trade, context, price, taxesPaid);
            return TradeResult.SUCCESS;
        }
        if (trade.isPurchase()) {
            List<ItemStack> collectableItems = context.getCollectableItems(trade.getItemRequirement(0), trade.getItemRequirement(1));
            if (!context.hasItems(collectableItems)) {
                return TradeResult.FAIL_CANNOT_AFFORD;
            }
            if (!trade.hasSpace(this, collectableItems) && !this.isCreative()) {
                return TradeResult.FAIL_NO_INPUT_SPACE;
            }
            if (trade.outOfStock(context) && !this.isCreative()) {
                return TradeResult.FAIL_OUT_OF_STOCK;
            }
            context.collectItems(collectableItems);
            context.givePayment(price);
            MoneyValue taxesPaid = MoneyValue.empty();
            if (this.shouldStoreGoods()) {
                for (ItemStack item : collectableItems) {
                    this.getStorage().forceAddItem(item);
                }
                this.markStorageDirty();
                if (!trade.hasStock(this)) {
                    this.pushNotification(OutOfStockNotification.create(this.getNotificationCategory(), tradeIndex));
                }
            }
            if (!this.isCreative()) {
                taxesPaid = this.removeStoredMoney(price, true);
            }
            this.incrementStat(StatKeys.Traders.MONEY_PAID, price);
            if (!taxesPaid.isEmpty()) {
                this.incrementStat(StatKeys.Taxables.TAXES_PAID, taxesPaid);
            }
            this.pushNotification(ItemTradeNotification.create(trade, price, context.getPlayerReference(), this.getNotificationCategory(), taxesPaid));
            this.runPostTradeEvent(trade, context, price, taxesPaid);
            return TradeResult.SUCCESS;
        }
        if (trade.isBarter()) {
            List<ItemStack> collectableItems = context.getCollectableItems(trade.getItemRequirement(2), trade.getItemRequirement(3));
            if (collectableItems == null) {
                return TradeResult.FAIL_CANNOT_AFFORD;
            }
            if (!trade.hasSpace(this, collectableItems) && !this.isCreative()) {
                return TradeResult.FAIL_NO_INPUT_SPACE;
            }
            if (trade.outOfStock(context) && !this.isCreative()) {
                return TradeResult.FAIL_OUT_OF_STOCK;
            }
            List<ItemStack> soldItems = trade.getRandomSellItems(this);
            if (soldItems == null) {
                return TradeResult.FAIL_OUT_OF_STOCK;
            }
            if (!context.canFitItems(soldItems)) {
                return TradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            context.collectItems(collectableItems);
            for (int i = 0; i < soldItems.size(); ++i) {
                if (context.putItem(soldItems.get(i))) continue;
                LightmansCurrency.LogError("Not enough room for the output item. Giving refund & aborting Trade!");
                for (int x = 0; x < i; ++x) {
                    context.collectItem(soldItems.get(x));
                }
                context.givePayment(price);
                return TradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            this.pushNotification(ItemTradeNotification.create(trade, price, context.getPlayerReference(), this.getNotificationCategory(), MoneyValue.empty()));
            boolean storageChanged = false;
            if (this.shouldStoreGoods()) {
                for (ItemStack item : collectableItems) {
                    this.storage.forceAddItem(item);
                }
                storageChanged = true;
            }
            if (!this.isCreative()) {
                trade.RemoveItemsFromStorage(this.getStorage(), soldItems);
                storageChanged = true;
                if (!trade.hasStock(this)) {
                    this.pushNotification(OutOfStockNotification.create(this.getNotificationCategory(), tradeIndex));
                }
            }
            if (storageChanged) {
                this.markStorageDirty();
            }
            this.runPostTradeEvent(trade, context, price, MoneyValue.empty());
            return TradeResult.SUCCESS;
        }
        return TradeResult.FAIL_INVALID_TRADE;
    }

    @Override
    public boolean canMakePersistent() {
        return true;
    }

    @Override
    public void initStorageTabs(ITraderStorageMenu menu) {
        menu.setTab(1, new ItemStorageTab(menu));
        menu.setTab(2, new ItemTradeEditTab(menu));
    }

    @Override
    public boolean isItemRelevant(ItemStack item) {
        for (ItemTradeData trade : this.trades) {
            if (!trade.allowItemInStorage(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allowExtraction(ItemStack stack) {
        for (ItemTradeData trade : this.trades) {
            if (!trade.isValid() || !trade.isSale() && !trade.isBarter()) continue;
            for (int i = 0; i < 2; ++i) {
                if (!trade.getItemRequirement(i).test(stack)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public int getStorageStackLimit() {
        int limit = 576;
        for (int i = 0; i < this.getUpgrades().getContainerSize(); ++i) {
            UpgradeItem upgradeItem;
            ItemStack stack = this.getUpgrades().getItem(i);
            Item item = stack.getItem();
            if (!(item instanceof UpgradeItem) || !this.allowUpgrade(upgradeItem = (UpgradeItem)item) || upgradeItem.getUpgradeType() != Upgrades.ITEM_CAPACITY) continue;
            limit += UpgradeItem.getUpgradeData(stack).getIntValue(CapacityUpgrade.CAPACITY);
        }
        return limit;
    }

    @Override
    protected void appendTerminalInfo(List<Component> list, @Nullable Player player) {
        int tradeCount = 0;
        int outOfStock = 0;
        for (ItemTradeData trade : this.trades) {
            if (!trade.isValid()) continue;
            ++tradeCount;
            if (this.isCreative() || trade.hasStock(this)) continue;
            ++outOfStock;
        }
        list.add((Component)LCText.TOOLTIP_NETWORK_TERMINAL_TRADE_COUNT.get(tradeCount));
        if (outOfStock > 0) {
            list.add((Component)LCText.TOOLTIP_NETWORK_TERMINAL_OUT_OF_STOCK_COUNT.get(outOfStock));
        }
    }
}

