/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.validation;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidatorType;
import io.github.lightman314.lightmanscurrency.common.menus.validation.types.SimpleValidator;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public abstract class MenuValidator {
    public final MenuValidatorType type;

    protected MenuValidator(MenuValidatorType type) {
        this.type = type;
    }

    public final void encode(FriendlyByteBuf buffer) {
        buffer.writeUtf(this.type.type.toString());
        this.encodeAdditional(buffer);
    }

    protected abstract void encodeAdditional(@Nonnull FriendlyByteBuf var1);

    public final void save() {
        CompoundTag tag = new CompoundTag();
        this.saveAdditional(tag);
        tag.putString("Type", this.type.type.toString());
    }

    protected abstract void saveAdditional(@Nonnull CompoundTag var1);

    public abstract boolean stillValid(@Nonnull Player var1);

    @Nonnull
    public static MenuValidator decode(@Nonnull FriendlyByteBuf buffer) {
        try {
            ResourceLocation type = VersionUtil.parseResource(buffer.readUtf());
            MenuValidatorType decoder = MenuValidatorType.getType(type);
            if (decoder != null) {
                return decoder.decode(buffer);
            }
            LightmansCurrency.LogError("Could not decode MenuValidator of type '" + String.valueOf(type) + "'!");
            return SimpleValidator.NULL;
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error decoding MenuValidator!");
            return SimpleValidator.NULL;
        }
    }

    @Nonnull
    public static MenuValidator load(@Nonnull CompoundTag tag) {
        try {
            ResourceLocation type = VersionUtil.parseResource(tag.getString("Type"));
            MenuValidatorType decoder = MenuValidatorType.getType(type);
            if (decoder != null) {
                return decoder.load(tag);
            }
            LightmansCurrency.LogError("Could not load MenuValidator of type '" + String.valueOf(type) + "'!");
            return SimpleValidator.NULL;
        }
        catch (Throwable t) {
            LightmansCurrency.LogError("Error loading MenuValidator!");
            return SimpleValidator.NULL;
        }
    }
}

