/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus.slot_machine;

import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.value.IItemBasedValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyStorage;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyHolder;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class ResultHolder {
    private final Container items;
    private final IItemHandler itemHandler;
    private final MoneyStorage money;

    public ResultHolder() {
        this.items = new SimpleContainer(4);
        this.itemHandler = new InvWrapper(this.items);
        this.money = new MoneyStorage(() -> {}, Integer.MIN_VALUE);
    }

    private ResultHolder(Container items, MoneyStorage money) {
        this.items = items;
        this.itemHandler = new InvWrapper(this.items);
        this.money = money;
    }

    public IItemHandler itemHandler() {
        return this.itemHandler;
    }

    public IMoneyHolder moneyHolder() {
        return this.money;
    }

    public boolean isEmpty() {
        return this.items.isEmpty() && this.money.isEmpty();
    }

    public void giveToPlayer(Player player) {
        for (int i = 0; i < this.items.getContainerSize(); ++i) {
            ItemStack item = this.items.getItem(i);
            if (item.isEmpty()) continue;
            ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)item);
        }
        IMoneyHolder handler = MoneyAPI.API.GetPlayersMoneyHandler(player);
        for (MoneyValue val : this.money.allValues()) {
            handler.insertMoney(val, false);
        }
    }

    public List<ItemStack> getDisplayItems() {
        if (!this.money.isEmpty()) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            for (MoneyValue value : this.money.allValues()) {
                if (!(value instanceof IItemBasedValue)) continue;
                IItemBasedValue itemValue = (IItemBasedValue)((Object)value);
                items.addAll(itemValue.getAsSeperatedItemList());
            }
            return items;
        }
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < this.items.getContainerSize(); ++i) {
            ItemStack item = this.items.getItem(i);
            if (item.isEmpty()) continue;
            items.add(item);
        }
        return items;
    }

    public CompoundTag save(HolderLookup.Provider lookup) {
        CompoundTag tag = new CompoundTag();
        InventoryUtil.saveAllItems("items", tag, this.items, lookup);
        tag.put("money", (Tag)this.money.save());
        return tag;
    }

    public static ResultHolder load(CompoundTag tag, HolderLookup.Provider lookup) {
        SimpleContainer items = InventoryUtil.loadAllItems("items", tag, 4, lookup);
        MoneyStorage money = new MoneyStorage(() -> {}, Integer.MIN_VALUE);
        money.load(tag.getList("money", 10));
        return new ResultHolder((Container)items, money);
    }
}

