/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.menus;

import io.github.lightman314.lightmanscurrency.api.misc.menus.MoneySlot;
import io.github.lightman314.lightmanscurrency.api.network.LazyPacketData;
import io.github.lightman314.lightmanscurrency.api.traders.TradeContext;
import io.github.lightman314.lightmanscurrency.api.traders.TraderAPI;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.ITraderStorageMenu;
import io.github.lightman314.lightmanscurrency.api.traders.menu.storage.TraderStorageTab;
import io.github.lightman314.lightmanscurrency.common.core.ModMenus;
import io.github.lightman314.lightmanscurrency.common.menus.tabbed.EasyTabbedMenu;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.core.BasicTradeEditTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.core.MultiPriceTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.core.TaxInfoTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.core.TradeRulesTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.core.TraderLogTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.core.TraderMoneyStorageTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.core.TraderSettingsTab;
import io.github.lightman314.lightmanscurrency.common.menus.traderstorage.core.TraderStatsTab;
import io.github.lightman314.lightmanscurrency.common.menus.validation.IValidatedMenu;
import io.github.lightman314.lightmanscurrency.common.menus.validation.MenuValidator;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class TraderStorageMenu
extends EasyTabbedMenu<ITraderStorageMenu, TraderStorageTab>
implements IValidatedMenu,
ITraderStorageMenu {
    private final Supplier<TraderData> traderSource;
    public static final int SLOT_OFFSET = 15;
    private final List<Consumer<LazyPacketData>> listeners = new ArrayList<Consumer<LazyPacketData>>();
    private TradeContext context = null;
    private final MenuValidator validator;

    @Override
    @Nonnull
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public final TraderData getTrader() {
        TraderData trader = this.traderSource.get();
        return trader != null && trader.allowAccess() ? trader : null;
    }

    @Deprecated(since="2.2.4.4")
    public List<MoneySlot> getCoinSlots() {
        return new ArrayList<MoneySlot>();
    }

    @Override
    @Nonnull
    public TradeContext getContext() {
        TraderData trader = this.traderSource.get();
        if (this.context == null || this.context.getTrader() != trader) {
            this.context = TradeContext.createStorageMode(trader);
        }
        return this.context;
    }

    @Override
    @Nonnull
    public ItemStack getHeldItem() {
        return this.getCarried();
    }

    @Override
    public void setHeldItem(@Nonnull ItemStack stack) {
        this.setCarried(stack);
    }

    @Override
    @Nonnull
    public MenuValidator getValidator() {
        return this.validator;
    }

    public TraderStorageMenu(int windowID, Inventory inventory, long traderID, @Nonnull MenuValidator validator) {
        this(ModMenus.TRADER_STORAGE.get(), windowID, inventory, () -> TraderAPI.API.GetTrader(inventory.player.level().isClientSide, traderID), validator);
    }

    protected TraderStorageMenu(MenuType<?> type, int windowID, Inventory inventory, Supplier<TraderData> traderSource, @Nonnull MenuValidator validator) {
        super(type, windowID, inventory);
        this.validator = validator;
        this.traderSource = traderSource;
        this.addValidator(() -> this.hasPermission("openStorage"));
        this.addValidator(this.validator);
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.addSlot(new Slot((Container)inventory, x + y * 9 + 9, 23 + x * 18, 154 + y * 18));
            }
        }
        for (int x = 0; x < 9; ++x) {
            this.addSlot(new Slot((Container)inventory, x, 23 + x * 18, 212));
        }
        this.initializeTabs();
        this.getTrader().userOpen(this.player);
    }

    @Override
    protected void registerTabs() {
        TraderData trader = this.traderSource.get();
        this.setTab(0, new BasicTradeEditTab(this));
        this.setTab(4, new TraderMoneyStorageTab(this));
        this.setTab(9, new MultiPriceTab(this));
        this.setTab(10, new TraderLogTab(this));
        this.setTab(11, new TraderSettingsTab(this));
        this.setTab(12, new TraderStatsTab(this));
        this.setTab(100, new TradeRulesTab.Trader(this));
        this.setTab(101, new TradeRulesTab.Trade(this));
        this.setTab(50, new TaxInfoTab(this));
        if (trader != null) {
            trader.initStorageTabs(this);
        }
    }

    @Override
    public void removed(@Nonnull Player player) {
        super.removed(player);
        TraderData trader = this.getTrader();
        if (trader != null) {
            trader.userClose(player);
        }
    }

    @Override
    public void clearContainer(@Nonnull Container container) {
        this.clearContainer(this.player, container);
    }

    @Nonnull
    public ItemStack quickMoveStack(@Nonnull Player playerEntity, int index) {
        ItemStack clickedStack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack slotStack = slot.getItem();
            clickedStack = slotStack.copy();
            if (index < 36 ? !((TraderStorageTab)this.currentTab()).quickMoveStack(slotStack) && !this.moveItemStackTo(slotStack, 36, this.slots.size(), false) : index < this.slots.size() && !this.moveItemStackTo(slotStack, 0, 36, false)) {
                return ItemStack.EMPTY;
            }
            if (slotStack.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
        }
        return clickedStack;
    }

    @Override
    public int getPermissionLevel(@Nonnull String permission) {
        TraderData trader = this.getTrader();
        if (trader != null) {
            return trader.getPermissionLevel(this.player, permission);
        }
        return 0;
    }

    @Override
    @Deprecated(since="2.2.4.4")
    public void SetCoinSlotsActive(boolean nowActive) {
    }
}

