/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.loot.modifier;

import io.github.lightman314.lightmanscurrency.common.loot.modifier.ILootModifier;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public abstract class SimpleLootModifier
implements ILootModifier {
    @Override
    public final boolean tryModifyLoot(@Nonnull RandomSource random, @Nonnull List<ItemStack> loot) {
        if (this.isEnabled()) {
            this.replaceLoot(random, loot);
        }
        return false;
    }

    protected void replaceRandomItems(@Nonnull RandomSource random, @Nonnull List<ItemStack> loot, @Nonnull Item toReplace, @Nonnull ItemLike replacement) {
        SimpleLootModifier.replaceRandomItems(random, loot, this.getSuccessChance(), toReplace, replacement);
    }

    public static void replaceRandomItems(@Nonnull RandomSource random, @Nonnull List<ItemStack> loot, double chance, @Nonnull Item toReplace, @Nonnull ItemLike replacement) {
        ArrayList<ItemStack> toAdd = new ArrayList<ItemStack>();
        for (int i = 0; i < loot.size(); ++i) {
            int replaceCount;
            ItemStack stack = loot.get(i);
            if (stack.isEmpty() || stack.getItem() != toReplace || (replaceCount = SimpleLootModifier.randomCount(random, chance, stack.getCount())) <= 0) continue;
            if (replaceCount >= stack.getCount()) {
                loot.remove(i);
                --i;
                continue;
            }
            ItemStack split = stack.split(replaceCount);
            toAdd.add(ILootModifier.replaceItem(split, replacement));
        }
        loot.addAll(toAdd);
    }

    public static boolean randomCheck(@Nonnull RandomSource random, double chance) {
        return random.nextDouble() < chance;
    }

    public static int randomCount(@Nonnull RandomSource random, double chance, int attempts) {
        int result = 0;
        for (int i = 0; i < attempts; ++i) {
            if (!SimpleLootModifier.randomCheck(random, chance)) continue;
            ++result;
        }
        return result;
    }

    protected abstract void replaceLoot(@Nonnull RandomSource var1, @Nonnull List<ItemStack> var2);

    public abstract boolean isEnabled();

    protected abstract double getSuccessChance();
}

