/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.crafting;

import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.core.variants.Color;
import io.github.lightman314.lightmanscurrency.common.crafting.RecipeTypes;
import io.github.lightman314.lightmanscurrency.common.crafting.input.ListRecipeInput;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public interface TicketStationRecipe
extends Recipe<ListRecipeInput> {
    @Nonnull
    default public RecipeType<TicketStationRecipe> getType() {
        return RecipeTypes.TICKET.get();
    }

    @Nonnull
    default public ItemStack getToastSymbol() {
        return new ItemStack((ItemLike)ModBlocks.TICKET_STATION.get());
    }

    @Nonnull
    public static List<ItemStack> exampleModifierList(@Nonnull TagKey<Item> tag, Item ... extra) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (Item extraItem : extra) {
            result.add(new ItemStack((ItemLike)extraItem));
        }
        for (HolderSet set : BuiltInRegistries.ITEM.getTag(tag).stream().toList()) {
            for (Holder item : set.stream().toList()) {
                result.add(new ItemStack((ItemLike)item.value()));
            }
        }
        return result;
    }

    @Nonnull
    public static List<ItemStack> exampleTicketList(@Nonnull Supplier<? extends ItemLike> item) {
        return TicketStationRecipe.exampleTicketList(item.get().asItem());
    }

    @Nonnull
    public static List<ItemStack> exampleTicketList(@Nonnull Ingredient ingredient) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemStack item : ingredient.getItems()) {
            result.addAll(TicketStationRecipe.exampleTicketList(item.getItem()));
        }
        return result;
    }

    public static List<ItemStack> exampleTicketList(@Nonnull Item item) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (Color color : Color.values()) {
            result.add(TicketItem.CreateExampleTicket(item, color));
        }
        return result;
    }

    public boolean consumeModifier();

    public boolean validModifier(@Nonnull ItemStack var1);

    @Nonnull
    public List<ItemStack> jeiModifierList();

    public boolean validIngredient(@Nonnull ItemStack var1);

    @Nonnull
    public Ingredient getIngredient();

    @Nonnull
    public ItemStack peekAtResult(@Nonnull Container var1);

    @Nonnull
    public ItemStack exampleResult();

    default public boolean matches(@Nonnull ListRecipeInput container, @Nonnull Level level) {
        return this.validModifier(container.getItem(0)) && this.validIngredient(container.getItem(1));
    }
}

