/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.models;

import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.resources.ResourceLocation;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class VariantModelLocation {
    public final ResourceLocation variant;
    public final ResourceLocation target;
    public final int index;
    public final int yRot;

    private VariantModelLocation(ResourceLocation variant, ResourceLocation target, int index, int yRot) {
        this.variant = Objects.requireNonNull(variant);
        this.target = Objects.requireNonNull(target);
        this.index = index;
        this.yRot = yRot;
    }

    public static VariantModelLocation item(ResourceLocation variant, ResourceLocation target) {
        return new VariantModelLocation(variant, target, -1, 0);
    }

    public static VariantModelLocation basic(ResourceLocation variant, ResourceLocation target, int index) {
        return new VariantModelLocation(variant, target, index, 0);
    }

    public static VariantModelLocation rotatable(ResourceLocation variant, ResourceLocation target, int index, int yRotation) {
        return new VariantModelLocation(variant, target, index, yRotation);
    }

    public int hashCode() {
        return Objects.hash(this.variant, this.target, this.index, this.yRot);
    }

    public boolean equals(Object obj) {
        if (obj instanceof VariantModelLocation) {
            VariantModelLocation other = (VariantModelLocation)obj;
            return this.variant.equals((Object)other.variant) && this.target.equals((Object)other.target) && this.index == other.index && this.yRot == other.yRot;
        }
        return false;
    }

    public String toString() {
        return "VariantModelLocation[Variant:" + String.valueOf(this.variant) + ",Target:" + String.valueOf(this.target) + ",Index:" + this.index + ",yRotation:" + this.yRot + "]";
    }
}

