/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.api.misc.blocks.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.client.renderer.blockentity.ItemTraderBlockEntityRenderer;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.ModelVariantDataManager;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.data.ModelVariant;
import io.github.lightman314.lightmanscurrency.client.resourcepacks.data.model_variants.models.VariantModelLocation;
import io.github.lightman314.lightmanscurrency.common.blockentity.trader.FreezerTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.common.blocks.traderblocks.FreezerBlock;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class FreezerTraderBlockEntityRenderer
implements BlockEntityRenderer<FreezerTraderBlockEntity> {
    private FreezerTraderBlockEntityRenderer() {
    }

    public static FreezerTraderBlockEntityRenderer create(BlockEntityRendererProvider.Context ignored) {
        return new FreezerTraderBlockEntityRenderer();
    }

    public void render(@Nonnull FreezerTraderBlockEntity blockEntity, float partialTicks, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource bufferSource, int lightLevel, int id) {
        ItemTraderBlockEntityRenderer.renderItems(blockEntity, partialTicks, poseStack, bufferSource, lightLevel, id);
        Block block = blockEntity.getBlockState().getBlock();
        if (block instanceof FreezerBlock) {
            FreezerBlock freezerBlock = (FreezerBlock)block;
            poseStack.pushPose();
            Direction facing = freezerBlock.getFacing(blockEntity.getBlockState());
            Vector3f corner = IRotatableBlock.getOffsetVect(facing);
            Vector3f right = IRotatableBlock.getRightVect(facing);
            Vector3f forward = IRotatableBlock.getForwardVect(facing);
            Vector3f hinge = MathUtil.VectorAdd(corner, MathUtil.VectorMult(right, 0.96875f), MathUtil.VectorMult(forward, 0.21875f));
            Quaternionf rotation = MathUtil.fromAxisAngleDegree(MathUtil.getYP(), (float)facing.get2DDataValue() * -90.0f + 90.0f * blockEntity.getDoorAngle(partialTicks));
            poseStack.translate(hinge.x(), hinge.y(), hinge.z());
            poseStack.mulPose(rotation);
            Minecraft mc = Minecraft.getInstance();
            ModelResourceLocation doorModel = ModelResourceLocation.standalone((ResourceLocation)freezerBlock.getDoorModel());
            BakedModel model = mc.getModelManager().getModel(doorModel);
            ModelVariant variant = ModelVariantDataManager.getVariant(blockEntity.getCurrentVariant());
            if (variant != null && variant.getTargets().contains(freezerBlock.getBlockID()) && variant.getModels().size() == freezerBlock.requiredModels()) {
                VariantModelLocation newModel = VariantModelLocation.basic(blockEntity.getCurrentVariant(), freezerBlock.getBlockID(), freezerBlock.requiredModels() - 1);
                model = ModelVariantDataManager.getModel(newModel);
            }
            ItemRenderer itemRenderer = mc.getItemRenderer();
            itemRenderer.render(new ItemStack((ItemLike)freezerBlock), ItemDisplayContext.FIXED, false, poseStack, bufferSource, lightLevel, OverlayTexture.NO_OVERLAY, model);
            poseStack.popPose();
        }
    }
}

