/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.team;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.teams.ITeam;
import io.github.lightman314.lightmanscurrency.client.gui.widget.player.PlayerAction;
import io.github.lightman314.lightmanscurrency.client.gui.widget.player.PlayerEntry;
import io.github.lightman314.lightmanscurrency.client.gui.widget.player.PlayerListWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.menus.TeamManagementMenu;
import io.github.lightman314.lightmanscurrency.common.menus.teams.TeamManagementClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.teams.tabs.TeamMemberEditTab;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import io.github.lightman314.lightmanscurrency.common.util.IconUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;

public class TeamMemberEditClientTab
extends TeamManagementClientTab<TeamMemberEditTab> {
    public TeamMemberEditClientTab(@Nonnull Object screen, @Nonnull TeamMemberEditTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconUtil.ICON_ALEX_HEAD;
    }

    public MutableComponent getTooltip() {
        return LCText.TOOLTIP_TEAM_MEMBERS.get(new Object[0]);
    }

    @Override
    public boolean blockInventoryClosing() {
        return true;
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.addChild(((PlayerListWidget.Builder)PlayerListWidget.builder().position(screenArea.pos.offset(20, 9))).width(screenArea.width - 40).rows(7).addPlayer(((TeamMemberEditTab)this.commonTab)::PromotePlayer).canAddPlayer(this::CanAdd).action(PlayerAction.builder().action(((TeamMemberEditTab)this.commonTab)::DemotePlayer).tooltip(this::getDemoteText).permission(this::CanDemote).icon(this::getDemoteIcon).build()).action(PlayerAction.builder().tooltip(LCText.BUTTON_TEAM_MEMBER_PROMOTE).permission(this::CanPromote).icon(IconUtil.ICON_PLUS).action(((TeamMemberEditTab)this.commonTab)::PromotePlayer).build()).entryList(this::getMemberList).build());
    }

    private List<PlayerEntry> getMemberList() {
        ArrayList<PlayerEntry> list = new ArrayList<PlayerEntry>();
        ITeam team = ((TeamManagementMenu)this.menu).selectedTeam();
        if (team != null) {
            list.add(PlayerEntry.of(team.getOwner(), ChatFormatting.GREEN.getColor()));
            for (PlayerReference admin : team.getAdmins()) {
                list.add(PlayerEntry.of(admin, ChatFormatting.DARK_GREEN.getColor()));
            }
            for (PlayerReference member : team.getMembers()) {
                list.add(PlayerEntry.of(member));
            }
        }
        return list;
    }

    private boolean CanAdd(PlayerReference player) {
        ITeam team = ((TeamManagementMenu)this.menu).selectedTeam();
        if (team == null) {
            return false;
        }
        return !team.isMember(player) && team.isAdmin(((TeamManagementMenu)this.menu).player);
    }

    private boolean CanPromote(PlayerReference player) {
        ITeam team = ((TeamManagementMenu)this.menu).selectedTeam();
        if (team == null) {
            return false;
        }
        if (team.isAdmin(player)) {
            return false;
        }
        if (!team.isMember(player) && team.isAdmin(((TeamManagementMenu)this.menu).player)) {
            return true;
        }
        return team.isMember(player) && team.isOwner(((TeamManagementMenu)this.menu).player);
    }

    private boolean CanDemote(PlayerReference player) {
        ITeam team = ((TeamManagementMenu)this.menu).selectedTeam();
        if (team == null) {
            return false;
        }
        if (team.isOwner(player)) {
            return false;
        }
        if (player.is((Entity)((TeamManagementMenu)this.menu).player)) {
            return true;
        }
        if (team.isMember(player) && !team.isAdmin(player) && team.isAdmin(((TeamManagementMenu)this.menu).player)) {
            return true;
        }
        return team.isAdmin(player) && team.isOwner(((TeamManagementMenu)this.menu).player);
    }

    private Component getDemoteText(PlayerReference player) {
        ITeam team = ((TeamManagementMenu)this.menu).selectedTeam();
        return team == null || !team.isAdmin(player) ? LCText.BUTTON_REMOVE.get(new Object[0]) : LCText.BUTTON_TEAM_MEMBER_DEMOTE.get(new Object[0]);
    }

    private IconData getDemoteIcon(PlayerReference player) {
        ITeam team = ((TeamManagementMenu)this.menu).selectedTeam();
        return team == null || !team.isAdmin(player) ? IconUtil.ICON_X : IconUtil.ICON_MINUS;
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
    }
}

