/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.team;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.money.bank.IBankAccount;
import io.github.lightman314.lightmanscurrency.api.ownership.Owner;
import io.github.lightman314.lightmanscurrency.api.teams.ITeam;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyTextButton;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.common.menus.TeamManagementMenu;
import io.github.lightman314.lightmanscurrency.common.menus.teams.TeamManagementClientTab;
import io.github.lightman314.lightmanscurrency.common.menus.teams.tabs.TeamBankAccountTab;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.util.IconData;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class TeamBankAccountClientTab
extends TeamManagementClientTab<TeamBankAccountTab> {
    EasyButton buttonCreateBankAccount;
    EasyButton buttonToggleAccountLimit;

    public TeamBankAccountClientTab(@Nonnull Object screen, @Nonnull TeamBankAccountTab commonTab) {
        super(screen, commonTab);
    }

    @Override
    @Nonnull
    public IconData getIcon() {
        return IconData.of(ModBlocks.COINPILE_GOLD);
    }

    public MutableComponent getTooltip() {
        return LCText.TOOLTIP_TEAM_BANK.get(new Object[0]);
    }

    @Override
    public void initialize(ScreenArea screenArea, boolean firstOpen) {
        this.buttonCreateBankAccount = this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(20, 20))).width(160)).text(LCText.BUTTON_TEAM_BANK_CREATE).pressAction(this::createBankAccount)).build());
        this.buttonToggleAccountLimit = this.addChild(((EasyTextButton.Builder)((EasyTextButton.Builder)((EasyTextButton.Builder)EasyTextButton.builder().position(screenArea.pos.offset(20, 60))).width(160)).text(this::getBankLimitText).pressAction(this::toggleBankLimit)).build());
    }

    @Override
    public void renderBG(@Nonnull EasyGuiGraphics gui) {
        IBankAccount account;
        ITeam team = ((TeamManagementMenu)this.menu).selectedTeam();
        if (team == null) {
            return;
        }
        if (team.hasBankAccount() && (account = team.getBankAccount()) != null) {
            gui.drawString((Component)account.getBalanceText(), 20, 46, 0x404040);
        }
    }

    @Override
    public void tick() {
        ITeam team = ((TeamManagementMenu)this.menu).selectedTeam();
        if (team == null) {
            return;
        }
        this.buttonCreateBankAccount.active = !team.hasBankAccount();
    }

    private void createBankAccount(EasyButton button) {
        ((TeamBankAccountTab)this.commonTab).CreateBankAccount();
    }

    private void toggleBankLimit(EasyButton button) {
        int newLimit = Team.NextBankLimit(this.getBankLimit());
        ((TeamBankAccountTab)this.commonTab).ChangeBankAccess(newLimit);
    }

    private int getBankLimit() {
        ITeam team = ((TeamManagementMenu)this.menu).selectedTeam();
        return team == null ? 2 : team.getBankLimit();
    }

    private Component getBankLimitText() {
        return LCText.BUTTON_TEAM_BANK_LIMIT.get(Owner.getOwnerLevelBlurb(this.getBankLimit()));
    }
}

