/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.paygate;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.SettingsSubTab;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderstorage.settings.core.addons.MiscTabAddon;
import io.github.lightman314.lightmanscurrency.client.gui.widget.dropdown.DropdownWidget;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.OutputConflictHandling;
import io.github.lightman314.lightmanscurrency.common.traders.paygate.PaygateTraderData;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class PaygateSettingAddon
extends MiscTabAddon {
    private int yPos = 0;
    public static PaygateSettingAddon INSTANCE = new PaygateSettingAddon();

    private PaygateSettingAddon() {
    }

    @Override
    public void onOpenBefore(SettingsSubTab tab, ScreenArea screenArea, boolean firstOpen, AtomicInteger nextYPosition) {
        this.yPos = nextYPosition.getAndAdd(25);
        ArrayList<Component> options = new ArrayList<Component>();
        for (OutputConflictHandling type : OutputConflictHandling.values()) {
            options.add((Component)LCText.GUI_TRADER_PAYGATE_CONFLICT_HANDLING.get(type).get(new Object[0]));
        }
        tab.addChild(((DropdownWidget.Builder)DropdownWidget.builder().position(screenArea.pos.offset(30, this.yPos + 10))).width(screenArea.width - 60).options(options).selected(this.getSelected()).selectAction(this::selectType).build());
    }

    @Override
    public void onOpenAfter(@Nonnull SettingsSubTab tab, @Nonnull ScreenArea screenArea, boolean firstOpen, @Nonnull AtomicInteger nextYPosition) {
    }

    private int getSelected() {
        TraderData traderData;
        if (this.getTab() != null && (traderData = this.getTab().menu.getTrader()) instanceof PaygateTraderData) {
            PaygateTraderData paygate = (PaygateTraderData)traderData;
            return ((OutputConflictHandling)((Object)paygate.conflictHandling.get())).ordinal();
        }
        return 0;
    }

    @Override
    public void renderBG(SettingsSubTab tab, EasyGuiGraphics gui) {
        gui.drawString((Component)LCText.GUI_TRADER_PAYGATE_CONFLICT_LABEL.get(new Object[0]), 30, this.yPos, 0x404040);
    }

    @Override
    public void renderAfterWidgets(SettingsSubTab tab, EasyGuiGraphics gui) {
    }

    @Override
    public void tick(SettingsSubTab tab) {
    }

    @Override
    public void onClose(SettingsSubTab tab) {
    }

    private void selectType(int selected) {
        if (this.getTab() == null) {
            return;
        }
        this.getTab().sendMessage(this.getTab().builder().setInt("ChangeConflictMode", selected));
    }
}

