/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.api.misc.EasyText;
import io.github.lightman314.lightmanscurrency.api.misc.client.rendering.EasyGuiGraphics;
import io.github.lightman314.lightmanscurrency.client.gui.easy.EasyMenuScreen;
import io.github.lightman314.lightmanscurrency.client.gui.easy.rendering.Sprite;
import io.github.lightman314.lightmanscurrency.client.gui.widget.ScrollListener;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.PlainButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyAddonHelper;
import io.github.lightman314.lightmanscurrency.client.gui.widget.easy.EasyButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.scroll.IScrollable;
import io.github.lightman314.lightmanscurrency.client.util.ScreenArea;
import io.github.lightman314.lightmanscurrency.common.crafting.TicketStationRecipe;
import io.github.lightman314.lightmanscurrency.common.crafting.input.ListRecipeInput;
import io.github.lightman314.lightmanscurrency.common.menus.TicketStationMenu;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.crafting.RecipeHolder;

public class TicketStationScreen
extends EasyMenuScreen<TicketStationMenu>
implements IScrollable {
    public static final ResourceLocation GUI_TEXTURE = VersionUtil.lcResource("textures/gui/container/ticket_machine.png");
    public static final Sprite SPRITE_ARROW = Sprite.SimpleSprite(GUI_TEXTURE, 176, 0, 24, 16);
    private static final ScreenArea SELECTION_AREA = ScreenArea.of(153, 7, 16, 16);
    private RecipeHolder<TicketStationRecipe> selectedRecipe = null;

    public List<RecipeHolder<TicketStationRecipe>> getMatchingRecipes() {
        ListRecipeInput input = ((TicketStationMenu)this.menu).blockEntity.getRecipeInput();
        return ((TicketStationMenu)this.menu).getAllRecipes().stream().filter(r -> ((TicketStationRecipe)r.value()).matches(input, ((TicketStationMenu)this.menu).blockEntity.getLevel())).toList();
    }

    public TicketStationScreen(TicketStationMenu container, Inventory inventory, Component title) {
        super(container, inventory, title);
        this.resize(176, 138);
    }

    @Override
    protected void renderBG(@Nonnull EasyGuiGraphics gui) {
        gui.renderNormalBackground(GUI_TEXTURE, this);
        gui.drawString(this.title, 8, 6, 0x404040);
        gui.drawString(this.playerInventoryTitle, 8, this.getYSize() - 94, 0x404040);
        if (this.selectedRecipe != null) {
            gui.renderItem(((TicketStationRecipe)this.selectedRecipe.value()).peekAtResult(((TicketStationMenu)this.menu).blockEntity.getStorage()), TicketStationScreen.SELECTION_AREA.pos);
        }
    }

    @Override
    protected void renderAfterWidgets(@Nonnull EasyGuiGraphics gui) {
        if (this.selectedRecipe != null && SELECTION_AREA.offsetPosition(this.getCorner()).isMouseInArea(gui.mousePos)) {
            ArrayList<Component> tooltip = new ArrayList<Component>();
            tooltip.add((Component)LCText.TOOLTIP_TICKET_STATION_RECIPE_INFO.get(((TicketStationRecipe)this.selectedRecipe.value()).peekAtResult(((TicketStationMenu)this.menu).blockEntity.getStorage()).getHoverName()));
            if (this.getMatchingRecipes().size() > 1) {
                tooltip.add((Component)LCText.TOOLTIP_TICKET_STATION_SELECT_RECIPE.get(new Object[0]));
            }
            gui.renderComponentTooltip(tooltip);
        }
    }

    @Override
    protected void initialize(ScreenArea screenArea) {
        this.addChild(((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)((PlainButton.Builder)PlainButton.builder().position(screenArea.pos.offset(79, 21))).pressAction(this::craftTicket)).sprite(SPRITE_ARROW).addon(EasyAddonHelper.visibleCheck(() -> ((TicketStationMenu)this.menu).validInputs() && this.selectedRecipe != null && ((TicketStationMenu)this.menu).roomForOutput((TicketStationRecipe)this.selectedRecipe.value())))).addon(EasyAddonHelper.tooltip(this::getArrowTooltip))).build());
        this.addChild(((ScrollListener.Builder)ScrollListener.builder().area(SELECTION_AREA.offsetPosition(screenArea.pos))).listener(this).build());
        this.validateSelectedRecipe();
    }

    @Override
    protected void screenTick() {
        this.validateSelectedRecipe();
    }

    private Component getArrowTooltip() {
        if (this.selectedRecipe != null) {
            return LCText.TOOLTIP_TICKET_STATION_CRAFT.get(((TicketStationRecipe)this.selectedRecipe.value()).peekAtResult(((TicketStationMenu)this.menu).blockEntity.getStorage()).getHoverName());
        }
        return EasyText.empty();
    }

    private void validateSelectedRecipe() {
        List<RecipeHolder<TicketStationRecipe>> matchingRecipes = this.getMatchingRecipes();
        if (this.selectedRecipe != null && !matchingRecipes.contains(this.selectedRecipe)) {
            this.selectedRecipe = !matchingRecipes.isEmpty() ? matchingRecipes.getFirst() : null;
            return;
        }
        if (this.selectedRecipe == null && !matchingRecipes.isEmpty()) {
            this.selectedRecipe = matchingRecipes.getFirst();
        }
    }

    private void craftTicket(EasyButton button) {
        this.validateSelectedRecipe();
        if (this.selectedRecipe == null) {
            return;
        }
        ((TicketStationMenu)this.menu).SendCraftTicketsMessage(Screen.hasShiftDown(), this.selectedRecipe.id());
    }

    @Override
    public int currentScroll() {
        this.validateSelectedRecipe();
        if (this.selectedRecipe == null) {
            return 0;
        }
        return this.getMatchingRecipes().indexOf(this.selectedRecipe);
    }

    @Override
    public void setScroll(int newScroll) {
        List<RecipeHolder<TicketStationRecipe>> matchingRecipes = this.getMatchingRecipes();
        if (matchingRecipes.isEmpty()) {
            this.selectedRecipe = null;
        } else if (newScroll < 0 || newScroll >= matchingRecipes.size()) {
            this.setScroll(0);
        } else {
            this.selectedRecipe = matchingRecipes.get(newScroll);
        }
    }

    @Override
    public int getMaxScroll() {
        return this.getMatchingRecipes().size() - 1;
    }
}

