/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.traders;

import io.github.lightman314.lightmanscurrency.LCText;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.capability.money.IMoneyHandler;
import io.github.lightman314.lightmanscurrency.api.misc.player.PlayerReference;
import io.github.lightman314.lightmanscurrency.api.money.MoneyAPI;
import io.github.lightman314.lightmanscurrency.api.money.bank.reference.BankReference;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyValue;
import io.github.lightman314.lightmanscurrency.api.money.value.MoneyView;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.IMoneyHolder;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.MoneyHolder;
import io.github.lightman314.lightmanscurrency.api.money.value.holder.MultiMoneyHolder;
import io.github.lightman314.lightmanscurrency.api.traders.TraderData;
import io.github.lightman314.lightmanscurrency.common.blockentity.handler.ICanCopy;
import io.github.lightman314.lightmanscurrency.common.items.TicketItem;
import io.github.lightman314.lightmanscurrency.common.menus.slots.InteractionSlot;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.ItemRequirement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import net.neoforged.neoforge.items.ItemStackHandler;

public class TradeContext {
    private static long nextID = 0L;
    public final long id = nextID++;
    public final boolean isStorageMode;
    private final TraderData trader;
    @Nullable
    private final Player player;
    private final PlayerReference playerReference;
    private final MultiMoneyHolder moneyHolders;
    private final InteractionSlot interactionSlot;
    private final IItemHandler itemHandler;
    private final IFluidHandler fluidTank;
    private final IEnergyStorage energyTank;

    public boolean hasTrader() {
        return this.trader != null;
    }

    public TraderData getTrader() {
        return this.trader;
    }

    public boolean hasPlayer() {
        return this.player != null;
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    public boolean hasPlayerReference() {
        return this.playerReference != null;
    }

    public final PlayerReference getPlayerReference() {
        return this.playerReference;
    }

    private boolean hasInteractionSlot(String type) {
        return this.getInteractionSlot(type) != null;
    }

    private InteractionSlot getInteractionSlot(String type) {
        if (this.interactionSlot == null) {
            return null;
        }
        if (this.interactionSlot.isType(type)) {
            return this.interactionSlot;
        }
        return null;
    }

    private boolean hasItemHandler() {
        return this.itemHandler != null;
    }

    private boolean hasFluidTank() {
        return this.fluidTank != null;
    }

    private boolean hasEnergyTank() {
        return this.energyTank != null;
    }

    private TradeContext(Builder builder) {
        this.isStorageMode = builder.storageMode;
        this.trader = builder.trader;
        this.player = builder.player;
        this.moneyHolders = new MultiMoneyHolder(builder.moneyHandlers);
        this.playerReference = builder.playerReference;
        this.interactionSlot = builder.interactionSlot;
        this.itemHandler = builder.itemHandler;
        this.fluidTank = builder.fluidHandler;
        this.energyTank = builder.energyHandler;
    }

    public boolean hasPaymentMethod() {
        return this.hasPlayer();
    }

    public boolean hasFunds(MoneyValue price) {
        if (price.isFree() || price.isEmpty()) {
            return true;
        }
        return this.getAvailableFunds().containsValue(price);
    }

    @Nonnull
    public MoneyView getAvailableFunds() {
        return this.moneyHolders.getStoredMoney();
    }

    @Nonnull
    public List<Component> getAvailableFundsDescription() {
        ArrayList<Component> text = new ArrayList<Component>();
        this.moneyHolders.formatTooltip(text);
        return text;
    }

    public boolean getPayment(MoneyValue price) {
        if (price == null) {
            return false;
        }
        if (price.isFree() || price.isEmpty()) {
            return true;
        }
        if (this.moneyHolders.extractMoney(price, true).isEmpty()) {
            this.moneyHolders.extractMoney(price, false);
            return true;
        }
        return false;
    }

    public boolean givePayment(MoneyValue price) {
        if (price == null) {
            return false;
        }
        if (price.isFree()) {
            return true;
        }
        if (this.moneyHolders.insertMoney(price, true).isEmpty()) {
            this.moneyHolders.insertMoney(price, false);
            return true;
        }
        return false;
    }

    public boolean hasItem(ItemStack item) {
        if (this.hasItemHandler()) {
            return InventoryUtil.CanExtractItem(this.itemHandler, item);
        }
        if (this.hasPlayer()) {
            return InventoryUtil.GetItemCount((Container)this.player.getInventory(), item) >= item.getCount();
        }
        return false;
    }

    public boolean hasItems(ItemStack ... items) {
        for (ItemStack item : InventoryUtil.combineQueryItems(items)) {
            if (this.hasItem(item)) continue;
            return false;
        }
        return true;
    }

    public boolean hasItems(List<ItemStack> items) {
        if (items == null) {
            return false;
        }
        for (ItemStack item : InventoryUtil.combineQueryItems(items)) {
            if (this.hasItem(item)) continue;
            return false;
        }
        return true;
    }

    public boolean hasItems(ItemRequirement ... requirements) {
        if (this.hasItemHandler()) {
            return ItemRequirement.getFirstItemsMatchingRequirements(this.itemHandler, requirements) != null;
        }
        if (this.hasPlayer()) {
            return ItemRequirement.getFirstItemsMatchingRequirements((Container)this.player.getInventory(), requirements) != null;
        }
        return false;
    }

    public boolean hasTicket(long ticketID) {
        block3: {
            block2: {
                if (!this.hasItemHandler()) break block2;
                for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                    long id;
                    ItemStack stack = this.itemHandler.getStackInSlot(i);
                    if (!TicketItem.isTicket(stack) || (id = TicketItem.GetTicketID(stack)) != ticketID) continue;
                    ItemStack copyStack = stack.copy();
                    copyStack.setCount(1);
                    if (!InventoryUtil.CanExtractItem(this.itemHandler, copyStack)) continue;
                    return true;
                }
                break block3;
            }
            if (!this.hasPlayer()) break block3;
            Inventory inventory = this.player.getInventory();
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                long id;
                ItemStack stack = inventory.getItem(i);
                if (!TicketItem.isTicket(stack) || (id = TicketItem.GetTicketID(stack)) != ticketID) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasPass(long ticketID) {
        block3: {
            block2: {
                if (!this.hasItemHandler()) break block2;
                for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                    long id;
                    ItemStack stack = this.itemHandler.getStackInSlot(i);
                    if (!TicketItem.isPass(stack) || (id = TicketItem.GetTicketID(stack)) != ticketID) continue;
                    return true;
                }
                break block3;
            }
            if (!this.hasPlayer()) break block3;
            Inventory inventory = this.player.getInventory();
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                long id;
                ItemStack stack = inventory.getItem(i);
                if (!TicketItem.isPass(stack) || (id = TicketItem.GetTicketID(stack)) != ticketID) continue;
                return true;
            }
        }
        return false;
    }

    public boolean collectItem(ItemStack item) {
        if (this.hasItem(item)) {
            if (this.hasItemHandler()) {
                InventoryUtil.RemoveItemCount(this.itemHandler, item);
                return true;
            }
            if (this.hasPlayer()) {
                InventoryUtil.RemoveItemCount((Container)this.player.getInventory(), item);
                return true;
            }
        }
        return false;
    }

    public boolean collectItems(List<ItemStack> items) {
        items = InventoryUtil.combineQueryItems(items);
        for (ItemStack item : items) {
            if (this.hasItem(item)) continue;
            return false;
        }
        for (ItemStack item : items) {
            this.collectItem(item);
        }
        return true;
    }

    public List<ItemStack> getCollectableItems(ItemRequirement ... requirements) {
        if (this.hasItemHandler()) {
            return ItemRequirement.getFirstItemsMatchingRequirements(this.itemHandler, requirements);
        }
        if (this.hasPlayer()) {
            return ItemRequirement.getFirstItemsMatchingRequirements((Container)this.player.getInventory(), requirements);
        }
        return null;
    }

    public void hightlightItems(List<ItemRequirement> requirements, List<Slot> slots, List<Integer> results) {
        if (this.hasPlayer()) {
            HashMap<Integer, Integer> inventoryConsumedCounts = new HashMap<Integer, Integer>();
            Inventory inventory = this.player.getInventory();
            for (ItemRequirement requirement : requirements) {
                int amountToConsume = requirement.getCount();
                for (int i = 0; i < inventory.getContainerSize() && amountToConsume > 0; ++i) {
                    ItemStack stack = inventory.getItem(i);
                    if (!requirement.test(stack) || stack.isEmpty()) continue;
                    int alreadyConsumed = inventoryConsumedCounts.getOrDefault(i, 0);
                    int consumeCount = Math.min(amountToConsume, stack.getCount() - alreadyConsumed);
                    amountToConsume -= consumeCount;
                    if ((alreadyConsumed += consumeCount) <= 0) continue;
                    inventoryConsumedCounts.put(i, alreadyConsumed);
                }
            }
            Iterator<ItemRequirement> iterator = inventoryConsumedCounts.keySet().iterator();
            while (iterator.hasNext()) {
                int relevantSlot = (Integer)((Object)iterator.next());
                for (int i = 0; i < slots.size(); ++i) {
                    Slot slot = slots.get(i);
                    if (slot.container != inventory || slot.getContainerSlot() != relevantSlot) continue;
                    results.add(i);
                }
            }
        }
    }

    public boolean collectTicket(long ticketID) {
        block2: {
            block3: {
                if (!this.hasTicket(ticketID)) break block2;
                if (!this.hasItemHandler()) break block3;
                for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
                    long id;
                    ItemStack stack = this.itemHandler.getStackInSlot(i);
                    if (!TicketItem.isTicket(stack) || (id = TicketItem.GetTicketID(stack)) != ticketID) continue;
                    ItemStack extractStack = stack.copy();
                    extractStack.setCount(1);
                    if (!InventoryUtil.RemoveItemCount(this.itemHandler, extractStack)) continue;
                    return true;
                }
                break block2;
            }
            if (!this.hasPlayer()) break block2;
            Inventory inventory = this.player.getInventory();
            for (int i = 0; i < inventory.getContainerSize(); ++i) {
                long id;
                ItemStack stack = inventory.getItem(i);
                if (!TicketItem.isTicket(stack) || (id = TicketItem.GetTicketID(stack)) != ticketID) continue;
                inventory.removeItem(i, 1);
                inventory.setChanged();
                return true;
            }
        }
        return false;
    }

    public boolean canFitItem(ItemStack item) {
        if (item.isEmpty()) {
            return true;
        }
        if (this.hasItemHandler()) {
            return ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)item, (boolean)true).isEmpty();
        }
        return this.hasPlayer();
    }

    public boolean canFitItems(ItemStack ... items) {
        if (this.hasItemHandler()) {
            IItemHandler copy;
            IItemHandler original = this.itemHandler;
            if (original instanceof ICanCopy) {
                copy = (IItemHandler)((ICanCopy)original).copy();
            } else {
                NonNullList inventory = NonNullList.withSize((int)original.getSlots(), (Object)ItemStack.EMPTY);
                for (int i = 0; i < original.getSlots(); ++i) {
                    inventory.set(i, (Object)original.getStackInSlot(i));
                }
                copy = new ItemStackHandler(inventory);
            }
            for (ItemStack item : items) {
                if (ItemHandlerHelper.insertItemStacked((IItemHandler)copy, (ItemStack)item, (boolean)false).isEmpty()) continue;
                return false;
            }
            return true;
        }
        return this.hasPlayer();
    }

    public boolean canFitItems(List<ItemStack> items) {
        if (this.hasItemHandler()) {
            IItemHandler original = this.itemHandler;
            IItemHandler copy = null;
            if (original instanceof ICanCopy) {
                try {
                    copy = (IItemHandler)((ICanCopy)original).copy();
                }
                catch (Throwable t) {
                    LightmansCurrency.LogDebug("Error copying item handler.", t);
                }
            }
            if (copy == null) {
                NonNullList inventory = NonNullList.withSize((int)original.getSlots(), (Object)ItemStack.EMPTY);
                for (int i = 0; i < original.getSlots(); ++i) {
                    inventory.set(i, (Object)original.getStackInSlot(i).copy());
                }
                copy = new ItemStackHandler(inventory);
            }
            for (ItemStack item : InventoryUtil.combineQueryItems(items)) {
                if (ItemHandlerHelper.insertItemStacked((IItemHandler)copy, (ItemStack)item, (boolean)false).isEmpty()) continue;
                return false;
            }
            return true;
        }
        return this.hasPlayer();
    }

    public boolean putItem(ItemStack item) {
        if (this.canFitItem(item)) {
            if (this.hasItemHandler()) {
                ItemStack leftovers = ItemHandlerHelper.insertItemStacked((IItemHandler)this.itemHandler, (ItemStack)item, (boolean)false);
                if (leftovers.isEmpty()) {
                    return true;
                }
                ItemStack placedStack = item.copy();
                placedStack.setCount(item.getCount() - leftovers.getCount());
                if (!item.isEmpty()) {
                    this.collectItem(placedStack);
                }
                return false;
            }
            if (this.hasPlayer()) {
                ItemHandlerHelper.giveItemToPlayer((Player)this.player, (ItemStack)item);
                return true;
            }
        }
        return false;
    }

    public boolean hasFluid(FluidStack fluid) {
        if (this.hasFluidTank()) {
            FluidStack result = this.fluidTank.drain(fluid, IFluidHandler.FluidAction.SIMULATE);
            return !result.isEmpty() && result.getAmount() >= fluid.getAmount();
        }
        if (this.hasInteractionSlot("BUCKET_SLOT")) {
            ItemStack bucketStack = this.getInteractionSlot("BUCKET_SLOT").getItem();
            AtomicBoolean hasFluid = new AtomicBoolean(false);
            FluidUtil.getFluidHandler((ItemStack)bucketStack).ifPresent(fluidHandler -> {
                FluidStack result = fluidHandler.drain(fluid, IFluidHandler.FluidAction.SIMULATE);
                hasFluid.set(!result.isEmpty() && result.getAmount() == fluid.getAmount());
            });
            return hasFluid.get();
        }
        return false;
    }

    public boolean drainFluid(FluidStack fluid) {
        if (this.hasFluid(fluid)) {
            if (this.hasFluidTank()) {
                this.fluidTank.drain(fluid, IFluidHandler.FluidAction.EXECUTE);
                return true;
            }
            if (this.hasInteractionSlot("BUCKET_SLOT")) {
                InteractionSlot slot = this.getInteractionSlot("BUCKET_SLOT");
                ItemStack bucketStack = slot.getItem();
                FluidUtil.getFluidHandler((ItemStack)bucketStack).ifPresent(fluidHandler -> {
                    fluidHandler.drain(fluid, IFluidHandler.FluidAction.EXECUTE);
                    slot.set(fluidHandler.getContainer());
                });
                return true;
            }
        }
        return false;
    }

    public boolean canFitFluid(FluidStack fluid) {
        if (this.hasFluidTank()) {
            return this.fluidTank.fill(fluid, IFluidHandler.FluidAction.SIMULATE) == fluid.getAmount();
        }
        if (this.hasInteractionSlot("BUCKET_SLOT")) {
            ItemStack bucketStack = this.getInteractionSlot("BUCKET_SLOT").getItem();
            AtomicBoolean fitFluid = new AtomicBoolean(false);
            FluidUtil.getFluidHandler((ItemStack)bucketStack).ifPresent(fluidHandler -> fitFluid.set(fluidHandler.fill(fluid, IFluidHandler.FluidAction.SIMULATE) == fluid.getAmount()));
            return fitFluid.get();
        }
        return false;
    }

    public boolean fillFluid(FluidStack fluid) {
        if (this.canFitFluid(fluid)) {
            if (this.hasFluidTank()) {
                this.fluidTank.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                return true;
            }
            if (this.hasInteractionSlot("BUCKET_SLOT")) {
                InteractionSlot slot = this.getInteractionSlot("BUCKET_SLOT");
                ItemStack bucketStack = slot.getItem();
                FluidUtil.getFluidHandler((ItemStack)bucketStack).ifPresent(fluidHandler -> {
                    fluidHandler.fill(fluid, IFluidHandler.FluidAction.EXECUTE);
                    slot.set(fluidHandler.getContainer());
                });
            }
        }
        return false;
    }

    public boolean hasEnergy(int amount) {
        if (this.hasEnergyTank()) {
            return this.energyTank.extractEnergy(amount, true) == amount;
        }
        if (this.hasInteractionSlot("ENERGY_SLOT")) {
            ItemStack batteryStack = this.getInteractionSlot("ENERGY_SLOT").getItem();
            boolean hasEnergy = false;
            IEnergyStorage energyHandler = (IEnergyStorage)batteryStack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (energyHandler != null) {
                return energyHandler.extractEnergy(amount, true) == amount;
            }
            return false;
        }
        return false;
    }

    public boolean drainEnergy(int amount) {
        if (this.hasEnergy(amount)) {
            if (this.hasEnergyTank()) {
                this.energyTank.extractEnergy(amount, false);
                return true;
            }
            if (this.hasInteractionSlot("ENERGY_SLOT")) {
                ItemStack batteryStack = this.getInteractionSlot("ENERGY_SLOT").getItem();
                IEnergyStorage energyHandler = (IEnergyStorage)batteryStack.getCapability(Capabilities.EnergyStorage.ITEM);
                if (energyHandler != null) {
                    energyHandler.extractEnergy(amount, false);
                }
                return true;
            }
        }
        return false;
    }

    public boolean canFitEnergy(int amount) {
        if (this.hasEnergyTank()) {
            return this.energyTank.receiveEnergy(amount, true) == amount;
        }
        if (this.hasInteractionSlot("ENERGY_SLOT")) {
            ItemStack batteryStack = this.getInteractionSlot("ENERGY_SLOT").getItem();
            IEnergyStorage energyHandler = (IEnergyStorage)batteryStack.getCapability(Capabilities.EnergyStorage.ITEM);
            if (energyHandler != null) {
                return energyHandler.receiveEnergy(amount, true) == amount;
            }
            return false;
        }
        return false;
    }

    public boolean fillEnergy(int amount) {
        if (this.canFitEnergy(amount)) {
            if (this.hasEnergyTank()) {
                this.energyTank.receiveEnergy(amount, false);
                return true;
            }
            if (this.hasInteractionSlot("ENERGY_SLOT")) {
                ItemStack batteryStack = this.getInteractionSlot("ENERGY_SLOT").getItem();
                IEnergyStorage energyHandler = (IEnergyStorage)batteryStack.getCapability(Capabilities.EnergyStorage.ITEM);
                if (energyHandler != null) {
                    energyHandler.receiveEnergy(amount, false);
                }
                return true;
            }
        }
        return false;
    }

    public static TradeContext createStorageMode(@Nonnull TraderData trader) {
        return new Builder(trader).build();
    }

    public static Builder create(@Nonnull TraderData trader, @Nonnull Player player) {
        return new Builder(trader, player, true);
    }

    public static Builder create(@Nonnull TraderData trader, @Nonnull PlayerReference player) {
        return new Builder(trader, player);
    }

    @MethodsReturnNonnullByDefault
    @FieldsAreNonnullByDefault
    public static class Builder {
        private final boolean storageMode;
        private final TraderData trader;
        @Nullable
        private final Player player;
        @Nullable
        private final PlayerReference playerReference;
        private final List<IMoneyHolder> moneyHandlers = new ArrayList<IMoneyHolder>();
        @Nullable
        private InteractionSlot interactionSlot;
        @Nullable
        private IItemHandler itemHandler;
        @Nullable
        private IFluidHandler fluidHandler;
        @Nullable
        private IEnergyStorage energyHandler;

        private Builder(TraderData trader) {
            this.storageMode = true;
            this.trader = trader;
            this.player = null;
            this.playerReference = null;
        }

        private Builder(TraderData trader, @Nullable Player player, boolean playerInteractable) {
            this.trader = trader;
            this.player = player;
            this.playerReference = PlayerReference.of(player);
            this.storageMode = false;
            if (playerInteractable) {
                this.withMoneyHolder(MoneyAPI.API.GetPlayersMoneyHandler(player));
            }
        }

        private Builder(TraderData trader, @Nullable PlayerReference player) {
            this.trader = trader;
            this.playerReference = player;
            this.player = null;
            this.storageMode = false;
        }

        public Builder withBankAccount(@Nullable BankReference bankAccount) {
            if (bankAccount == null) {
                return this;
            }
            return this.withMoneyHolder(bankAccount);
        }

        public Builder withCoinSlots(Container coinSlots) {
            if (this.player == null) {
                return this;
            }
            return this.withMoneyHandler(MoneyAPI.API.GetContainersMoneyHandler(coinSlots, this.player), (Component)LCText.TOOLTIP_MONEY_SOURCE_SLOTS.get(new Object[0]), 100);
        }

        public Builder withMoneyHandler(IMoneyHandler moneyHandler, Component title, int priority) {
            return this.withMoneyHolder(MoneyHolder.createFromHandler(moneyHandler, title, priority));
        }

        public Builder withMoneyHolder(IMoneyHolder moneyHandler) {
            if (!this.moneyHandlers.contains(moneyHandler)) {
                this.moneyHandlers.add(moneyHandler);
            }
            return this;
        }

        public Builder withInteractionSlot(InteractionSlot interactionSlot) {
            this.interactionSlot = interactionSlot;
            return this;
        }

        public Builder withItemHandler(IItemHandler itemHandler) {
            this.itemHandler = itemHandler;
            return this;
        }

        public Builder withFluidHandler(IFluidHandler fluidHandler) {
            this.fluidHandler = fluidHandler;
            return this;
        }

        public Builder withEnergyHandler(IEnergyStorage energyHandler) {
            this.energyHandler = energyHandler;
            return this;
        }

        public TradeContext build() {
            return new TradeContext(this);
        }
    }
}

