/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api.misc.world;

import io.github.lightman314.lightmanscurrency.api.misc.world.WorldArea;
import io.github.lightman314.lightmanscurrency.util.VersionUtil;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class WorldPosition {
    public static final WorldPosition VOID = new WorldPosition(null, BlockPos.ZERO);
    private final ResourceKey<Level> dimension;
    private final BlockPos pos;

    @Nullable
    public final ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    public final boolean sameDimension(@Nonnull WorldPosition other) {
        if (this.isVoid() || other.isVoid()) {
            return true;
        }
        return this.dimension.equals(other.dimension);
    }

    public final boolean sameDimension(@Nonnull Level level) {
        if (this.isVoid()) {
            return true;
        }
        return this.dimension.equals((Object)level.dimension());
    }

    public final boolean isVoid() {
        return this.dimension == null;
    }

    @Nonnull
    public BlockPos getPos() {
        return this.pos;
    }

    public final WorldArea getArea(int horizRadius, int vertSize, int vertOffset) {
        return WorldArea.of(this, horizRadius, vertSize, vertOffset);
    }

    private WorldPosition(@Nullable ResourceKey<Level> dimension, @Nonnull BlockPos pos) {
        this.dimension = dimension;
        this.pos = pos;
    }

    @Nonnull
    public static WorldPosition of(@Nullable ResourceKey<Level> dimension, @Nullable BlockPos pos) {
        if (dimension == null) {
            return VOID;
        }
        return new WorldPosition(dimension, pos != null ? pos : BlockPos.ZERO);
    }

    @Nonnull
    public static WorldPosition ofLevel(@Nullable Level level, @Nullable BlockPos pos) {
        return WorldPosition.of((ResourceKey<Level>)(level != null ? level.dimension() : null), pos);
    }

    @Nonnull
    public static WorldPosition ofBE(@Nullable BlockEntity be) {
        if (be == null) {
            return VOID;
        }
        return WorldPosition.ofLevel(be.getLevel(), be.getBlockPos());
    }

    @Nonnull
    public CompoundTag save() {
        CompoundTag tag = new CompoundTag();
        if (this.dimension == null) {
            return tag;
        }
        tag.putString("Dimension", this.dimension.location().toString());
        tag.putInt("X", this.pos.getX());
        tag.putInt("Y", this.pos.getY());
        tag.putInt("Z", this.pos.getZ());
        return tag;
    }

    @Nonnull
    public static WorldPosition load(@Nonnull CompoundTag tag) {
        if (tag.contains("Dimension")) {
            ResourceKey dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)VersionUtil.parseResource(tag.getString("Dimension")));
            BlockPos pos = new BlockPos(tag.getInt("X"), tag.getInt("Y"), tag.getInt("Z"));
            return WorldPosition.of((ResourceKey<Level>)dimension, pos);
        }
        return VOID;
    }

    public int hashCode() {
        return Objects.hash(this.dimension == null ? Integer.valueOf(0) : this.dimension.location(), this.pos);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof WorldPosition) {
            WorldPosition other = (WorldPosition)obj;
            if (other == this) {
                return true;
            }
            if (other.isVoid() != this.isVoid()) {
                return false;
            }
            if (this.isVoid()) {
                return true;
            }
            return other.dimension.equals(this.dimension) && other.pos.equals((Object)this.pos);
        }
        return false;
    }
}

