/*
 * Decompiled with CFR 0.152.
 */
package io.github.cotrin8672.itemindicator.render;

import io.github.cotrin8672.itemindicator.render.ItemOverlay;
import io.github.cotrin8672.itemindicator.render.ItemOverlayKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010%\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\n\u001a\u00020\t2\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\rJ\r\u0010\u000e\u001a\u00020\t\u00a2\u0006\u0004\b\u000e\u0010\u0003J\u0019\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u0005H\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010R&\u0010\u0012\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0004\u0012\u00020\u00070\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0012\u0010\u0013R \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00070\u00118\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0013\u00a8\u0006\u0015"}, d2={"Lio/github/cotrin8672/itemindicator/render/ItemOverlayHandler;", "", "<init>", "()V", "Lnet/minecraft/tags/TagKey;", "Lnet/minecraft/world/item/Item;", "tag", "Lio/github/cotrin8672/itemindicator/render/ItemOverlay;", "overlay", "", "registerOverlay", "(Lnet/minecraft/tags/TagKey;Lio/github/cotrin8672/itemindicator/render/ItemOverlay;)V", "item", "(Lnet/minecraft/world/item/Item;Lio/github/cotrin8672/itemindicator/render/ItemOverlay;)V", "remapOverlay", "getOverlay", "(Lnet/minecraft/world/item/Item;)Lio/github/cotrin8672/itemindicator/render/ItemOverlay;", "", "TAG_OVERLAY_LOOKUP", "Ljava/util/Map;", "ITEM_OVERLAY_LOOKUP", "itemindicator"})
@SourceDebugExtension(value={"SMAP\nItemOverlayHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ItemOverlayHandler.kt\nio/github/cotrin8672/itemindicator/render/ItemOverlayHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,47:1\n1863#2:48\n774#2:49\n865#2,2:50\n1863#2,2:52\n1864#2:54\n*S KotlinDebug\n*F\n+ 1 ItemOverlayHandler.kt\nio/github/cotrin8672/itemindicator/render/ItemOverlayHandler\n*L\n26#1:48\n30#1:49\n30#1:50,2\n31#1:52,2\n26#1:54\n*E\n"})
public final class ItemOverlayHandler {
    @NotNull
    public static final ItemOverlayHandler INSTANCE = new ItemOverlayHandler();
    @NotNull
    private static final Map<TagKey<Item>, ItemOverlay> TAG_OVERLAY_LOOKUP = new LinkedHashMap();
    @NotNull
    private static final Map<Item, ItemOverlay> ITEM_OVERLAY_LOOKUP = new LinkedHashMap();

    private ItemOverlayHandler() {
    }

    public final void registerOverlay(@NotNull TagKey<Item> tag, @NotNull ItemOverlay overlay) {
        Intrinsics.checkNotNullParameter(tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)overlay, (String)"overlay");
        ItemOverlay existingOverlay = TAG_OVERLAY_LOOKUP.get(tag);
        if (existingOverlay == null) {
            TAG_OVERLAY_LOOKUP.put(tag, overlay);
        } else {
            TAG_OVERLAY_LOOKUP.put(tag, ItemOverlayKt.and(existingOverlay, overlay));
        }
    }

    public final void registerOverlay(@NotNull Item item, @NotNull ItemOverlay overlay) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        Intrinsics.checkNotNullParameter((Object)overlay, (String)"overlay");
        ITEM_OVERLAY_LOOKUP.put(item, overlay);
    }

    /*
     * WARNING - void declaration
     */
    public final void remapOverlay() {
        Iterable $this$forEach$iv = TAG_OVERLAY_LOOKUP.keySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$forEach$iv2;
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv;
            TagKey tag = (TagKey)element$iv;
            boolean bl = false;
            Set set = BuiltInRegistries.ITEM.stream().collect(Collectors.toSet());
            Intrinsics.checkNotNullExpressionValue(set, (String)"collect(...)");
            Iterable iterable = set;
            boolean $i$f$filter = false;
            Iterator iterator = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Item it = (Item)element$iv$iv;
                boolean bl2 = false;
                if (!it.builtInRegistryHolder().tags().collect(Collectors.toSet()).contains(tag)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Item item = (Item)element$iv2;
                boolean bl3 = false;
                ItemOverlay existingOverlay = ITEM_OVERLAY_LOOKUP.get(item);
                if (existingOverlay == null) {
                    ItemOverlay itemOverlay = TAG_OVERLAY_LOOKUP.get(tag);
                    Intrinsics.checkNotNull((Object)itemOverlay);
                    ITEM_OVERLAY_LOOKUP.put(item, itemOverlay);
                    continue;
                }
                ItemOverlay itemOverlay = TAG_OVERLAY_LOOKUP.get(tag);
                Intrinsics.checkNotNull((Object)itemOverlay);
                ITEM_OVERLAY_LOOKUP.put(item, ItemOverlayKt.and(existingOverlay, itemOverlay));
            }
        }
    }

    @JvmStatic
    @Nullable
    public static final ItemOverlay getOverlay(@NotNull Item item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return ITEM_OVERLAY_LOOKUP.get(item);
    }
}

