/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod;

import dev.mineland.item_interactions_mod.CustomGuiComponents.ConfigInventoryPreview;
import dev.mineland.item_interactions_mod.CustomGuiComponents.SteppedSliderButton;
import dev.mineland.item_interactions_mod.GlobalDirt;
import dev.mineland.item_interactions_mod.ItemInteractionsConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.HeaderAndFooterLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ItemInteractionsSettingsScreen
extends Screen {
    private final Screen parent;
    private final HeaderAndFooterLayout layout = new HeaderAndFooterLayout((Screen)this, 33, 36);
    public Button button1;
    public Button button2;
    public Button doneButton;
    private Button debugButton;
    private CycleButton<ItemInteractionsConfig.animation> animationCycleButton;
    private SteppedSliderButton scaleSpeed;
    private SteppedSliderButton scaleAmount;
    private SteppedSliderButton mouseSpeedMult;
    private SteppedSliderButton mouseDeceleration;
    private Button guiParticlesButton;
    private Button resetButton;
    LinearLayout linearLayout = (LinearLayout)this.layout.addToContents((LayoutElement)LinearLayout.vertical().spacing(8));
    LinearLayout bodyLayout = ((LinearLayout)this.linearLayout.addChild((LayoutElement)LinearLayout.horizontal(), LayoutSettings::alignHorizontallyCenter)).spacing(8);
    LinearLayout leftColumnLayout = ((LinearLayout)this.bodyLayout.addChild((LayoutElement)LinearLayout.vertical())).spacing(8);
    LinearLayout speedAnimLayout = LinearLayout.vertical().spacing(4);
    LinearLayout scaleAnimLayout = LinearLayout.vertical().spacing(4);
    LinearLayout rightColumnLayout = ((LinearLayout)this.bodyLayout.addChild((LayoutElement)LinearLayout.vertical())).spacing(8);
    ItemInteractionsConfig.animation oldAnimationConfig = ItemInteractionsConfig.animationConfig;
    double oldScaleSpeed = ItemInteractionsConfig.scaleSpeed;
    double oldScaleAmount = ItemInteractionsConfig.scaleAmount;
    double oldMouseDeceleration = ItemInteractionsConfig.mouseDeceleration;
    double oldMouseSpeedMult = ItemInteractionsConfig.mouseSpeedMult;
    boolean oldParticleEnabled = ItemInteractionsConfig.enableGuiParticles;
    public ConfigInventoryPreview inventoryPreview = new ConfigInventoryPreview(this.width - 100 - 8, this.height / 2 - 50, 150, 100, (Component)Component.literal((String)"Inventory preview"));

    public ItemInteractionsSettingsScreen(Screen parent) {
        super((Component)Component.literal((String)"Item interactions mod settings"));
        this.parent = parent;
        ItemInteractionsConfig.refreshConfig();
        GlobalDirt.restore();
        this.createLayout();
        this.animationCycleButton.setTooltip(Tooltip.create((Component)Component.literal((String)"Type of animation that will play when carrying an item\nSpeed: tilts based off the mouse speed\nScale: scales the item up on cycles\nNone: no animation")));
        this.scaleSpeed.setTooltip(Tooltip.create((Component)Component.literal((String)"Speed of the scaling animation measured in seconds/cycle.")));
        this.scaleAmount.setTooltip(Tooltip.create((Component)Component.literal((String)"How much the item will scale up. \n0.1 = +1/10 \n1 = +1 (Double the item size)")));
        this.mouseSpeedMult.setTooltip(Tooltip.create((Component)Component.literal((String)"Multiplier for the speed gained while moving the mouse")));
        this.mouseDeceleration.setTooltip(Tooltip.create((Component)Component.literal((String)"The deceleration factor for the items. \n1 = normal deceleration\n0 = no deceleration")));
        this.guiParticlesButton.setTooltip(Tooltip.create((Component)Component.literal((String)"Enable or disable particles in the inventory from resource packs.")));
        boolean hadItems = false;
        if (Minecraft.getInstance().level != null && Minecraft.getInstance().player != null) {
            for (int hotbar = 0; hotbar < 9; ++hotbar) {
                ItemStack item = Minecraft.getInstance().player.getInventory().getItem(hotbar).copy();
                this.inventoryPreview.setItem(hotbar, item);
                if (item.isEmpty()) continue;
                hadItems = true;
            }
        }
        if (!hadItems) {
            this.inventoryPreview.setItem(0, new ItemStack((ItemLike)Items.CRAFTING_TABLE));
            this.inventoryPreview.setItem(1, new ItemStack((ItemLike)Items.OAK_LEAVES));
            this.inventoryPreview.setItem(2, new ItemStack((ItemLike)Items.DIAMOND_PICKAXE));
            this.inventoryPreview.setItem(4, new ItemStack((ItemLike)Items.REDSTONE_LAMP));
            this.inventoryPreview.setItem(6, new ItemStack((ItemLike)Items.FLINT_AND_STEEL));
            this.inventoryPreview.setItem(7, new ItemStack((ItemLike)Items.ZOMBIE_HEAD));
            this.inventoryPreview.setItem(8, new ItemStack((ItemLike)Items.EGG));
        }
        this.updateVisible();
    }

    void updateVisible() {
        this.scaleAnimLayout.visitWidgets(widget -> {
            widget.visible = false;
        });
        this.speedAnimLayout.visitWidgets(widget -> {
            widget.visible = false;
        });
        this.animationCycleButton.setTooltip(Tooltip.create((Component)Component.literal((String)"Type of animation that will play when carrying an item\n-speed: tilts based off the mouse speed\n-scale: scales the item up on cycles\n-none: no animation")));
        switch ((ItemInteractionsConfig.animation)((Object)this.animationCycleButton.getValue())) {
            case ANIM_SCALE: {
                this.scaleAnimLayout.visitWidgets(widget -> {
                    widget.visible = true;
                });
                break;
            }
            case ANIM_SPEED: {
                this.speedAnimLayout.visitWidgets(widget -> {
                    widget.visible = true;
                });
                break;
            }
            case NONE: {
                this.scaleAnimLayout.visitWidgets(widget -> {
                    widget.visible = false;
                });
                this.speedAnimLayout.visitWidgets(widget -> {
                    widget.visible = false;
                });
            }
        }
    }

    void createLayout() {
        MutableComponent debugButtonInitialText;
        this.layout.addTitleHeader(this.title, Minecraft.getInstance().font);
        this.animationCycleButton = (CycleButton)this.leftColumnLayout.addChild((LayoutElement)CycleButton.builder(animationSetting -> animationSetting.component.copy().withStyle(animationSetting == ItemInteractionsConfig.animation.NONE ? ChatFormatting.RED : ChatFormatting.YELLOW)).withValues((Object[])new ItemInteractionsConfig.animation[]{ItemInteractionsConfig.animation.ANIM_SPEED, ItemInteractionsConfig.animation.ANIM_SCALE, ItemInteractionsConfig.animation.NONE}).withInitialValue((Object)ItemInteractionsConfig.animationConfig).create((Component)Component.literal((String)"Animation"), (arg, arg2) -> {
            ItemInteractionsConfig.animationConfig = arg2;
            this.updateVisible();
        }));
        this.scaleSpeed = (SteppedSliderButton)this.scaleAnimLayout.addChild((LayoutElement)new SteppedSliderButton(this, 0, 0, 150, 20, CommonComponents.EMPTY, ItemInteractionsConfig.scaleSpeed, 0.0, 4.0, 40, false){
            {
                this.value = ItemInteractionsConfig.scaleSpeed;
                this.applyValue();
                this.updateMessage();
            }

            @Override
            protected void updateMessage() {
                this.setMessage((Component)Component.literal((String)("Scale speed: " + ItemInteractionsConfig.scaleSpeed)));
            }

            @Override
            protected void applyValue() {
                ItemInteractionsConfig.scaleSpeed = this.value;
            }
        });
        this.scaleAmount = (SteppedSliderButton)this.scaleAnimLayout.addChild((LayoutElement)new SteppedSliderButton(this, 0, 0, 150, 20, CommonComponents.EMPTY, ItemInteractionsConfig.scaleAmount, 0.0, 2.0, 20, false){
            {
                this.value = ItemInteractionsConfig.scaleAmount;
                this.applyValue();
                this.updateMessage();
            }

            @Override
            protected void updateMessage() {
                this.setMessage((Component)Component.literal((String)("Scale amount: " + ItemInteractionsConfig.scaleAmount)));
            }

            @Override
            protected void applyValue() {
                ItemInteractionsConfig.scaleAmount = Math.clamp(this.value, this.minValue, this.maxValue);
            }
        });
        this.mouseSpeedMult = (SteppedSliderButton)this.speedAnimLayout.addChild((LayoutElement)new SteppedSliderButton(this, 0, 0, 150, 20, CommonComponents.EMPTY, ItemInteractionsConfig.mouseSpeedMult, -2.0, 2.0, 40){
            {
                this.updateMessage();
            }

            @Override
            protected void updateMessage() {
                MutableComponent message = Component.literal((String)("Mouse speed: " + ItemInteractionsConfig.mouseSpeedMult + "x"));
                this.setMessage((Component)message);
            }

            @Override
            protected void applyValue() {
                ItemInteractionsConfig.mouseSpeedMult = this.value;
            }
        });
        this.mouseDeceleration = (SteppedSliderButton)this.speedAnimLayout.addChild((LayoutElement)new SteppedSliderButton(this, 0, 0, 150, 20, CommonComponents.EMPTY, ItemInteractionsConfig.mouseDeceleration, 0.0, 1.0, 10){
            {
                this.value = ItemInteractionsConfig.mouseDeceleration;
                this.applyValue();
                this.updateMessage();
            }

            @Override
            protected void updateMessage() {
                this.setMessage((Component)Component.literal((String)("Mouse deceleration: " + ItemInteractionsConfig.mouseDeceleration)));
            }

            @Override
            protected void applyValue() {
                ItemInteractionsConfig.mouseDeceleration = this.value;
            }
        });
        this.leftColumnLayout.addChild((LayoutElement)this.speedAnimLayout);
        this.leftColumnLayout.addChild((LayoutElement)this.scaleAnimLayout);
        if (ItemInteractionsConfig.debugDraws || GlobalDirt.devenv) {
            debugButtonInitialText = Component.literal((String)"debug: ").append((Component)Component.literal((String)("" + ItemInteractionsConfig.debugDraws)).withStyle(ItemInteractionsConfig.debugDraws ? ChatFormatting.GREEN : ChatFormatting.RED));
            this.debugButton = (Button)this.leftColumnLayout.addChild((LayoutElement)Button.builder((Component)debugButtonInitialText, self -> {
                ItemInteractionsConfig.debugDraws = !ItemInteractionsConfig.debugDraws;
                ChatFormatting color = ItemInteractionsConfig.debugDraws ? ChatFormatting.GREEN : ChatFormatting.RED;
                self.setMessage((Component)Component.literal((String)"debug: ").append((Component)Component.literal((String)("" + ItemInteractionsConfig.debugDraws)).withStyle(color)));
            }).build());
        }
        this.inventoryPreview = (ConfigInventoryPreview)this.rightColumnLayout.addChild((LayoutElement)this.inventoryPreview, LayoutSettings::alignVerticallyMiddle);
        this.rightColumnLayout.addChild((LayoutElement)Button.builder((Component)Component.literal((String)"Restore defaults"), self -> this.resetToDefaults()).width(100).build(), LayoutSettings::alignHorizontallyCenter);
        debugButtonInitialText = Component.literal((String)"Inventory particles: ").append((Component)Component.literal((String)("" + ItemInteractionsConfig.enableGuiParticles)).withStyle(ItemInteractionsConfig.enableGuiParticles ? ChatFormatting.GREEN : ChatFormatting.RED));
        this.guiParticlesButton = (Button)this.rightColumnLayout.addChild((LayoutElement)Button.builder((Component)debugButtonInitialText, self -> {
            ItemInteractionsConfig.enableGuiParticles = !ItemInteractionsConfig.enableGuiParticles;
            ChatFormatting color = ItemInteractionsConfig.enableGuiParticles ? ChatFormatting.GREEN : ChatFormatting.RED;
            self.setMessage((Component)Component.literal((String)"Inventory particles: ").append((Component)Component.literal((String)("" + ItemInteractionsConfig.enableGuiParticles)).withStyle(color)));
        }).build(), LayoutSettings::alignHorizontallyCenter);
        LinearLayout footerLayout = LinearLayout.horizontal().spacing(8);
        footerLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, arg -> this.onCancel()).width(150).build());
        footerLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_DONE, arg -> this.onClose()).width(150).build());
        this.layout.addToFooter((LayoutElement)footerLayout);
        this.updateVisible();
    }

    public void mouseMoved(double d, double e) {
        this.inventoryPreview.mouseMoved(d, e);
        super.mouseMoved(d, e);
    }

    protected void init() {
        this.layout.visitWidgets(arg2 -> {
            AbstractWidget uhh = (AbstractWidget)this.addRenderableWidget((GuiEventListener)arg2);
        });
        this.layout.arrangeElements();
        int firstY = this.speedAnimLayout.getY();
        this.scaleAnimLayout.setY(firstY);
    }

    public void onClose() {
        this.minecraft.setScreen(this.parent);
        ItemInteractionsConfig.createConfig();
    }

    public void onCancel() {
        ItemInteractionsConfig.animationConfig = this.oldAnimationConfig;
        ItemInteractionsConfig.scaleSpeed = this.oldScaleSpeed;
        ItemInteractionsConfig.scaleAmount = this.oldScaleAmount;
        ItemInteractionsConfig.mouseDeceleration = this.oldMouseDeceleration;
        ItemInteractionsConfig.mouseSpeedMult = this.oldMouseSpeedMult;
        ItemInteractionsConfig.enableGuiParticles = this.oldParticleEnabled;
        this.minecraft.setScreen(this.parent);
    }

    public void resetToDefaults() {
        this.animationCycleButton.setValue((Object)ItemInteractionsConfig.DefaultValues.animationConfig);
        this.scaleSpeed.setValue(1.0);
        this.scaleAmount.setValue(0.1);
        this.mouseSpeedMult.setValue(1.0);
        this.mouseDeceleration.setValue(1.0);
        this.guiParticlesButton.setMessage((Component)Component.literal((String)"Inventory particles: ").append((Component)Component.literal((String)"true").withStyle(ChatFormatting.GREEN)));
        ItemInteractionsConfig.init();
        this.updateVisible();
    }
}

