/*
 * Decompiled with CFR 0.152.
 */
package dev.mineland.item_interactions_mod.CarriedInteractions.Spawners;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.mineland.item_interactions_mod.CarriedInteractions.Particles.TexturedParticle;
import dev.mineland.item_interactions_mod.GlobalDirt;
import dev.mineland.item_interactions_mod.GuiRendererHelper;
import dev.mineland.item_interactions_mod.Item_interactions_mod;
import dev.mineland.item_interactions_mod.MiscUtils;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.ColorRGBA;

public class ParticleInstance {
    ResourceLocation id;
    public Optional<Float> x;
    public Optional<Float> y;
    public Optional<Float> speedX;
    public Optional<Float> speedY;
    public Optional<Float> accelerationX;
    public Optional<Float> accelerationY;
    public Optional<Float> frictionX;
    public Optional<Float> frictionY;
    public Optional<Float> duration;
    public Optional<ColorRGBA> colorStart;
    public Optional<ColorRGBA> colorEnd;
    public Optional<Float> brightnessStart;
    public Optional<Float> brightnessEnd;
    public Optional<Integer> count;
    public static final Codec<ParticleInstance> CODEC = RecordCodecBuilder.create(particleInstanceInstance -> particleInstanceInstance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(p -> p.id), (App)Codec.FLOAT.optionalFieldOf("x").forGetter(p -> p.x), (App)Codec.FLOAT.optionalFieldOf("y").forGetter(p -> p.y), (App)Codec.FLOAT.optionalFieldOf("speedX").forGetter(p -> p.speedX), (App)Codec.FLOAT.optionalFieldOf("speedY").forGetter(p -> p.speedY), (App)Codec.FLOAT.optionalFieldOf("accelerationX").forGetter(p -> p.accelerationX), (App)Codec.FLOAT.optionalFieldOf("accelerationY").forGetter(p -> p.accelerationY), (App)Codec.FLOAT.optionalFieldOf("frictionX").forGetter(p -> p.frictionX), (App)Codec.FLOAT.optionalFieldOf("frictionY").forGetter(p -> p.frictionY), (App)ColorRGBA.CODEC.optionalFieldOf("color_start").forGetter(p -> p.colorStart), (App)ColorRGBA.CODEC.optionalFieldOf("color_end").forGetter(p -> p.colorEnd), (App)Codec.FLOAT.optionalFieldOf("brightness_start").forGetter(p -> p.brightnessStart), (App)Codec.FLOAT.optionalFieldOf("brightness_end").forGetter(p -> p.brightnessEnd), (App)Codec.FLOAT.optionalFieldOf("duration").forGetter(p -> p.duration), (App)Codec.INT.optionalFieldOf("count").forGetter(p -> p.count)).apply((Applicative)particleInstanceInstance, ParticleInstance::new));
    public static final Codec<ParticleInstance> CONFIG_CODEC = RecordCodecBuilder.create(particleInstanceInstance -> particleInstanceInstance.group((App)Codec.FLOAT.optionalFieldOf("x").forGetter(p -> p.x), (App)Codec.FLOAT.optionalFieldOf("y").forGetter(p -> p.y), (App)Codec.FLOAT.optionalFieldOf("speedX").forGetter(p -> p.speedX), (App)Codec.FLOAT.optionalFieldOf("speedY").forGetter(p -> p.speedY), (App)Codec.FLOAT.optionalFieldOf("accelerationX").forGetter(p -> p.accelerationX), (App)Codec.FLOAT.optionalFieldOf("accelerationY").forGetter(p -> p.accelerationY), (App)Codec.FLOAT.optionalFieldOf("frictionX").forGetter(p -> p.frictionX), (App)Codec.FLOAT.optionalFieldOf("frictionY").forGetter(p -> p.frictionY), (App)ColorRGBA.CODEC.optionalFieldOf("color_start").forGetter(p -> p.colorStart), (App)ColorRGBA.CODEC.optionalFieldOf("color_end").forGetter(p -> p.colorEnd), (App)Codec.FLOAT.optionalFieldOf("brightness_start").forGetter(p -> p.brightnessStart), (App)Codec.FLOAT.optionalFieldOf("brightness_end").forGetter(p -> p.brightnessEnd), (App)Codec.FLOAT.optionalFieldOf("duration").forGetter(p -> p.duration), (App)Codec.INT.optionalFieldOf("count").forGetter(p -> p.count)).apply((Applicative)particleInstanceInstance, ParticleInstance::new));

    public ParticleInstance() {
        this(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public ParticleInstance(Optional<Float> x, Optional<Float> y, Optional<Float> speedX, Optional<Float> speedY, Optional<Float> accelerationX, Optional<Float> accelerationY, Optional<Float> frictionX, Optional<Float> frictionY, Optional<ColorRGBA> colorStart, Optional<ColorRGBA> colorEnd, Optional<Float> brightnessStart, Optional<Float> brightnessEnd, Optional<Float> duration, Optional<Integer> count) {
        this(null, x, y, speedX, speedY, accelerationX, accelerationY, frictionX, frictionY, colorStart, colorEnd, brightnessStart, brightnessEnd, duration, count);
    }

    public static ParticleInstance defaultVariance() {
        return new ParticleInstance(0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, new ColorRGBA(0), new ColorRGBA(0), 0.0f, 0.0f, 0.0f, 0);
    }

    public ParticleInstance(float x, float y, float speedX, float speedY, float accelerationX, float accelerationY, float frictionX, float frictionY, ColorRGBA colorStart, ColorRGBA colorEnd, float brightnessStart, float brightnessEnd, float duration, int count) {
        this(null, x, y, speedX, speedY, accelerationX, accelerationY, frictionX, frictionY, colorStart, colorEnd, brightnessStart, brightnessEnd, duration, count);
    }

    public ParticleInstance(ResourceLocation id, Optional<Float> x, Optional<Float> y, Optional<Float> speedX, Optional<Float> speedY, Optional<Float> accelerationX, Optional<Float> accelerationY, Optional<Float> frictionX, Optional<Float> frictionY, Optional<ColorRGBA> colorStart, Optional<ColorRGBA> colorEnd, Optional<Float> brightnessStart, Optional<Float> brightnessEnd, Optional<Float> duration, Optional<Integer> count) {
        if (id != null) {
            ResourceLocation fixedPath;
            ResourceManager resourceManager = Minecraft.getInstance().getResourceManager();
            Optional particleResource = resourceManager.getResource(fixedPath = id.withPath("particles/" + id.getPath() + ".json"));
            if (particleResource.isEmpty()) {
                if (!GlobalDirt.particleErrorList.containsKey(id)) {
                    GlobalDirt.particleErrorList.put(id, new ArrayList());
                }
                if (!GlobalDirt.particleErrorList.get(id).contains("m")) {
                    GlobalDirt.particleErrorList.get(id).add("m");
                    String err = "Missing GUI particle: '" + String.valueOf(id) + "'";
                    if (fixedPath.getPath().endsWith(".json.json")) {
                        err = "particle '" + String.valueOf(id) + " shouldn't end with .json in the spawner, just the location of the particle";
                    }
                    if (fixedPath.getPath().startsWith("particles/particles/")) {
                        err = "particle '" + String.valueOf(id) + "' shouldn't start the path with 'particles/'. Remove it";
                    }
                    Item_interactions_mod.warnMessage("[" + GlobalDirt.currentParticleSpawner + "] " + err);
                }
            } else {
                try (BufferedReader reader = ((Resource)particleResource.get()).openAsReader();){
                    JsonElement particleJson = JsonParser.parseReader((Reader)reader);
                    JsonArray textureList = particleJson.getAsJsonObject().get("textures").getAsJsonArray();
                    for (JsonElement textureLocationJson : textureList.asList()) {
                        ResourceLocation textureLocation = ResourceLocation.parse((String)textureLocationJson.getAsString());
                        if (!resourceManager.getResource(textureLocation = ResourceLocation.fromNamespaceAndPath((String)textureLocation.getNamespace(), (String)("textures/particle/" + textureLocation.getPath() + ".png"))).isEmpty() && GuiRendererHelper.setParticleSizeCache(textureLocation)) continue;
                        if (!GlobalDirt.particleErrorList.containsKey(id)) {
                            GlobalDirt.particleErrorList.put(id, new ArrayList());
                        }
                        GlobalDirt.particleErrorList.get(id).add("Missing texture " + String.valueOf(textureLocation));
                        Item_interactions_mod.warnMessage("[" + GlobalDirt.currentParticleSpawner + "]: Missing texture '" + String.valueOf(textureLocation) + "'");
                    }
                }
                catch (Exception e) {
                    Item_interactions_mod.errorMessage("Failed to parse GUI particle '" + String.valueOf(fixedPath) + "': " + String.valueOf(e));
                    return;
                }
            }
        }
        this.id = id;
        this.x = x;
        this.y = y;
        this.speedX = speedX;
        this.speedY = speedY;
        this.accelerationX = accelerationX;
        this.accelerationY = accelerationY;
        this.frictionX = frictionX;
        this.frictionY = frictionY;
        this.colorStart = colorStart;
        this.colorEnd = colorEnd;
        this.brightnessStart = brightnessStart;
        this.brightnessEnd = brightnessEnd;
        this.duration = duration;
        this.count = count;
    }

    public ParticleInstance(ResourceLocation id, float x, float y, float speedX, float speedY, float accelerationX, float accelerationY, float frictionX, float frictionY, ColorRGBA colorStart, ColorRGBA colorEnd, float brightnessStart, float brightnessEnd, float duration, int count) {
        this(id, Optional.of(Float.valueOf(x)), Optional.of(Float.valueOf(y)), Optional.of(Float.valueOf(speedX)), Optional.of(Float.valueOf(speedY)), Optional.of(Float.valueOf(accelerationX)), Optional.of(Float.valueOf(accelerationY)), Optional.of(Float.valueOf(frictionX)), Optional.of(Float.valueOf(frictionY)), Optional.of(colorStart), Optional.of(colorEnd), Optional.of(Float.valueOf(brightnessStart)), Optional.of(Float.valueOf(brightnessEnd)), Optional.of(Float.valueOf(duration)), Optional.of(count));
    }

    public void spawn(GuiGraphics guiGraphics, float spawnX, float spawnY, float spawnSpeedX, float spawnSpeedY, ParticleInstance attributes, ParticleInstance attributes_variance) {
        int[] pcEnd;
        int[] pcStart;
        double xVar = attributes_variance.x.orElse(Float.valueOf(0.0f)).floatValue();
        double yVar = attributes_variance.y.orElse(Float.valueOf(0.0f)).floatValue();
        double speedXVar = attributes_variance.speedX.orElse(Float.valueOf(0.0f)).floatValue();
        double speedYVar = attributes_variance.speedY.orElse(Float.valueOf(0.0f)).floatValue();
        double accelerationXVar = attributes_variance.accelerationX.orElse(Float.valueOf(0.0f)).floatValue();
        double accelerationYVar = attributes_variance.accelerationY.orElse(Float.valueOf(0.0f)).floatValue();
        double frictionXVar = attributes_variance.frictionX.orElse(Float.valueOf(0.0f)).floatValue();
        double frictionYVar = attributes_variance.frictionY.orElse(Float.valueOf(0.0f)).floatValue();
        float brightnessStartVar = attributes_variance.brightnessStart.orElse(Float.valueOf(0.0f)).floatValue();
        float brightnessEndVar = attributes_variance.brightnessEnd.orElse(Float.valueOf(0.0f)).floatValue();
        double x = this.x.orElse(attributes.x.orElse(Float.valueOf(0.0f))).floatValue();
        double y = this.y.orElse(attributes.y.orElse(Float.valueOf(0.0f))).floatValue();
        double speedX = this.speedX.orElse(attributes.speedX.orElse(Float.valueOf(0.0f))).floatValue();
        double speedY = this.speedY.orElse(attributes.speedY.orElse(Float.valueOf(0.0f))).floatValue();
        double accelerationX = this.accelerationX.orElse(attributes.accelerationX.orElse(Float.valueOf(0.0f))).floatValue();
        double accelerationY = this.accelerationY.orElse(attributes.accelerationY.orElse(Float.valueOf(0.0f))).floatValue();
        double frictionX = this.frictionX.orElse(attributes.frictionX.orElse(Float.valueOf(1.0f))).floatValue();
        double frictionY = this.frictionY.orElse(attributes.frictionY.orElse(Float.valueOf(1.0f))).floatValue();
        int[] colorStart = MiscUtils.int2Array(this.colorStart.orElse(attributes.colorStart.orElse(this.colorEnd.orElse(attributes.colorEnd.orElse(new ColorRGBA(-1))))).rgba());
        int colorVarianceStart = attributes_variance.colorStart.orElse(new ColorRGBA(0)).rgba();
        float brightnessStart = this.brightnessStart.orElse(attributes.brightnessStart.orElse(this.brightnessEnd.orElse(attributes.brightnessEnd.orElse(Float.valueOf(1.0f))))).floatValue();
        float brightnessVarianceStart = attributes_variance.brightnessStart.orElse(Float.valueOf(0.0f)).floatValue();
        int[] colorVarianced = pcStart = MiscUtils.colorVariance(colorStart, MiscUtils.int2Array(colorVarianceStart));
        pcStart = MiscUtils.applyBrightness(pcStart, MiscUtils.randomVariance(brightnessStart, brightnessVarianceStart));
        int[] colorEnd = MiscUtils.int2Array(this.colorEnd.orElse(attributes.colorEnd.orElse(this.colorStart.orElse(attributes.colorStart.orElse(new ColorRGBA(-1))))).rgba());
        boolean inherit = false;
        if (this.colorEnd.isPresent()) {
            pcEnd = MiscUtils.int2Array(this.colorEnd.get().rgba());
        } else if (attributes.colorEnd.isPresent()) {
            pcEnd = MiscUtils.int2Array(attributes.colorEnd.get().rgba());
        } else {
            pcEnd = colorStart;
            inherit = true;
        }
        if (attributes_variance.colorEnd.isPresent()) {
            pcEnd = MiscUtils.colorVariance(pcEnd, MiscUtils.int2Array(attributes_variance.colorEnd.get().rgba()));
        } else {
            int[] nArray = pcEnd = inherit ? colorVarianced : pcEnd;
        }
        pcEnd = this.brightnessEnd.isPresent() || attributes.brightnessEnd.isPresent() ? MiscUtils.applyBrightness(pcEnd, MiscUtils.randomVariance(this.brightnessEnd.orElse(attributes.brightnessEnd.orElse(Float.valueOf(1.0f))).floatValue(), attributes_variance.brightnessEnd.orElse(Float.valueOf(0.0f)).floatValue())) : (inherit ? pcStart : pcEnd);
        double pX = MiscUtils.randomVariance((double)spawnX + x, xVar);
        double pY = MiscUtils.randomVariance((double)spawnY - y, yVar);
        double pSpeedX = MiscUtils.randomVariance((double)spawnSpeedX + speedX, speedXVar);
        double pSpeedY = MiscUtils.randomVariance((double)spawnSpeedY - speedY, speedYVar);
        double pAccX = MiscUtils.randomVariance(accelerationX, accelerationXVar);
        double pAccY = MiscUtils.randomVariance(-accelerationY, accelerationYVar);
        double pFrictX = Math.clamp(MiscUtils.randomVariance(frictionX, frictionXVar), 0.0, 1.0);
        double pFrictY = Math.clamp(MiscUtils.randomVariance(frictionY, frictionYVar), 0.0, 1.0);
        double pLifetime = MiscUtils.randomVariance(this.duration.orElse(attributes.duration.orElse(Float.valueOf(20.0f))).floatValue(), attributes_variance.duration.orElse(Float.valueOf(0.0f)).floatValue());
        new TexturedParticle(guiGraphics, pX, pY, pSpeedX, pSpeedY, pAccX, pAccY, pFrictX, pFrictY, pLifetime, this.id, MiscUtils.array2Int(pcStart), MiscUtils.array2Int(pcEnd));
    }

    public ParticleInstance copy() {
        return new ParticleInstance(this.x, this.y, this.speedX, this.speedY, this.accelerationX, this.accelerationY, this.frictionX, this.frictionY, this.colorStart, this.colorEnd, this.brightnessStart, this.brightnessEnd, this.duration, this.count);
    }
}

