/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.utils.cradles;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.utils.EntityCradle;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class EntTypeCradle<E extends Entity>
extends EntityCradle {
    private static final HashMap<ResourceLocation, Entity> ENTITY_CACHE = new HashMap();
    private final EntityType<E> type;

    @Override
    public String getId() {
        return this.type.getDescriptionId();
    }

    public EntTypeCradle(EntityType<E> type) {
        this.type = type;
    }

    public static Optional<EntTypeCradle> fromTypeId(ResourceLocation id) {
        return EntityType.byString((String)id.toString()).map(EntTypeCradle::new);
    }

    public EntityType<E> getEntType() {
        return this.type;
    }

    @Override
    public EntityCradle.CradleType<?> getType() {
        return EntTypeCradleType.INSTANCE;
    }

    @Override
    public Entity getEntity(Level world) {
        ResourceLocation typeId = EntityType.getKey(this.type);
        if (ENTITY_CACHE.containsKey(typeId)) {
            return ENTITY_CACHE.get(typeId);
        }
        try {
            Entity newEnt = this.type.create(world);
            ENTITY_CACHE.put(typeId, newEnt);
            return newEnt;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static class EntTypeCradleType
    implements EntityCradle.CradleType<EntTypeCradle> {
        public static EntTypeCradleType INSTANCE = EntityCradle.addCradleType(new EntTypeCradleType());

        private EntTypeCradleType() {
        }

        @Override
        public ResourceLocation getId() {
            return Inline.id("enttype");
        }

        @Override
        public Codec<EntTypeCradle> getCodec() {
            return ResourceLocation.CODEC.comapFlatMap(id -> EntTypeCradle.fromTypeId(id).map(DataResult::success).orElse(DataResult.error(() -> "no entity type: " + id.toString())), cradle -> EntityType.getKey(cradle.getEntType()));
        }
    }
}

