/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.utils;

import com.mojang.datafixers.util.Either;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.utils.ImgFormatParser;
import com.samsthenerd.inline.utils.IntPair;
import com.samsthenerd.inline.utils.SpriteUVLens;
import com.samsthenerd.inline.utils.SpriteUVRegion;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;

public class URLTextureUtils {
    private static final Map<ResourceLocation, LoadingState> LOADING_TEXTURE_STATES = Collections.synchronizedMap(new HashMap());
    private static final Tuple<IntPair, SpriteUVLens> ERROR_TEXT_INFO = new Tuple((Object)new IntPair(16, 16), (Object)SpriteUVRegion.FULL.asLens());

    @Nullable
    public static ResourceLocation loadTextureFromURL(String urlStr, ResourceLocation textureId) {
        LoadingState state = LOADING_TEXTURE_STATES.get(textureId);
        if (state == LoadingState.IN_PROGRESS) {
            return null;
        }
        if (state == LoadingState.ERROR) {
            return MissingTextureAtlasSprite.getLocation();
        }
        if (state instanceof LoadingState.SuccessState) {
            LoadingState.SuccessState succSt = (LoadingState.SuccessState)state;
            return succSt.textId();
        }
        if (state != null) {
            return MissingTextureAtlasSprite.getLocation();
        }
        LOADING_TEXTURE_STATES.put(textureId, LoadingState.IN_PROGRESS);
        CompletableFuture.runAsync(() -> {
            try {
                ImgFormatParser parser;
                Either<ImgFormatParser.ImgParseResult, String> imgResult;
                URL textureUrl = URI.create(urlStr).toURL();
                URLConnection conn = textureUrl.openConnection();
                InputStream stream = conn.getInputStream();
                String contentType = URLConnection.guessContentTypeFromStream(stream);
                if (contentType == null) {
                    contentType = conn.getContentType();
                }
                if ((imgResult = (parser = ImgFormatParser.getFormatParser(contentType)).tryParse(stream, contentType)).left().isPresent()) {
                    ImgFormatParser.ImgParseResult res = (ImgFormatParser.ImgParseResult)imgResult.left().get();
                    Minecraft.getInstance().execute(() -> LOADING_TEXTURE_STATES.put(textureId, new LoadingState.SuccessState(res.dims(), res.lens(), res.registerTextureCallback().apply(textureId))));
                } else {
                    String err = (String)imgResult.right().get();
                    Inline.LOGGER.error("Failed to parse image " + urlStr + " : " + err);
                    LOADING_TEXTURE_STATES.put(textureId, LoadingState.ERROR);
                }
            }
            catch (IOException e) {
                Inline.LOGGER.error("Failed to parse image " + urlStr + " : " + String.valueOf(e));
                LOADING_TEXTURE_STATES.put(textureId, LoadingState.ERROR);
            }
        });
        return null;
    }

    @Nullable
    public static Tuple<IntPair, SpriteUVLens> getTextureInfo(ResourceLocation textureId) {
        LoadingState state = LOADING_TEXTURE_STATES.get(textureId);
        if (state == LoadingState.IN_PROGRESS) {
            return null;
        }
        if (state == LoadingState.ERROR) {
            return ERROR_TEXT_INFO;
        }
        if (state instanceof LoadingState.SuccessState) {
            LoadingState.SuccessState succSt = (LoadingState.SuccessState)state;
            return new Tuple((Object)succSt.dims, (Object)succSt.lens());
        }
        return null;
    }

    static {
        ImgFormatParser.loadBuiltinParsers();
    }

    public static sealed interface LoadingState {
        public static final LoadingState ERROR = new StrState("error");
        public static final LoadingState IN_PROGRESS = new StrState("progress");

        public record StrState(String st) implements LoadingState
        {
        }

        public record SuccessState(IntPair dims, SpriteUVLens lens, ResourceLocation textId) implements LoadingState
        {
        }
    }
}

