/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.samsthenerd.inline.utils.IntPair;
import com.samsthenerd.inline.utils.SpriteUVLens;
import com.samsthenerd.inline.utils.SpriteUVRegion;
import com.samsthenerd.inline.utils.Spritelike;
import net.minecraft.resources.ResourceLocation;

public class TextureSprite
extends Spritelike {
    private ResourceLocation id;
    private final IntPair textDims;
    private final SpriteUVLens lens;

    public TextureSprite(ResourceLocation id, float minU, float minV, float maxU, float maxV, int textureWidth, int textureHeight) {
        this(id, new IntPair(textureWidth, textureHeight), new SpriteUVRegion(minU, minV, maxU, maxV).asLens());
    }

    public TextureSprite(ResourceLocation id, int textureWidth, int textureHeight) {
        this(id, 0.0f, 0.0f, 1.0f, 1.0f, textureWidth, textureHeight);
    }

    public TextureSprite(ResourceLocation id, IntPair textureDimensions, SpriteUVLens lens) {
        this.id = id;
        this.textDims = textureDimensions;
        this.lens = lens;
    }

    public static TextureSprite fromPixels(ResourceLocation id, int left, int top, int width, int height, int textWidth, int textHeight) {
        return new TextureSprite(id, (float)left / (float)textWidth, (float)top / (float)textHeight, (float)(left + width) / (float)textWidth, (float)(top + height) / (float)textHeight, textWidth, textHeight);
    }

    public TextureSprite(ResourceLocation id) {
        this(id, 0.0f, 0.0f, 1.0f, 1.0f, 16, 16);
    }

    @Override
    public Spritelike.SpritelikeType getType() {
        return TextureSpriteType.INSTANCE;
    }

    @Override
    public ResourceLocation getTextureId() {
        return this.id;
    }

    @Override
    public SpriteUVRegion getUVs(long time) {
        return this.lens.genUVs(time);
    }

    @Override
    public int getTextureWidth() {
        return this.textDims.width();
    }

    @Override
    public int getTextureHeight() {
        return this.textDims.height();
    }

    public static class TextureSpriteType
    implements Spritelike.SpritelikeType {
        public static final TextureSpriteType INSTANCE = new TextureSpriteType();
        private static final MapCodec<TextureSprite> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(TextureSprite::getTextureId), (App)Codec.INT.optionalFieldOf("textWidth", (Object)16).forGetter(TextureSprite::getTextureWidth), (App)Codec.INT.optionalFieldOf("textHeight", (Object)16).forGetter(TextureSprite::getTextureHeight)).apply((Applicative)instance, TextureSprite::new));

        public MapCodec<TextureSprite> getCodec() {
            return CODEC;
        }

        @Override
        public String getId() {
            return "texture";
        }
    }
}

