/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.tooltips.components;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.samsthenerd.inline.tooltips.data.EntityDisplayTTData;
import com.samsthenerd.inline.utils.EntityCradle;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class EntityDisplayTTComp
implements ClientTooltipComponent {
    public static final float DEFAULT_RENDER_SIZE = 96.0f;
    private EntityCradle cradle;
    private BiFunction<Integer, Integer, Integer> widthProvider;

    public EntityDisplayTTComp(EntityDisplayTTData tt) {
        this.cradle = tt.cradle;
        this.widthProvider = tt.widthProvider;
    }

    public void renderImage(Font font, int mouseX, int mouseY, GuiGraphics context) {
        Entity ent = this.cradle.getEntity((Level)Minecraft.getInstance().level);
        if (ent == null) {
            return;
        }
        AABB bounds = ent.getBoundingBox().inflate(0.0, 0.05, 0.0);
        double height = bounds.getYsize();
        float rot = 15.0f;
        EntityRenderer renderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(ent);
        PoseStack matrices = context.pose();
        matrices.pushPose();
        int rHeight = this.getRenderHeight();
        int ttWidth = this.getWidth(font);
        matrices.translate((double)mouseX + (double)ttWidth / 2.0, (double)mouseY, 500.0);
        float scaleFactor = (float)((double)rHeight / height);
        matrices.scale(scaleFactor, -scaleFactor, scaleFactor);
        matrices.translate(0.0, -height, 0.0);
        Minecraft client = Minecraft.getInstance();
        matrices.mulPose(Axis.YP.rotationDegrees(rot));
        renderer.render(ent, 0.0f, 0.0f, matrices, (MultiBufferSource)context.bufferSource(), 0xF000F0);
        matrices.popPose();
    }

    public int getWidth(Font pFont) {
        Entity ent = this.cradle.getEntity((Level)Minecraft.getInstance().level);
        if (ent == null) {
            return 0;
        }
        AABB bounds = ent.getBoundingBox().inflate(0.0, 0.05, 0.0);
        double width = bounds.getXsize();
        double depth = bounds.getZsize();
        double height = bounds.getYsize();
        float rot = 15.0f;
        double radRot = Math.toRadians(rot % 90.0f);
        double pWidth = width * Math.cos(radRot) + depth * Math.sin(radRot);
        return this.widthProvider.apply((int)(pWidth * 100.0), (int)(height * 100.0)) + 16;
    }

    private int getRenderHeight() {
        Entity ent = this.cradle.getEntity((Level)Minecraft.getInstance().level);
        if (ent == null) {
            return 0;
        }
        AABB bounds = ent.getBoundingBox().inflate(0.0, 0.05, 0.0);
        double width = bounds.getXsize();
        double depth = bounds.getZsize();
        double height = bounds.getYsize();
        float rot = 15.0f;
        double radRot = Math.toRadians(rot % 90.0f);
        double pWidth = width * Math.cos(radRot) + depth * Math.sin(radRot);
        int realWidth = this.widthProvider.apply((int)(pWidth * 100.0), (int)(height * 100.0));
        if (pWidth == 0.0) {
            return 0;
        }
        return (int)((double)realWidth * (height / pWidth));
    }

    public int getHeight() {
        return this.getRenderHeight() + 4;
    }
}

