/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.util.concurrent.AtomicDouble;
import com.mojang.blaze3d.pipeline.TextureTarget;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.InlineData;
import com.samsthenerd.inline.api.client.GlowHandling;
import com.samsthenerd.inline.api.client.InlineClientAPI;
import com.samsthenerd.inline.api.client.InlineRenderer;
import com.samsthenerd.inline.impl.InlineStyle;
import com.samsthenerd.inline.mixin.core.MixinSetTessBuffer;
import com.samsthenerd.inline.utils.ColorUtils;
import com.samsthenerd.inline.utils.Spritelike;
import com.samsthenerd.inline.utils.SpritelikeRenderers;
import com.samsthenerd.inline.utils.TextureSprite;
import com.samsthenerd.inline.utils.VCPImmediateButImLyingAboutIt;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.time.Duration;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Tuple;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

public class InlineRenderCore {
    private static TextureTarget GLOW_BUFF = new TextureTarget(128, 128, true, Minecraft.ON_OSX);
    private static Set<ResourceLocation> ERRORED_RENDERERS = new HashSet<ResourceLocation>();
    private static final Cache<String, Spritelike> GLOW_TEXTURE_CACHE = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(Duration.ofMinutes(5L)).removalListener(notif -> {
        Object patt0$temp = notif.getValue();
        if (patt0$temp instanceof TextureSprite) {
            TextureSprite tSprite = (TextureSprite)patt0$temp;
            Minecraft.getInstance().getTextureManager().release(tSprite.getTextureId());
        }
    }).build();
    private static final Tesselator secondaryTess = new Tesselator();

    public static boolean textDrawerAcceptHandler(int index, Style style, int codepoint, RenderArgs args) {
        PoseStack matrices;
        Tesselator heldTess;
        InlineRenderer<?> renderer;
        InlineData inlData;
        block11: {
            int rendererARGB;
            boolean needToHandleSize;
            MultiBufferSource.BufferSource imm;
            inlData = style.getInlineData();
            if (inlData == null) {
                return false;
            }
            renderer = InlineClientAPI.INSTANCE.getRenderer(inlData.getRendererId());
            if (renderer == null) {
                return false;
            }
            boolean noGlowHandle = !(renderer.getGlowPreference(inlData) instanceof GlowHandling.None);
            boolean hasGlowyMarker = (Boolean)style.getComponent(InlineStyle.GLOWY_MARKER_COMP);
            if (noGlowHandle && hasGlowyMarker) {
                return true;
            }
            int glowColor = (Integer)style.getComponent(InlineStyle.GLOWY_PARENT_COMP);
            boolean needsGlowChildren = glowColor != -1 && renderer.getGlowPreference(inlData) instanceof GlowHandling.Full;
            heldTess = Tesselator.getInstance();
            MixinSetTessBuffer.setInstance(secondaryTess);
            MultiBufferSource multiBufferSource = args.provider();
            MultiBufferSource.BufferSource immToUse = multiBufferSource instanceof MultiBufferSource.BufferSource ? (imm = (MultiBufferSource.BufferSource)multiBufferSource) : VCPImmediateButImLyingAboutIt.of(args.provider());
            immToUse.endBatch();
            GuiGraphics drawContext = new GuiGraphics(Minecraft.getInstance(), immToUse);
            matrices = drawContext.pose();
            matrices.pushPose();
            double sizeMod = (Double)style.getComponent(InlineStyle.SIZE_MODIFIER_COMP);
            matrices.mulPose(args.matrix());
            matrices.mulPose(new Matrix4f().scale(1.0f, 1.0f, 0.001f));
            matrices.last().normal().mul((Matrix3fc)new Matrix3f(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 0.0f));
            matrices.last().normal().scale(-1.0f);
            matrices.translate(args.x(), args.y(), 0.0f);
            double maxSizeMod = InlineClientAPI.INSTANCE.getConfig().maxChatSizeModifier();
            if (sizeMod > maxSizeMod && InlineRenderer.isFlat(matrices, args.layerType) && InlineRenderer.isChatty()) {
                sizeMod = maxSizeMod;
            }
            boolean bl = needToHandleSize = sizeMod != 1.0 && !renderer.handleOwnSizing(inlData);
            if (needToHandleSize) {
                double yOffset = (sizeMod - 1.0) * 4.0;
                matrices.translate(0.0, -yOffset, 0.0);
                matrices.scale((float)sizeMod, (float)sizeMod, 1.0f);
            }
            float alphaToUse = args.alpha() == 0.0f ? 1.0f : args.alpha();
            int usableColor = rendererARGB = FastColor.ARGB32.color((int)Math.round(alphaToUse * 255.0f), (int)Math.round(args.red() * 255.0f), (int)Math.round(args.green() * 255.0f), (int)Math.round(args.blue() * 255.0f));
            if (style.getColor() != null) {
                usableColor = FastColor.ARGB32.multiply((int)rendererARGB, (int)(style.getColor().getValue() | 0xFF000000));
            }
            InlineRenderer.TextRenderingContext trContext = new InlineRenderer.TextRenderingContext(args.light(), args.shadow(), args.brightnessMultiplier(), args.red(), args.green(), args.blue(), args.alpha() == 0.0f ? 1.0f : args.alpha(), args.layerType(), args.provider(), (Boolean)style.getComponent(InlineStyle.GLOWY_MARKER_COMP), (Integer)style.getComponent(InlineStyle.GLOWY_PARENT_COMP), usableColor);
            if (!renderer.handleOwnTransparency(inlData)) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)alphaToUse);
            }
            try {
                if (needsGlowChildren) {
                    Tuple<Spritelike, Runnable> texResult = InlineRenderCore.getGlowTextureSprite(inlData, renderer, immToUse, sizeMod, index, style, codepoint, trContext);
                    Spritelike backSprite = (Spritelike)texResult.getA();
                    int brighterGlow = ColorUtils.ARGBtoHSB(glowColor)[2] > ColorUtils.ARGBtoHSB(usableColor)[2] ? glowColor : usableColor;
                    SpritelikeRenderers.getRenderer(backSprite).drawSpriteWithLight(backSprite, drawContext, -2.0f, -4.0f, 0.0f, 16.0f, 16.0f, trContext.light(), brighterGlow);
                    ((Runnable)texResult.getB()).run();
                }
                matrices.translate(0.0f, 0.0f, 10.0f);
                args.xUpdater().addAndGet((double)((float)renderer.render(inlData, drawContext, index, style, codepoint, trContext) * (needToHandleSize ? (float)sizeMod : 1.0f)));
                immToUse.endBatch();
            }
            catch (Exception e) {
                if (!ERRORED_RENDERERS.add(inlData.getRendererId())) break block11;
                Inline.LOGGER.error("Error rendering inline with renderer: " + inlData.getRendererId().toString() + " -- To prevent logspam this will only show once. This is likely an issue with whatever mod adds the renderer.");
            }
        }
        if (!renderer.handleOwnTransparency(inlData)) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        matrices.popPose();
        MixinSetTessBuffer.setInstance(heldTess);
        return true;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static Tuple<Spritelike, Runnable> getGlowTextureSprite(InlineData inlData, InlineRenderer renderer, MultiBufferSource.BufferSource immToUse, double sizeMod, int index, Style style, int codepoint, InlineRenderer.TextRenderingContext trContext) {
        Spritelike texSpriteMaybe;
        double outlineScaleBack = 1.0 / sizeMod;
        boolean needToHandleSize = sizeMod != 1.0 && !renderer.handleOwnSizing(inlData);
        GlowHandling glowHandling = renderer.getGlowPreference(inlData);
        if (!(glowHandling instanceof GlowHandling.Full)) {
            return null;
        }
        GlowHandling.Full fullHandling = (GlowHandling.Full)glowHandling;
        String texCacheId = null;
        if (fullHandling.cacheId != null && (texSpriteMaybe = (Spritelike)GLOW_TEXTURE_CACHE.getIfPresent((Object)(texCacheId = "inlineglowtexture" + renderer.getId().toLanguageKey() + "." + fullHandling.cacheId + sizeMod))) != null) {
            return new Tuple((Object)texSpriteMaybe, () -> {});
        }
        int resScale = 8;
        GLOW_BUFF.setClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        GLOW_BUFF.clear(false);
        Minecraft.getInstance().getMainRenderTarget().unbindWrite();
        Matrix4fStack mvStack = RenderSystem.getModelViewStack();
        Matrix4f backupProjMatrix = RenderSystem.getProjectionMatrix();
        mvStack.pushMatrix();
        mvStack.identity();
        RenderSystem.applyModelViewMatrix();
        VertexSorting backupVertexSorter = RenderSystem.getVertexSorting();
        RenderSystem.backupProjectionMatrix();
        Matrix4f newProjMatrix = new Matrix4f();
        newProjMatrix.identity();
        newProjMatrix.setOrtho(0.0f, (float)(16 * resScale), 0.0f, (float)(16 * resScale), 0.0f, 100.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)newProjMatrix, (VertexSorting)VertexSorting.DISTANCE_TO_ORIGIN);
        GLOW_BUFF.bindWrite(true);
        GuiGraphics glowContext = new GuiGraphics(Minecraft.getInstance(), immToUse);
        PoseStack glowStack = glowContext.pose();
        glowStack.pushPose();
        glowStack.translate((float)(2 * resScale), (float)(4 * resScale), -50.0f);
        glowStack.scale((float)resScale, (float)resScale, 1.0f);
        glowStack.mulPose(new Matrix4f().scale(1.0f, 1.0f, 0.01f));
        float xOffsetDiff = (float)renderer.render(inlData, glowContext, index, style, codepoint, trContext) * (needToHandleSize ? (float)sizeMod : 1.0f);
        immToUse.endBatch();
        mvStack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.setProjectionMatrix((Matrix4f)backupProjMatrix, (VertexSorting)backupVertexSorter);
        GLOW_BUFF.unbindWrite();
        try (NativeImage nativeImage = new NativeImage(16 * resScale, 16 * resScale, true);){
            GLOW_BUFF.bindRead();
            nativeImage.downloadTexture(0, false);
            GLOW_BUFF.unbindRead();
            NativeImage fullImage = new NativeImage(nativeImage.getWidth(), nativeImage.getHeight(), true);
            int outlineRange = (int)Math.round((double)resScale * outlineScaleBack);
            LinkedList<Integer> pixelQueue = new LinkedList<Integer>();
            Int2IntOpenHashMap seenPixels = new Int2IntOpenHashMap();
            int imgWidth = nativeImage.getWidth();
            int imgHeight = nativeImage.getHeight();
            for (int px = 0; px < imgWidth; ++px) {
                for (int py = 0; py < imgHeight; ++py) {
                    if (FastColor.ARGB32.alpha((int)nativeImage.getPixelRGBA(px, py)) == 0) continue;
                    int thisPos = px + py * imgWidth;
                    seenPixels.put(thisPos, 0);
                    pixelQueue.add(thisPos);
                }
            }
            nativeImage.close();
            while (!pixelQueue.isEmpty()) {
                int cPix = (Integer)pixelQueue.poll();
                int cX = cPix % imgWidth;
                int cY = cPix / imgWidth;
                fullImage.setPixelRGBA(cX, cY, -1);
                if (seenPixels.get(cPix) >= outlineRange) continue;
                for (int i = -1; i <= 1; ++i) {
                    if (cX + i < 0 || cX + i >= imgWidth) continue;
                    for (int j = -1; j <= 1; ++j) {
                        int nbrPos;
                        if (cY + j < 0 || cY + j >= imgHeight || seenPixels.containsKey(nbrPos = cPix + i + j * imgWidth)) continue;
                        seenPixels.put(nbrPos, seenPixels.get(cPix) + 1);
                        pixelQueue.add(nbrPos);
                    }
                }
            }
            Minecraft.getInstance().getMainRenderTarget().bindWrite(true);
            if (texCacheId != null) {
                ResourceLocation backTexId = Minecraft.getInstance().getTextureManager().register(texCacheId, new DynamicTexture(fullImage));
                TextureSprite tSprite = new TextureSprite(backTexId);
                GLOW_TEXTURE_CACHE.put((Object)texCacheId, (Object)tSprite);
                Tuple tuple = new Tuple((Object)tSprite, () -> {});
                return tuple;
            }
            ResourceLocation backTexId = Minecraft.getInstance().getTextureManager().register(Inline.id("glowtextureback").toLanguageKey(), new DynamicTexture(fullImage));
            Tuple tuple = new Tuple((Object)new TextureSprite(backTexId), () -> Minecraft.getInstance().getTextureManager().release(backTexId));
            return tuple;
        }
        catch (Exception e) {
            Inline.LOGGER.error(e.toString());
            return null;
        }
    }

    public record RenderArgs(float x, float y, Matrix4f matrix, int light, boolean shadow, float brightnessMultiplier, float red, float green, float blue, float alpha, Font.DisplayMode layerType, MultiBufferSource provider, AtomicDouble xUpdater) {
    }
}

