/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.api.data;

import com.mojang.serialization.Codec;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.InlineData;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ItemInlineData
implements InlineData<ItemInlineData> {
    private ItemStack stack;

    public ItemDataType getType() {
        return ItemDataType.INSTANCE;
    }

    @Override
    public ResourceLocation getRendererId() {
        return Inline.id("item");
    }

    public ItemStack getStack() {
        return this.stack;
    }

    public ItemInlineData(ItemStack stack) {
        this.stack = stack;
    }

    public static Component make(ItemStack stack) {
        HoverEvent hover = new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(stack));
        Style style = Style.EMPTY.withHoverEvent(hover).withInlineData(new ItemInlineData(stack));
        return Component.literal((String)"#").setStyle(style);
    }

    public static class ItemDataType
    implements InlineData.InlineDataType<ItemInlineData> {
        public static ItemDataType INSTANCE = new ItemDataType();

        @Override
        public ResourceLocation getId() {
            return Inline.id("item");
        }

        @Override
        public Codec<ItemInlineData> getCodec() {
            return ItemStack.CODEC.xmap(ItemInlineData::new, ItemInlineData::getStack);
        }
    }
}

