/*
 * Decompiled with CFR 0.152.
 */
package guideme.internal.shaded.lucene.index;

import guideme.internal.shaded.lucene.codecs.DocValuesConsumer;
import guideme.internal.shaded.lucene.codecs.DocValuesProducer;
import guideme.internal.shaded.lucene.index.DocValuesWriter;
import guideme.internal.shaded.lucene.index.DocsWithFieldSet;
import guideme.internal.shaded.lucene.index.EmptyDocValuesProducer;
import guideme.internal.shaded.lucene.index.FieldInfo;
import guideme.internal.shaded.lucene.index.SegmentWriteState;
import guideme.internal.shaded.lucene.index.SortedDocValues;
import guideme.internal.shaded.lucene.index.Sorter;
import guideme.internal.shaded.lucene.search.DocIdSetIterator;
import guideme.internal.shaded.lucene.util.ByteBlockPool;
import guideme.internal.shaded.lucene.util.BytesRef;
import guideme.internal.shaded.lucene.util.BytesRefHash;
import guideme.internal.shaded.lucene.util.Counter;
import guideme.internal.shaded.lucene.util.packed.PackedLongValues;
import java.io.IOException;
import java.util.Arrays;

class SortedDocValuesWriter
extends DocValuesWriter<SortedDocValues> {
    final BytesRefHash hash;
    private final PackedLongValues.Builder pending;
    private final DocsWithFieldSet docsWithField;
    private final Counter iwBytesUsed;
    private long bytesUsed;
    private final FieldInfo fieldInfo;
    private int lastDocID = -1;
    private PackedLongValues finalOrds;
    private int[] finalSortedValues;
    private int[] finalOrdMap;

    public SortedDocValuesWriter(FieldInfo fieldInfo, Counter iwBytesUsed, ByteBlockPool pool) {
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = iwBytesUsed;
        this.hash = new BytesRefHash(pool, 16, new BytesRefHash.DirectBytesStartArray(16, iwBytesUsed));
        this.pending = PackedLongValues.deltaPackedBuilder(0.0f);
        this.docsWithField = new DocsWithFieldSet();
        this.bytesUsed = this.pending.ramBytesUsed() + this.docsWithField.ramBytesUsed();
        iwBytesUsed.addAndGet(this.bytesUsed);
    }

    public void addValue(int docID, BytesRef value) {
        if (docID <= this.lastDocID) {
            throw new IllegalArgumentException("DocValuesField \"" + this.fieldInfo.name + "\" appears more than once in this document (only one value is allowed per field)");
        }
        if (value == null) {
            throw new IllegalArgumentException("field \"" + this.fieldInfo.name + "\": null value not allowed");
        }
        if (value.length > 32766) {
            throw new IllegalArgumentException("DocValuesField \"" + this.fieldInfo.name + "\" is too large, must be <= 32766");
        }
        this.addOneValue(value);
        this.docsWithField.add(docID);
        this.lastDocID = docID;
    }

    private void addOneValue(BytesRef value) {
        int termID = this.hash.add(value);
        if (termID < 0) {
            termID = -termID - 1;
        } else {
            this.iwBytesUsed.addAndGet(8L);
        }
        this.pending.add(termID);
        this.updateBytesUsed();
    }

    private void updateBytesUsed() {
        long newBytesUsed = this.pending.ramBytesUsed() + this.docsWithField.ramBytesUsed();
        this.iwBytesUsed.addAndGet(newBytesUsed - this.bytesUsed);
        this.bytesUsed = newBytesUsed;
    }

    private void finish() {
        if (this.finalSortedValues == null) {
            int valueCount = this.hash.size();
            this.updateBytesUsed();
            assert (this.finalOrdMap == null && this.finalOrds == null);
            this.finalSortedValues = this.hash.sort();
            this.finalOrds = this.pending.build();
            this.finalOrdMap = new int[valueCount];
            for (int ord = 0; ord < valueCount; ++ord) {
                this.finalOrdMap[this.finalSortedValues[ord]] = ord;
            }
        }
    }

    @Override
    SortedDocValues getDocValues() {
        this.finish();
        return new BufferedSortedDocValues(this.hash, this.finalOrds, this.finalSortedValues, this.finalOrdMap, this.docsWithField.iterator());
    }

    private static int[] sortDocValues(int maxDoc, Sorter.DocMap sortMap, SortedDocValues oldValues) throws IOException {
        int docID;
        int[] ords = new int[maxDoc];
        Arrays.fill(ords, -1);
        while ((docID = oldValues.nextDoc()) != Integer.MAX_VALUE) {
            int newDocID = sortMap.oldToNew(docID);
            ords[newDocID] = oldValues.ordValue();
        }
        return ords;
    }

    @Override
    public void flush(SegmentWriteState state, Sorter.DocMap sortMap, DocValuesConsumer dvConsumer) throws IOException {
        this.finish();
        dvConsumer.addSortedField(this.fieldInfo, SortedDocValuesWriter.getDocValuesProducer(this.fieldInfo, this.hash, this.finalOrds, this.finalSortedValues, this.finalOrdMap, this.docsWithField, sortMap));
    }

    static DocValuesProducer getDocValuesProducer(final FieldInfo writerFieldInfo, final BytesRefHash hash, final PackedLongValues ords, final int[] sortedValues, final int[] ordMap, final DocsWithFieldSet docsWithField, Sorter.DocMap sortMap) throws IOException {
        final int[] sorted = sortMap != null ? SortedDocValuesWriter.sortDocValues(sortMap.size(), sortMap, new BufferedSortedDocValues(hash, ords, sortedValues, ordMap, docsWithField.iterator())) : null;
        return new EmptyDocValuesProducer(){

            @Override
            public SortedDocValues getSorted(FieldInfo fieldInfoIn) {
                if (fieldInfoIn != writerFieldInfo) {
                    throw new IllegalArgumentException("wrong fieldInfo");
                }
                BufferedSortedDocValues buf = new BufferedSortedDocValues(hash, ords, sortedValues, ordMap, docsWithField.iterator());
                if (sorted == null) {
                    return buf;
                }
                return new SortingSortedDocValues(buf, sorted);
            }
        };
    }

    static class BufferedSortedDocValues
    extends SortedDocValues {
        final BytesRefHash hash;
        final BytesRef scratch = new BytesRef();
        final int[] sortedValues;
        final int[] ordMap;
        private int ord;
        final PackedLongValues.Iterator iter;
        final DocIdSetIterator docsWithField;

        public BufferedSortedDocValues(BytesRefHash hash, PackedLongValues docToOrd, int[] sortedValues, int[] ordMap, DocIdSetIterator docsWithField) {
            this.hash = hash;
            this.sortedValues = sortedValues;
            this.iter = docToOrd.iterator();
            this.ordMap = ordMap;
            this.docsWithField = docsWithField;
        }

        @Override
        public int docID() {
            return this.docsWithField.docID();
        }

        @Override
        public int nextDoc() throws IOException {
            int docID = this.docsWithField.nextDoc();
            if (docID != Integer.MAX_VALUE) {
                this.ord = Math.toIntExact(this.iter.next());
                this.ord = this.ordMap[this.ord];
            }
            return docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long cost() {
            return this.docsWithField.cost();
        }

        @Override
        public int ordValue() {
            return this.ord;
        }

        @Override
        public BytesRef lookupOrd(int ord) {
            assert (ord >= 0 && ord < this.sortedValues.length);
            assert (this.sortedValues[ord] >= 0 && this.sortedValues[ord] < this.sortedValues.length);
            this.hash.get(this.sortedValues[ord], this.scratch);
            return this.scratch;
        }

        @Override
        public int getValueCount() {
            return this.hash.size();
        }
    }

    static class SortingSortedDocValues
    extends SortedDocValues {
        private final SortedDocValues in;
        private final int[] ords;
        private int docID = -1;

        SortingSortedDocValues(SortedDocValues in, int[] ords) {
            this.in = in;
            this.ords = ords;
            assert (ords != null);
        }

        @Override
        public int docID() {
            return this.docID;
        }

        @Override
        public int nextDoc() {
            do {
                ++this.docID;
                if (this.docID != this.ords.length) continue;
                this.docID = Integer.MAX_VALUE;
                break;
            } while (this.ords[this.docID] == -1);
            return this.docID;
        }

        @Override
        public int advance(int target) {
            throw new UnsupportedOperationException("use nextDoc instead");
        }

        @Override
        public boolean advanceExact(int target) throws IOException {
            this.docID = target;
            return this.ords[target] != -1;
        }

        @Override
        public int ordValue() {
            return this.ords[this.docID];
        }

        @Override
        public long cost() {
            return this.in.cost();
        }

        @Override
        public BytesRef lookupOrd(int ord) throws IOException {
            return this.in.lookupOrd(ord);
        }

        @Override
        public int getValueCount() {
            return this.in.getValueCount();
        }
    }
}

