/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbchunks;

import com.mojang.logging.LogUtils;
import dev.ftb.mods.ftbchunks.client.gui.EntityIconSettingsScreen;
import dev.ftb.mods.ftblibrary.config.ConfigCallback;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.snbt.SNBTCompoundTag;
import dev.ftb.mods.ftblibrary.snbt.config.BaseValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class EntityTypeBoolMapValue
extends BaseValue<Map<ResourceKey<EntityType<?>>, Boolean>> {
    private static final Logger LOGGER = LogUtils.getLogger();

    public EntityTypeBoolMapValue(@Nullable SNBTConfig c, String n, Map<ResourceKey<EntityType<?>>, Boolean> def) {
        super(c, n, def);
        super.set(new HashMap(def));
    }

    public void write(SNBTCompoundTag tag) {
        Map map = (Map)this.get();
        SNBTCompoundTag mapTag = new SNBTCompoundTag();
        for (Map.Entry entry : map.entrySet()) {
            mapTag.putBoolean(((ResourceKey)entry.getKey()).location().toString(), ((Boolean)entry.getValue()).booleanValue());
        }
        tag.put(this.key, (Tag)mapTag);
    }

    public void read(SNBTCompoundTag tag) {
        HashMap<ResourceKey, Boolean> map = new HashMap<ResourceKey, Boolean>();
        SNBTCompoundTag compound = tag.getCompound(this.key);
        for (String key : compound.getAllKeys()) {
            try {
                ResourceLocation parse = ResourceLocation.parse((String)key);
                map.put(ResourceKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)parse), compound.getBoolean(key));
            }
            catch (ResourceLocationException e) {
                LOGGER.error("Failed to parse {} skipping", (Object)key, (Object)e);
            }
        }
        this.set(map);
    }

    public void createClientConfig(ConfigGroup group) {
        group.add(this.key, (ConfigValue)new EntityTypeBoolMapConfigValue(), (Object)((Map)this.get()), stringBooleanMap -> {}, (Object)((Map)this.defaultValue));
    }

    public static class EntityTypeBoolMapConfigValue
    extends ConfigValue<Map<ResourceKey<EntityType<?>>, Boolean>> {
        public void onClicked(Widget clickedWidget, MouseButton button, ConfigCallback callback) {
            new EntityIconSettingsScreen(false).openGui();
        }

        public Component getStringForGUI(@Nullable Map<ResourceKey<EntityType<?>>, Boolean> v) {
            if (v == null) {
                return super.getStringForGUI(null);
            }
            int enabled = 0;
            int disabled = 0;
            for (ResourceKey<EntityType<?>> entityTypeResourceKey : v.keySet()) {
                EntityType entityType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(entityTypeResourceKey);
                if (entityType == null) continue;
                if (v.get(entityTypeResourceKey).booleanValue()) {
                    ++enabled;
                    continue;
                }
                ++disabled;
            }
            return Component.translatable((String)"ftbchunks.gui.enabled_disabled_count", (Object[])new Object[]{enabled, disabled});
        }
    }
}

