/*
 * Decompiled with CFR 0.152.
 */
package ianm1647.expandeddelight.integration.jei;

import com.google.common.collect.ImmutableList;
import ianm1647.expandeddelight.client.gui.JuicerScreen;
import ianm1647.expandeddelight.common.block.entity.container.JuicerMenu;
import ianm1647.expandeddelight.common.registry.EDItems;
import ianm1647.expandeddelight.common.registry.EDMenuTypes;
import ianm1647.expandeddelight.integration.jei.JEIRecipeTypes;
import ianm1647.expandeddelight.integration.jei.JEIRecipes;
import ianm1647.expandeddelight.integration.jei.category.CheeseFermentingRecipeCategory;
import ianm1647.expandeddelight.integration.jei.category.JuicingRecipeCategory;
import ianm1647.expandeddelight.integration.jei.resource.CheeseFermentingDummy;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import mezz.jei.api.registration.IRecipeTransferRegistration;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    private static final ResourceLocation ID = ResourceLocation.fromNamespaceAndPath((String)"expandeddelight", (String)"jei_plugin");

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new JuicingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CheeseFermentingRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        JEIRecipes modRecipes = new JEIRecipes();
        registration.addRecipes(JEIRecipeTypes.JUICING, modRecipes.getJuicerRecipes());
        registration.addRecipes(JEIRecipeTypes.CHEESE_FERMENTING, (List)ImmutableList.of((Object)new CheeseFermentingDummy()));
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)EDItems.WILD_ASPARAGUS.get()), new ItemStack((ItemLike)EDItems.ASPARAGUS.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"expandeddelight.jei.info.wild_asparagus")});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)EDItems.WILD_SWEET_POTATO.get()), new ItemStack((ItemLike)EDItems.SWEET_POTATO.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"expandeddelight.jei.info.wild_sweet_potato")});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)EDItems.WILD_CHILI_PEPPER.get()), new ItemStack((ItemLike)EDItems.CHILI_PEPPER.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"expandeddelight.jei.info.wild_chili_pepper")});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)EDItems.WILD_PEANUTS.get()), new ItemStack((ItemLike)EDItems.PEANUT.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"expandeddelight.jei.info.wild_peanuts")});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)EDItems.CRANBERRIES.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"expandeddelight.jei.info.cranberries")});
        registration.addIngredientInfo(List.of(new ItemStack((ItemLike)EDItems.SALT_ORE.get()), new ItemStack((ItemLike)EDItems.DEEPSLATE_SALT_ORE.get())), (IIngredientType)VanillaTypes.ITEM_STACK, new Component[]{Component.translatable((String)"expandeddelight.jei.info.salt_ore")});
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)EDItems.JUICER.get()), new RecipeType[]{JEIRecipeTypes.JUICING});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)EDItems.CASK.get()), new RecipeType[]{JEIRecipeTypes.CHEESE_FERMENTING});
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        registration.addRecipeClickArea(JuicerScreen.class, 71, 25, 30, 17, new RecipeType[]{JEIRecipeTypes.JUICING});
    }

    public void registerRecipeTransferHandlers(IRecipeTransferRegistration registration) {
        registration.addRecipeTransferHandler(JuicerMenu.class, EDMenuTypes.JUICER.get(), JEIRecipeTypes.JUICING, 0, 2, 5, 36);
    }

    public ResourceLocation getPluginUid() {
        return ID;
    }
}

