/*
 * Decompiled with CFR 0.152.
 */
package com.teamremastered.endrem.block;

import com.google.common.base.Predicates;
import com.teamremastered.endrem.block.AncientPortalFrameEntity;
import com.teamremastered.endrem.item.EREnderEye;
import com.teamremastered.endrem.registry.CommonBlockRegistry;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class AncientPortalFrame
extends Block
implements EntityBlock {
    public static final BooleanProperty HAS_EYE = BlockStateProperties.EYE;
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    protected static final VoxelShape BASE_SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)13.0, (double)16.0);
    protected static final VoxelShape EYE_SHAPE = Block.box((double)4.0, (double)13.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    protected static final VoxelShape FULL_SHAPE = Shapes.or((VoxelShape)BASE_SHAPE, (VoxelShape)EYE_SHAPE);

    public static BlockPattern getCompletedPortalShape(boolean isCompleted) {
        com.google.common.base.Predicate hasEyePredicate = property -> property.equals(true) || !isCompleted;
        return BlockPatternBuilder.start().aisle(new String[]{"?vvv?", ">???<", ">???<", ">???<", "?^^^?"}).where('?', BlockInWorld.hasState((Predicate)BlockStatePredicate.ANY)).where('^', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)CommonBlockRegistry.ANCIENT_PORTAL_FRAME).where((Property)HAS_EYE, (Predicate)hasEyePredicate).where((Property)FACING, (Predicate)Predicates.equalTo((Object)Direction.SOUTH)).or((Predicate)BlockStatePredicate.forBlock((Block)Blocks.END_PORTAL_FRAME).where((Property)HAS_EYE, (Predicate)hasEyePredicate).where((Property)FACING, (Predicate)Predicates.equalTo((Object)Direction.SOUTH))))).where('>', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)CommonBlockRegistry.ANCIENT_PORTAL_FRAME).where((Property)HAS_EYE, (Predicate)hasEyePredicate).where((Property)FACING, (Predicate)Predicates.equalTo((Object)Direction.WEST)).or((Predicate)BlockStatePredicate.forBlock((Block)Blocks.END_PORTAL_FRAME).where((Property)HAS_EYE, (Predicate)hasEyePredicate).where((Property)FACING, (Predicate)Predicates.equalTo((Object)Direction.WEST))))).where('v', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)CommonBlockRegistry.ANCIENT_PORTAL_FRAME).where((Property)HAS_EYE, (Predicate)hasEyePredicate).where((Property)FACING, (Predicate)Predicates.equalTo((Object)Direction.NORTH)).or((Predicate)BlockStatePredicate.forBlock((Block)Blocks.END_PORTAL_FRAME).where((Property)HAS_EYE, (Predicate)hasEyePredicate).where((Property)FACING, (Predicate)Predicates.equalTo((Object)Direction.NORTH))))).where('<', BlockInWorld.hasState((Predicate)BlockStatePredicate.forBlock((Block)CommonBlockRegistry.ANCIENT_PORTAL_FRAME).where((Property)HAS_EYE, (Predicate)hasEyePredicate).where((Property)FACING, (Predicate)Predicates.equalTo((Object)Direction.EAST)).or((Predicate)BlockStatePredicate.forBlock((Block)Blocks.END_PORTAL_FRAME).where((Property)HAS_EYE, (Predicate)hasEyePredicate).where((Property)FACING, (Predicate)Predicates.equalTo((Object)Direction.EAST))))).build();
    }

    public AncientPortalFrame() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_GREEN).instrument(NoteBlockInstrument.BASEDRUM).sound(SoundType.GLASS).lightLevel(p_152690_ -> 1).strength(-1.0f, 3600000.0f).noLootTable());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)HAS_EYE, (Comparable)Boolean.FALSE));
    }

    public VoxelShape getShape(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext context) {
        return (Boolean)state.getValue((Property)HAS_EYE) != false ? FULL_SHAPE : BASE_SHAPE;
    }

    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext useContext) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)useContext.getHorizontalDirection().getOpposite())).setValue((Property)HAS_EYE, (Comparable)Boolean.FALSE);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateBuilder) {
        stateBuilder.add(new Property[]{HAS_EYE}).add(new Property[]{FACING});
    }

    public static boolean isFrameAbsent(Level levelIn, UseOnContext itemUse, BlockPos pos) {
        BlockPattern.BlockPatternMatch blockpattern$patternhelper = AncientPortalFrame.getCompletedPortalShape(false).find((LevelReader)levelIn, pos);
        BlockPos frontTopLeft = blockpattern$patternhelper.getFrontTopLeft().offset(-4, 0, -4);
        for (int i = 0; i < 5; ++i) {
            for (int j = 0; j < 5; ++j) {
                AncientPortalFrameEntity ancientPortalFrameEntity;
                BlockPos blockPos = frontTopLeft.offset(i, 0, j);
                BlockEntity blockEntity = levelIn.getBlockEntity(blockPos);
                if (!(blockEntity instanceof AncientPortalFrameEntity) || (ancientPortalFrameEntity = (AncientPortalFrameEntity)blockEntity).isEmpty() || !ancientPortalFrameEntity.getEyeItem().equals(itemUse.getItemInHand().getItem())) continue;
                return false;
            }
        }
        return true;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        AncientPortalFrameEntity ancientPortalFrameEntity = new AncientPortalFrameEntity(blockPos, blockState);
        ancientPortalFrameEntity.setEye(EREnderEye.eyePlaced);
        return ancientPortalFrameEntity;
    }
}

