/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.items;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import lekavar.lma.drinkbeer.effects.DrunkStatusEffect;
import lekavar.lma.drinkbeer.effects.NightHowlStatusEffect;
import lekavar.lma.drinkbeer.items.BeerBlockItem;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class BeerMugItem
extends BeerBlockItem {
    private static final double MAX_PLACE_DISTANCE = 2.0;
    private final boolean hasExtraTooltip;

    public BeerMugItem(Block block, int nutrition, boolean hasExtraTooltip) {
        super(block, new Item.Properties().stacksTo(16).food(new FoodProperties.Builder().nutrition(nutrition).alwaysEdible().build()));
        this.hasExtraTooltip = hasExtraTooltip;
    }

    public BeerMugItem(Block block, @Nullable MobEffectInstance statusEffectInstance, int nutrition, boolean hasExtraTooltip) {
        super(block, new Item.Properties().stacksTo(16).food(statusEffectInstance != null ? new FoodProperties.Builder().nutrition(nutrition).effect(statusEffectInstance, 1.0f).alwaysEdible().build() : new FoodProperties.Builder().nutrition(nutrition).alwaysEdible().build()));
        this.hasExtraTooltip = hasExtraTooltip;
    }

    public BeerMugItem(Block block, Supplier<MobEffectInstance> statusEffectInstance, int nutrition, boolean hasExtraTooltip) {
        super(block, new Item.Properties().stacksTo(16).food(statusEffectInstance != null ? new FoodProperties.Builder().nutrition(nutrition).effect(statusEffectInstance, 1.0f).alwaysEdible().build() : new FoodProperties.Builder().nutrition(nutrition).alwaysEdible().build()));
        this.hasExtraTooltip = hasExtraTooltip;
    }

    protected boolean canPlace(BlockPlaceContext context, BlockState state) {
        if (context.getClickLocation().distanceTo(context.getPlayer().position()) > 2.0) {
            return false;
        }
        return super.canPlace(context, state);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        String name = BuiltInRegistries.ITEM.getKey((Object)stack.getItem()).getPath();
        if (this.hasEffectNoticeTooltip()) {
            tooltipComponents.add((Component)Component.translatable((String)("item.drinkbeer." + name + ".tooltip")).setStyle(Style.EMPTY.applyFormat(ChatFormatting.BLUE)));
        }
        String hunger = String.valueOf(stack.getItem().getFoodProperties(stack, null).nutrition());
        tooltipComponents.add((Component)Component.translatable((String)"drinkbeer.restores_hunger").setStyle(Style.EMPTY.applyFormat(ChatFormatting.BLUE)).append(hunger));
    }

    private boolean hasEffectNoticeTooltip() {
        return this.hasExtraTooltip;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity user) {
        DrunkStatusEffect.addStatusEffect(user);
        NightHowlStatusEffect.addStatusEffect(stack, world, user);
        this.giveEmptyMugBack(user);
        return super.finishUsingItem(stack, world, user);
    }
}

