/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import lekavar.lma.drinkbeer.blocks.TradeboxBlock;
import lekavar.lma.drinkbeer.gui.TradeBoxMenu;
import lekavar.lma.drinkbeer.managers.TradeBoxManager;
import lekavar.lma.drinkbeer.networking.NetWorking;
import lekavar.lma.drinkbeer.utils.Convert;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.WidgetSprites;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class TradeBoxScreen
extends AbstractContainerScreen<TradeBoxMenu> {
    private static final ResourceLocation TRADE_BOX_GUI = ResourceLocation.fromNamespaceAndPath((String)"drinkbeer", (String)"textures/gui/container/trade_box.png");
    private static final ResourceLocation REFRESH_WIDGET = ResourceLocation.fromNamespaceAndPath((String)"drinkbeer", (String)"container/reroll");
    private static final ResourceLocation REFRESH_WIDGET_BLUE = ResourceLocation.fromNamespaceAndPath((String)"drinkbeer", (String)"container/reroll_blue");
    private static final WidgetSprites REFRESH_WIDGET_SPRITE = new WidgetSprites(REFRESH_WIDGET, REFRESH_WIDGET_BLUE);
    private final int textureWidth = 176;
    private final int textureHeight = 166;
    TradeBoxMenu container;

    public TradeBoxScreen(TradeBoxMenu screenContainer, Inventory inv, Component title) {
        super((AbstractContainerMenu)screenContainer, inv, title);
        this.imageWidth = 176;
        this.imageHeight = 166;
        this.container = screenContainer;
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TRADE_BOX_GUI);
        int backgroundWidth = this.getXSize();
        int backgroundHeight = this.getYSize();
        int x = (this.width - backgroundWidth) / 2;
        int y = (this.height - backgroundHeight) / 2;
        guiGraphics.blit(TRADE_BOX_GUI, x, y, 0, 0, backgroundWidth, backgroundHeight);
        if (this.container.isCooling()) {
            guiGraphics.blit(TRADE_BOX_GUI, x + 84, y + 25, 178, 38, 72, 36);
            String timeStr = Convert.tickToTime(this.container.getCoolingTime());
            guiGraphics.drawString(this.font, timeStr, x + 114, y + 39, new Color(64, 64, 64, 255).getRGB());
        } else if (this.container.isTrading()) {
            if (this.isHovering(157, 6, 13, 13, mouseX, mouseY)) {
                guiGraphics.blit(TRADE_BOX_GUI, x + 155, y + 4, 178, 19, 16, 16);
            } else {
                guiGraphics.blit(TRADE_BOX_GUI, x + 155, y + 4, 178, 0, 16, 16);
            }
        }
        if (!this.container.isCooling()) {
            Language language = Language.getInstance();
            String youStr = language.getOrDefault("drinkbeer.resident.you");
            guiGraphics.drawString(this.font, youStr, x + 85, y + 16, new Color(64, 64, 64, 255).getRGB());
            String locationAndResidentStr = language.getOrDefault(TradeBoxManager.getLocationTranslationKey(this.container.getLocationId())) + "-" + language.getOrDefault(TradeBoxManager.getResidentTranslationKey(this.container.getResidentId()));
            guiGraphics.drawString(this.font, locationAndResidentStr, x + 85, y + 63, new Color(64, 64, 64, 255).getRGB());
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    protected boolean isHovering(int xPosition, int yPosition, int width, int height, double pointX, double pointY) {
        return super.isHovering(xPosition, yPosition, width, height, pointX, pointY);
    }

    protected void init() {
        int x = (this.width - this.getXSize()) / 2;
        int y = (this.height - this.getYSize()) / 2;
        this.addRenderableWidget((GuiEventListener)new ImageButton(x + 156, y + 5, 16, 16, REFRESH_WIDGET_SPRITE, buttonWidget -> {
            BlockPos pos;
            if (this.container.isTrading() && (pos = this.getHitTradeBoxBlockPos()) != null) {
                NetWorking.sendRefreshTradebox(pos);
            }
        }));
        super.init();
    }

    private BlockPos getHitTradeBoxBlockPos() {
        BlockHitResult blockHit;
        BlockPos blockPos;
        BlockState blockState;
        Block block;
        Minecraft client = Minecraft.getInstance();
        HitResult hit = client.hitResult;
        if (hit.getType().equals((Object)HitResult.Type.BLOCK) && (block = (blockState = client.level.getBlockState(blockPos = (blockHit = (BlockHitResult)hit).getBlockPos())).getBlock()) instanceof TradeboxBlock) {
            return blockPos;
        }
        return null;
    }
}

