/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.effects;

import java.awt.Color;
import lekavar.lma.drinkbeer.registries.MobEffectRegistry;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;

public class DrunkStatusEffect
extends MobEffect {
    public static final int MAX_DRUNK_AMPLIFIER = 4;
    public static final int MIN_DRUNK_AMPLIFIER = 0;
    private static final int BASE_DURATION = 1200;
    private static final boolean visible = false;
    private static final int[] drunkDurations = new int[]{3600, 3000, 2400, 1800, 1200};
    private static final int[] nauseaDurations = new int[]{160, 160, 200, 300, 600};
    private static final int[] slownessDurations = new int[]{0, 80, 160, 200, 600};
    private static final int[] harmulStatusEffectsIntervals = new int[]{200, 160, 200, 300, 20};

    public DrunkStatusEffect() {
        super(MobEffectCategory.HARMFUL, new Color(255, 222, 173, 255).getRGB());
    }

    public static void addStatusEffect(LivingEntity user, int value) {
        if (value == 0) {
            return;
        }
        MobEffectInstance statusEffectInstance = user.getEffect(MobEffectRegistry.DRUNK);
        int currentDrunkAmplifier = statusEffectInstance == null ? -1 : statusEffectInstance.getAmplifier();
        int newDrunkAmplifier = currentDrunkAmplifier + value;
        newDrunkAmplifier = Math.min(newDrunkAmplifier, 4);
        if (currentDrunkAmplifier < 0 && newDrunkAmplifier < 0) {
            return;
        }
        if (currentDrunkAmplifier >= 0 && newDrunkAmplifier < 0) {
            user.removeEffect(MobEffectRegistry.DRUNK);
        } else if (currentDrunkAmplifier < 0) {
            user.addEffect(new MobEffectInstance(MobEffectRegistry.DRUNK, DrunkStatusEffect.getDrunkDuratioin(newDrunkAmplifier), newDrunkAmplifier));
        } else if (newDrunkAmplifier > currentDrunkAmplifier) {
            user.addEffect(new MobEffectInstance(MobEffectRegistry.DRUNK, DrunkStatusEffect.getDrunkDuratioin(newDrunkAmplifier), newDrunkAmplifier));
        } else if (newDrunkAmplifier < currentDrunkAmplifier) {
            for (int tempDrunkAmplifier = currentDrunkAmplifier - newDrunkAmplifier; tempDrunkAmplifier > 0; --tempDrunkAmplifier) {
                DrunkStatusEffect.decreaseDrunkStatusEffefct(user, currentDrunkAmplifier);
                --currentDrunkAmplifier;
            }
        }
    }

    public static void addStatusEffect(LivingEntity user) {
        DrunkStatusEffect.addStatusEffect(user, 1);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        int time = entity.getEffect(MobEffectRegistry.DRUNK).getDuration();
        this.giveHarmfulStatusEffects(entity, amplifier, time);
        if (time == 1) {
            DrunkStatusEffect.decreaseDrunkStatusEffefct(entity, amplifier);
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return true;
    }

    private void giveHarmfulStatusEffects(LivingEntity entity, int amplifier, int time) {
        if (amplifier >= 4) {
            int duration = entity.getEffect(MobEffectRegistry.DRUNK).getDuration();
            entity.addEffect(new MobEffectInstance(MobEffects.CONFUSION, duration, 0, false, false));
            entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, duration, 3, false, false));
        } else if (time % harmulStatusEffectsIntervals[amplifier] == 0) {
            int nauseaDuration = nauseaDurations[amplifier];
            int slownessDuration = slownessDurations[amplifier];
            entity.addEffect(new MobEffectInstance(MobEffects.CONFUSION, nauseaDuration, 0, false, false));
            if (amplifier > 0) {
                entity.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, slownessDuration, amplifier - 1, false, false));
            }
        }
    }

    private static void decreaseDrunkStatusEffefct(LivingEntity entity, int amplifier) {
        if (!entity.level().isClientSide()) {
            entity.removeEffect(MobEffectRegistry.DRUNK);
            MobEffectInstance nextDrunkStatusEffect = DrunkStatusEffect.getDecreasedDrunkStatusEffect(amplifier);
            if (nextDrunkStatusEffect != null) {
                entity.addEffect(nextDrunkStatusEffect);
            }
        }
    }

    private static MobEffectInstance getDecreasedDrunkStatusEffect(int currentAmplifier) {
        int nextDrunkAmplifier = currentAmplifier - 1;
        if (nextDrunkAmplifier < 0) {
            return null;
        }
        return new MobEffectInstance(MobEffectRegistry.DRUNK, DrunkStatusEffect.getDrunkDuratioin(nextDrunkAmplifier), nextDrunkAmplifier);
    }

    public static int getNextDrunkAmplifier(LivingEntity user) {
        MobEffectInstance statusEffectInstance = user.getEffect(MobEffectRegistry.DRUNK);
        int drunkAmplifier = statusEffectInstance == null ? -1 : statusEffectInstance.getAmplifier();
        return drunkAmplifier < 4 ? drunkAmplifier + 1 : drunkAmplifier;
    }

    public static int getDrunkDuratioin(int amplifier) {
        try {
            return drunkDurations[amplifier];
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            System.out.println("Amplifier is out of range");
            return 1200;
        }
    }
}

