/*
 * Decompiled with CFR 0.152.
 */
package lekavar.lma.drinkbeer.blockentities;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import lekavar.lma.drinkbeer.gui.TradeBoxMenu;
import lekavar.lma.drinkbeer.registries.BlockEntityRegistry;
import lekavar.lma.drinkbeer.utils.tradebox.Locations;
import lekavar.lma.drinkbeer.utils.tradebox.Residents;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class TradeBoxBlockEntity
extends BlockEntity
implements MenuProvider {
    public SimpleContainer goodInventory = new SimpleContainer(8);
    private int coolingTime;
    private int locationId;
    private int residentId;
    private int process;
    public TradeBoxMenu screenHandler;
    public static final int PROCESS_COOLING = 0;
    public static final int PROCESS_TRADING = 1;
    public final ContainerData syncData = new ContainerData(){

        public int get(int index) {
            switch (index) {
                case 0: {
                    return TradeBoxBlockEntity.this.coolingTime;
                }
                case 1: {
                    return TradeBoxBlockEntity.this.locationId;
                }
                case 2: {
                    return TradeBoxBlockEntity.this.residentId;
                }
                case 3: {
                    return TradeBoxBlockEntity.this.process;
                }
            }
            return 0;
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    TradeBoxBlockEntity.this.coolingTime = value;
                    break;
                }
                case 1: {
                    TradeBoxBlockEntity.this.locationId = value;
                    break;
                }
                case 2: {
                    TradeBoxBlockEntity.this.residentId = value;
                    break;
                }
                case 3: {
                    TradeBoxBlockEntity.this.process = value;
                }
            }
            TradeBoxBlockEntity.this.setChanged();
        }

        public int getCount() {
            return 4;
        }
    };

    public TradeBoxBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.TRADE_BOX_TILEENTITY.get(), pos, state);
    }

    public TradeBoxBlockEntity(int coolingTime, BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.TRADE_BOX_TILEENTITY.get(), pos, state);
        this.coolingTime = 6000;
        this.locationId = Locations.EMPTY_LOCATION.getId();
        this.residentId = Residents.EMPTY_RESIDENT.getId();
        this.process = 0;
        this.syncData.set(0, coolingTime);
        this.syncData.set(1, this.locationId);
        this.syncData.set(2, this.residentId);
        this.syncData.set(3, this.process);
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"block.drinkbeer.trade_box_normal");
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, @NotNull Inventory inventory, @NotNull Player player) {
        this.screenHandler = new TradeBoxMenu(id, (Container)this.goodInventory, this.syncData, inventory, this);
        return this.screenHandler;
    }

    public void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        ContainerHelper.saveAllItems((CompoundTag)tag, (NonNullList)this.goodInventory.getItems(), (HolderLookup.Provider)registries);
        tag.putShort("CoolingTime", (short)this.coolingTime);
        tag.putShort("LocationId", (short)this.locationId);
        tag.putShort("ResidentId", (short)this.residentId);
        tag.putShort("Process", (short)this.process);
    }

    public void loadAdditional(@Nonnull CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)this.goodInventory.getItems(), (HolderLookup.Provider)registries);
        this.coolingTime = tag.getShort("CoolingTime");
        this.locationId = tag.getShort("LocationId");
        this.residentId = tag.getShort("ResidentId");
        this.process = tag.getShort("Process");
    }

    public static void tick(Level world, BlockPos pos, BlockState state, TradeBoxBlockEntity tradeboxEntity) {
        if (!world.isClientSide()) {
            int n = tradeboxEntity.coolingTime = tradeboxEntity.coolingTime > 0 ? (tradeboxEntity.coolingTime = tradeboxEntity.coolingTime - 1) : 0;
            if (tradeboxEntity.coolingTime == 0 && tradeboxEntity.syncData.get(3) == 0 && tradeboxEntity.screenHandler != null) {
                tradeboxEntity.screenHandler.setTradeboxTrading();
            }
        }
    }
}

