/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.item;

import com.ldtteam.domumornamentum.DomumOrnamentum;
import com.ldtteam.domumornamentum.client.model.data.MaterialTextureData;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class SelfUpgradingBlockItem
extends BlockItem {
    public SelfUpgradingBlockItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public void verifyComponentsAfterLoad(ItemStack itemStack) {
        super.verifyComponentsAfterLoad(itemStack);
        SelfUpgradingBlockItem.upgrade(itemStack);
    }

    static void upgrade(ItemStack itemStack) {
        @Nullable MinecraftServer currentServer = ServerLifecycleHooks.getCurrentServer();
        if (currentServer == null) {
            return;
        }
        RegistryOps dynamicops = currentServer.registryAccess().createSerializationContext((DynamicOps)NbtOps.INSTANCE);
        CustomData.update((DataComponentType)DataComponents.CUSTOM_DATA, (ItemStack)itemStack, arg_0 -> SelfUpgradingBlockItem.lambda$upgrade$1(itemStack, (DynamicOps)dynamicops, arg_0));
        CompoundTag tag = ((CustomData)itemStack.getOrDefault(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.EMPTY)).getUnsafe().getCompound("textureData");
        if (!tag.isEmpty()) {
            SelfUpgradingBlockItem.saveTextureDataFromNbt(itemStack, (DynamicOps<Tag>)dynamicops, tag);
        }
    }

    private static void saveTextureDataFromNbt(ItemStack itemStack, DynamicOps<Tag> dynamicops, CompoundTag tag) {
        MaterialTextureData.CODEC.parse(dynamicops, (Object)tag).resultOrPartial(arg_0 -> ((Logger)DomumOrnamentum.LOGGER).error(arg_0)).orElse(MaterialTextureData.EMPTY).writeToItemStack(itemStack);
    }

    private static BlockItemStateProperties with(BlockItemStateProperties properties, String key, String value) {
        return new BlockItemStateProperties(Util.copyAndPut((Map)properties.properties(), (Object)key, (Object)value));
    }

    private static /* synthetic */ void lambda$upgrade$1(ItemStack itemStack, DynamicOps dynamicops, CompoundTag oldData) {
        if (oldData.contains("type", 8)) {
            itemStack.update(DataComponents.BLOCK_STATE, (Object)BlockItemStateProperties.EMPTY, props -> SelfUpgradingBlockItem.with(props, "type", oldData.getString("type")));
            oldData.remove("type");
        }
        if (oldData.contains("textureData", 10)) {
            SelfUpgradingBlockItem.saveTextureDataFromNbt(itemStack, (DynamicOps<Tag>)dynamicops, oldData.getCompound("textureData"));
            oldData.remove("textureData");
        }
    }
}

