/*
 * Decompiled with CFR 0.152.
 */
package com.ldtteam.domumornamentum.block;

import com.ldtteam.domumornamentum.block.interfaces.IDOBlock;
import com.ldtteam.domumornamentum.block.types.PostType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPostBlock<B extends AbstractPostBlock<B>>
extends DirectionalBlock
implements IDOBlock<B> {
    public static final EnumProperty<PostType> TYPE = EnumProperty.create((String)"type", PostType.class);
    public static final BooleanProperty UPRIGHT = BlockStateProperties.CONDITIONAL;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    protected static final VoxelShape Y_AXIS_AABB = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    protected static final VoxelShape Z_AXIS_AABB = Block.box((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0);
    protected static final VoxelShape X_AXIS_AABB = Block.box((double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    protected static final VoxelShape X_DOUBLE_AABB = Shapes.join((VoxelShape)Block.box((double)0.0, (double)6.75, (double)2.75, (double)16.0, (double)9.25, (double)5.25), (VoxelShape)Block.box((double)0.0, (double)6.75, (double)10.75, (double)16.0, (double)9.25, (double)13.25), (BooleanOp)BooleanOp.OR);
    protected static final VoxelShape Y_DOUBLE_AABB = Shapes.join((VoxelShape)Block.box((double)2.75, (double)0.0, (double)6.75, (double)5.25, (double)16.0, (double)9.25), (VoxelShape)Block.box((double)10.75, (double)0.0, (double)6.75, (double)13.25, (double)16.0, (double)9.25), (BooleanOp)BooleanOp.OR);
    protected static final VoxelShape Z_DOUBLE_AABB = Shapes.join((VoxelShape)Block.box((double)2.75, (double)6.75, (double)0.0, (double)5.25, (double)9.25, (double)16.0), (VoxelShape)Block.box((double)10.75, (double)6.75, (double)0.0, (double)13.25, (double)9.25, (double)16.0), (BooleanOp)BooleanOp.OR);
    protected static final VoxelShape XY_DOUBLE_AABB = Shapes.join((VoxelShape)Block.box((double)6.75, (double)0.0, (double)10.75, (double)9.25, (double)16.0, (double)13.25), (VoxelShape)Block.box((double)6.75, (double)0.0, (double)2.75, (double)9.25, (double)16.0, (double)5.25), (BooleanOp)BooleanOp.OR);
    protected static final VoxelShape X_QUAD_AABB = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.75, (double)0.75, (double)16.0, (double)3.25, (double)3.25), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)12.75, (double)0.75, (double)16.0, (double)15.25, (double)3.25), Block.box((double)0.0, (double)0.75, (double)12.75, (double)16.0, (double)3.25, (double)15.25), Block.box((double)0.0, (double)12.75, (double)12.75, (double)16.0, (double)15.25, (double)15.25)});
    protected static final VoxelShape Y_QUAD_AABB = Shapes.or((VoxelShape)Block.box((double)0.75, (double)0.0, (double)12.75, (double)3.25, (double)16.0, (double)15.25), (VoxelShape[])new VoxelShape[]{Block.box((double)0.75, (double)0.0, (double)0.75, (double)3.25, (double)16.0, (double)3.25), Block.box((double)12.75, (double)0.0, (double)12.75, (double)15.25, (double)16.0, (double)15.25), Block.box((double)12.75, (double)0.0, (double)0.75, (double)15.25, (double)16.0, (double)3.25)});
    protected static final VoxelShape Z_QUAD_AABB = Shapes.or((VoxelShape)Block.box((double)0.75, (double)0.75, (double)0.0, (double)3.25, (double)3.25, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.75, (double)12.75, (double)0.0, (double)3.25, (double)15.25, (double)16.0), Block.box((double)12.75, (double)0.75, (double)0.0, (double)15.25, (double)3.25, (double)16.0), Block.box((double)12.75, (double)12.75, (double)0.0, (double)15.25, (double)15.25, (double)16.0)});

    public AbstractPostBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.FALSE)).setValue((Property)UPRIGHT, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    public ResourceLocation getRegistryName() {
        return this.getRegistryName((Block)this);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        if (state.getValue(TYPE) == PostType.DOUBLE) {
            switch ((Direction)state.getValue((Property)FACING)) {
                case NORTH: {
                    if (((Boolean)state.getValue((Property)UPRIGHT)).booleanValue()) {
                        return Y_DOUBLE_AABB;
                    }
                    return Z_DOUBLE_AABB;
                }
                case SOUTH: {
                    if (((Boolean)state.getValue((Property)UPRIGHT)).booleanValue()) {
                        return Y_DOUBLE_AABB;
                    }
                    return Z_DOUBLE_AABB;
                }
                case EAST: {
                    if (((Boolean)state.getValue((Property)UPRIGHT)).booleanValue()) {
                        return XY_DOUBLE_AABB;
                    }
                    return X_DOUBLE_AABB;
                }
                case WEST: {
                    if (((Boolean)state.getValue((Property)UPRIGHT)).booleanValue()) {
                        return XY_DOUBLE_AABB;
                    }
                    return X_DOUBLE_AABB;
                }
                case UP: {
                    return Y_DOUBLE_AABB;
                }
                case DOWN: {
                    return Y_DOUBLE_AABB;
                }
            }
        }
        if (state.getValue(TYPE) == PostType.QUAD) {
            switch ((Direction)state.getValue((Property)FACING)) {
                case NORTH: {
                    if (((Boolean)state.getValue((Property)UPRIGHT)).booleanValue()) {
                        return Y_QUAD_AABB;
                    }
                    return Z_QUAD_AABB;
                }
                case SOUTH: {
                    if (((Boolean)state.getValue((Property)UPRIGHT)).booleanValue()) {
                        return Y_QUAD_AABB;
                    }
                    return Z_QUAD_AABB;
                }
                case EAST: {
                    if (((Boolean)state.getValue((Property)UPRIGHT)).booleanValue()) {
                        return Y_QUAD_AABB;
                    }
                    return X_QUAD_AABB;
                }
                case WEST: {
                    if (((Boolean)state.getValue((Property)UPRIGHT)).booleanValue()) {
                        return Y_QUAD_AABB;
                    }
                    return X_QUAD_AABB;
                }
                case UP: {
                    return Y_QUAD_AABB;
                }
                case DOWN: {
                    return Y_QUAD_AABB;
                }
            }
        }
        switch ((Direction)state.getValue((Property)FACING)) {
            case NORTH: {
                if (((Boolean)state.getValue((Property)UPRIGHT)).booleanValue()) {
                    return Y_AXIS_AABB;
                }
                return Z_AXIS_AABB;
            }
            case SOUTH: {
                if (((Boolean)state.getValue((Property)UPRIGHT)).booleanValue()) {
                    return Y_AXIS_AABB;
                }
                return Z_AXIS_AABB;
            }
            case EAST: {
                if (((Boolean)state.getValue((Property)UPRIGHT)).booleanValue()) {
                    return Y_AXIS_AABB;
                }
                return X_AXIS_AABB;
            }
            case WEST: {
                if (((Boolean)state.getValue((Property)UPRIGHT)).booleanValue()) {
                    return Y_AXIS_AABB;
                }
                return X_AXIS_AABB;
            }
            case UP: {
                return Y_AXIS_AABB;
            }
            case DOWN: {
                return Y_AXIS_AABB;
            }
        }
        return null;
    }

    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        BlockState blockstate = this.defaultBlockState();
        FluidState fluidstate = context.getLevel().getFluidState(context.getClickedPos());
        Direction direction = context.getClickedFace();
        if (direction.getAxis().isVertical()) {
            return (BlockState)((BlockState)((BlockState)blockstate.setValue((Property)UPRIGHT, (Comparable)Boolean.valueOf(true))).setValue((Property)FACING, (Comparable)context.getNearestLookingDirection().getOpposite())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
        }
        return (BlockState)((BlockState)((BlockState)blockstate.setValue((Property)UPRIGHT, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)direction)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.getType() == Fluids.WATER));
    }

    @NotNull
    public BlockState rotate(BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, TYPE, UPRIGHT, WATERLOGGED});
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @NotNull
    public BlockState updateShape(BlockState state, @NotNull Direction direction, @NotNull BlockState stateOut, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos pos2) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, direction, stateOut, level, pos, pos2);
    }
}

