/*
 * Decompiled with CFR 0.152.
 */
package com.yablon.deco_storage.integration.jei;

import com.yablon.deco_storage.integration.jei.StorageCrafterRecipeCategory;
import com.yablon.deco_storage.integration.jei.StorageExtractorRecipeCategory;
import com.yablon.deco_storage.recipe.MyRecipeTypes;
import com.yablon.deco_storage.recipe.StorageCrafterRecipe;
import com.yablon.deco_storage.recipe.StorageExtractorRecipe;
import com.yablon.deco_storage.screen.StorageCrafterScreen;
import com.yablon.deco_storage.screen.StorageExtractorScreen;
import java.util.List;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.JeiPlugin;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IGuiHandlerRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.neoforged.fml.ModList;

@JeiPlugin
public class JEIPlugin
implements IModPlugin {
    public ResourceLocation getPluginUid() {
        return ResourceLocation.parse((String)"deco_storage:storage_crafter");
    }

    public void registerCategories(IRecipeCategoryRegistration registration) {
        if (!this.isJEILoaded()) {
            return;
        }
        registration.addRecipeCategories(new IRecipeCategory[]{new StorageCrafterRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new StorageExtractorRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(IRecipeRegistration registration) {
        if (!this.isJEILoaded()) {
            return;
        }
        RecipeManager recipeManager = Minecraft.getInstance().level.getRecipeManager();
        List recipeHolders = recipeManager.getAllRecipesFor(MyRecipeTypes.STORAGE_CRAFTER.get());
        List<StorageCrafterRecipe> recipes = recipeHolders.stream().map(RecipeHolder::value).toList();
        List extractorRecipeHolders = recipeManager.getAllRecipesFor(MyRecipeTypes.STORAGE_EXTRACTOR.get());
        List<StorageExtractorRecipe> extractorRecipes = extractorRecipeHolders.stream().map(RecipeHolder::value).toList();
        registration.addRecipes(StorageCrafterRecipeCategory.STORAGE_CRAFTER_RECIPE_TYPE, recipes);
        registration.addRecipes(StorageExtractorRecipeCategory.STORAGE_EXTRACTOR_RECIPE_TYPE, extractorRecipes);
    }

    public void registerGuiHandlers(IGuiHandlerRegistration registration) {
        if (!this.isJEILoaded()) {
            return;
        }
        registration.addRecipeClickArea(StorageCrafterScreen.class, 120, 30, 20, 30, new RecipeType[]{StorageCrafterRecipeCategory.STORAGE_CRAFTER_RECIPE_TYPE});
        registration.addRecipeClickArea(StorageExtractorScreen.class, 70, 30, 20, 30, new RecipeType[]{StorageExtractorRecipeCategory.STORAGE_EXTRACTOR_RECIPE_TYPE});
    }

    private boolean isJEILoaded() {
        return ModList.get().isLoaded("jei");
    }
}

