/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.inventory;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.apache.commons.lang3.EnumUtils;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotAttribute;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.event.SlotModifiersUpdatedEvent;
import top.theillusivec4.curios.api.type.ICuriosMenu;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.inventory.DynamicStackHandler;

public class CurioStacksHandler
implements ICurioStacksHandler {
    private static final ResourceLocation LEGACY_ID = ResourceLocation.fromNamespaceAndPath((String)"curios", (String)"legacy");
    private final ICuriosItemHandler itemHandler;
    private final String identifier;
    private final Map<ResourceLocation, AttributeModifier> modifiers = new HashMap<ResourceLocation, AttributeModifier>();
    private final Set<AttributeModifier> persistentModifiers = new HashSet<AttributeModifier>();
    private final Set<AttributeModifier> cachedModifiers = new HashSet<AttributeModifier>();
    private final Multimap<AttributeModifier.Operation, AttributeModifier> modifiersByOperation = HashMultimap.create();
    private int baseSize;
    private IDynamicStackHandler stackHandler;
    private IDynamicStackHandler cosmeticStackHandler;
    private boolean visible;
    private boolean cosmetic;
    private boolean canToggleRender;
    private ICurio.DropRule dropRule;
    private boolean update;
    private NonNullList<Boolean> renderHandler;

    public CurioStacksHandler(ICuriosItemHandler itemHandler, String identifier) {
        this(itemHandler, identifier, 1, true, false, true, ICurio.DropRule.DEFAULT);
    }

    public CurioStacksHandler(ICuriosItemHandler itemHandler, String identifier, int size, boolean visible, boolean cosmetic, boolean canToggleRender, ICurio.DropRule dropRule) {
        this.baseSize = size;
        this.visible = visible;
        this.cosmetic = cosmetic;
        this.itemHandler = itemHandler;
        this.identifier = identifier;
        this.canToggleRender = canToggleRender;
        this.dropRule = dropRule;
        this.renderHandler = NonNullList.withSize((int)size, (Object)true);
        this.stackHandler = new DynamicStackHandler(size, index -> new SlotContext(identifier, itemHandler.getWearer(), (int)index, false, (Boolean)this.getRenders().get(index.intValue())));
        this.cosmeticStackHandler = new DynamicStackHandler(size, index -> new SlotContext(identifier, itemHandler.getWearer(), (int)index, true, (Boolean)this.getRenders().get(index.intValue())));
    }

    @Override
    public IDynamicStackHandler getStacks() {
        this.update();
        return this.stackHandler;
    }

    @Override
    public IDynamicStackHandler getCosmeticStacks() {
        this.update();
        return this.cosmeticStackHandler;
    }

    @Override
    public NonNullList<Boolean> getRenders() {
        this.update();
        return this.renderHandler;
    }

    @Override
    public boolean canToggleRendering() {
        return this.canToggleRender;
    }

    @Override
    public ICurio.DropRule getDropRule() {
        return this.dropRule;
    }

    @Override
    public int getSlots() {
        this.update();
        return this.stackHandler.getSlots();
    }

    @Override
    public int getSizeShift() {
        return 0;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public boolean hasCosmetic() {
        return this.cosmetic;
    }

    @Override
    public void grow(int amount) {
        if ((amount = Math.max(0, amount)) > 0) {
            this.addLegacyChange(amount);
        }
    }

    @Override
    public void shrink(int amount) {
        if ((amount = Math.max(0, amount)) > 0) {
            this.addLegacyChange(Math.min(this.getSlots(), amount) * -1);
        }
    }

    private void addLegacyChange(int shift) {
        AttributeModifier mod = this.getModifiers().get(LEGACY_ID);
        int current = mod != null ? (int)mod.amount() : 0;
        AttributeModifier newModifier = new AttributeModifier(LEGACY_ID, (double)(current += shift), AttributeModifier.Operation.ADD_VALUE);
        this.modifiers.put(newModifier.id(), newModifier);
        Collection<AttributeModifier> modifiers = this.getModifiersByOperation(newModifier.operation());
        modifiers.remove(newModifier);
        modifiers.add(newModifier);
        this.persistentModifiers.remove(newModifier);
        this.persistentModifiers.add(newModifier);
        this.flagUpdate();
    }

    @Override
    public CompoundTag serializeNBT() {
        ListTag list;
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.putInt("SavedBaseSize", this.baseSize);
        compoundNBT.put("Stacks", (Tag)this.stackHandler.serializeNBT((HolderLookup.Provider)this.itemHandler.getWearer().registryAccess()));
        compoundNBT.put("Cosmetics", (Tag)this.cosmeticStackHandler.serializeNBT((HolderLookup.Provider)this.itemHandler.getWearer().registryAccess()));
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.renderHandler.size(); ++i) {
            CompoundTag tag = new CompoundTag();
            tag.putInt("Slot", i);
            tag.putBoolean("Render", ((Boolean)this.renderHandler.get(i)).booleanValue());
            nbtTagList.add((Object)tag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.put("Renders", (Tag)nbtTagList);
        nbt.putInt("Size", this.renderHandler.size());
        compoundNBT.put("Renders", (Tag)nbt);
        compoundNBT.putBoolean("HasCosmetic", this.cosmetic);
        compoundNBT.putBoolean("Visible", this.visible);
        compoundNBT.putBoolean("RenderToggle", this.canToggleRender);
        compoundNBT.putString("DropRule", this.dropRule.toString());
        if (!this.persistentModifiers.isEmpty()) {
            list = new ListTag();
            for (AttributeModifier attributeModifier : this.persistentModifiers) {
                list.add((Object)attributeModifier.save());
            }
            compoundNBT.put("PersistentModifiers", (Tag)list);
        }
        if (!this.modifiers.isEmpty()) {
            list = new ListTag();
            this.modifiers.forEach((uuid, modifier) -> {
                if (!this.persistentModifiers.contains(modifier)) {
                    list.add((Object)modifier.save());
                }
            });
            compoundNBT.put("CachedModifiers", (Tag)list);
        }
        return compoundNBT;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        ListTag list;
        int sizeShift;
        if (nbt.contains("SavedBaseSize")) {
            this.baseSize = nbt.getInt("SavedBaseSize");
        }
        if (nbt.contains("Stacks")) {
            this.stackHandler.deserializeNBT((HolderLookup.Provider)this.itemHandler.getWearer().registryAccess(), nbt.getCompound("Stacks"));
        }
        if (nbt.contains("Cosmetics")) {
            this.cosmeticStackHandler.deserializeNBT((HolderLookup.Provider)this.itemHandler.getWearer().registryAccess(), nbt.getCompound("Cosmetics"));
        }
        if (nbt.contains("Renders")) {
            CompoundTag tag = nbt.getCompound("Renders");
            this.renderHandler = NonNullList.withSize((int)(nbt.contains("Size", 3) ? nbt.getInt("Size") : this.stackHandler.getSlots()), (Object)true);
            ListTag tagList = tag.getList("Renders", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag tags = tagList.getCompound(i);
                int slot = tags.getInt("Slot");
                if (slot < 0 || slot >= this.renderHandler.size()) continue;
                this.renderHandler.set(slot, (Object)tags.getBoolean("Render"));
            }
        }
        if (nbt.contains("SizeShift") && (sizeShift = nbt.getInt("SizeShift")) != 0) {
            this.addLegacyChange(sizeShift);
        }
        this.cosmetic = nbt.contains("HasCosmetic") ? nbt.getBoolean("HasCosmetic") : this.cosmetic;
        this.visible = nbt.contains("Visible") ? nbt.getBoolean("Visible") : this.visible;
        boolean bl = this.canToggleRender = nbt.contains("RenderToggle") ? nbt.getBoolean("RenderToggle") : this.canToggleRender;
        if (nbt.contains("DropRule")) {
            this.dropRule = (ICurio.DropRule)EnumUtils.getEnum(ICurio.DropRule.class, (String)nbt.getString("DropRule"), (Enum)this.dropRule);
        }
        if (nbt.contains("PersistentModifiers", 9)) {
            list = nbt.getList("PersistentModifiers", 10);
            for (int i = 0; i < list.size(); ++i) {
                AttributeModifier attributeModifier = AttributeModifier.load((CompoundTag)list.getCompound(i));
                if (attributeModifier == null) continue;
                this.addPermanentModifier(attributeModifier);
            }
        }
        if (nbt.contains("CachedModifiers", 9)) {
            list = nbt.getList("CachedModifiers", 10);
            for (int i = 0; i < list.size(); ++i) {
                AttributeModifier attributeModifier = AttributeModifier.load((CompoundTag)list.getCompound(i));
                if (attributeModifier == null) continue;
                this.cachedModifiers.add(attributeModifier);
                this.addTransientModifier(attributeModifier);
            }
        }
        this.update();
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public CompoundTag getSyncTag() {
        CompoundTag compoundNBT = new CompoundTag();
        compoundNBT.put("Stacks", (Tag)this.stackHandler.serializeNBT((HolderLookup.Provider)this.itemHandler.getWearer().registryAccess()));
        compoundNBT.put("Cosmetics", (Tag)this.cosmeticStackHandler.serializeNBT((HolderLookup.Provider)this.itemHandler.getWearer().registryAccess()));
        ListTag nbtTagList = new ListTag();
        for (int i = 0; i < this.renderHandler.size(); ++i) {
            CompoundTag tag = new CompoundTag();
            tag.putInt("Slot", i);
            tag.putBoolean("Render", ((Boolean)this.renderHandler.get(i)).booleanValue());
            nbtTagList.add((Object)tag);
        }
        CompoundTag nbt = new CompoundTag();
        nbt.put("Renders", (Tag)nbtTagList);
        nbt.putInt("Size", this.renderHandler.size());
        compoundNBT.put("Renders", (Tag)nbt);
        compoundNBT.putBoolean("HasCosmetic", this.cosmetic);
        compoundNBT.putBoolean("Visible", this.visible);
        compoundNBT.putBoolean("RenderToggle", this.canToggleRender);
        compoundNBT.putString("DropRule", this.dropRule.toString());
        compoundNBT.putInt("BaseSize", this.baseSize);
        if (!this.modifiers.isEmpty()) {
            ListTag list = new ListTag();
            for (Map.Entry<ResourceLocation, AttributeModifier> modifier : this.modifiers.entrySet()) {
                list.add((Object)modifier.getValue().save());
            }
            compoundNBT.put("Modifiers", (Tag)list);
        }
        return compoundNBT;
    }

    @Override
    public void applySyncTag(CompoundTag tag) {
        int sizeShift;
        if (tag.contains("BaseSize")) {
            this.baseSize = tag.getInt("BaseSize");
        }
        if (tag.contains("Stacks")) {
            this.stackHandler.deserializeNBT((HolderLookup.Provider)this.itemHandler.getWearer().registryAccess(), tag.getCompound("Stacks"));
        }
        if (tag.contains("Cosmetics")) {
            this.cosmeticStackHandler.deserializeNBT((HolderLookup.Provider)this.itemHandler.getWearer().registryAccess(), tag.getCompound("Cosmetics"));
        }
        if (tag.contains("Renders")) {
            CompoundTag compoundNBT = tag.getCompound("Renders");
            this.renderHandler = NonNullList.withSize((int)(compoundNBT.contains("Size", 3) ? compoundNBT.getInt("Size") : this.stackHandler.getSlots()), (Object)true);
            ListTag tagList = compoundNBT.getList("Renders", 10);
            for (int i = 0; i < tagList.size(); ++i) {
                CompoundTag tags = tagList.getCompound(i);
                int slot = tags.getInt("Slot");
                if (slot < 0 || slot >= this.renderHandler.size()) continue;
                this.renderHandler.set(slot, (Object)tags.getBoolean("Render"));
            }
        }
        if (tag.contains("SizeShift") && (sizeShift = tag.getInt("SizeShift")) != 0) {
            this.addLegacyChange(sizeShift);
        }
        this.cosmetic = tag.contains("HasCosmetic") ? tag.getBoolean("HasCosmetic") : this.cosmetic;
        this.visible = tag.contains("Visible") ? tag.getBoolean("Visible") : this.visible;
        boolean bl = this.canToggleRender = tag.contains("RenderToggle") ? tag.getBoolean("RenderToggle") : this.canToggleRender;
        if (tag.contains("DropRule")) {
            this.dropRule = (ICurio.DropRule)EnumUtils.getEnum(ICurio.DropRule.class, (String)tag.getString("DropRule"), (Enum)this.dropRule);
        }
        this.modifiers.clear();
        this.persistentModifiers.clear();
        this.modifiersByOperation.clear();
        if (tag.contains("Modifiers", 9)) {
            ListTag list = tag.getList("Modifiers", 10);
            for (int i = 0; i < list.size(); ++i) {
                AttributeModifier attributeModifier = AttributeModifier.load((CompoundTag)list.getCompound(i));
                if (attributeModifier == null) continue;
                this.addTransientModifier(attributeModifier);
            }
        }
        this.flagUpdate();
        this.update();
    }

    @Override
    public void copyModifiers(ICurioStacksHandler other) {
        this.modifiers.clear();
        this.cachedModifiers.clear();
        this.modifiersByOperation.clear();
        this.persistentModifiers.clear();
        other.getModifiers().forEach((uuid, modifier) -> this.addTransientModifier((AttributeModifier)modifier));
        this.cachedModifiers.addAll(other.getCachedModifiers());
        for (AttributeModifier persistentModifier : other.getPermanentModifiers()) {
            this.addPermanentModifier(persistentModifier);
        }
        this.update();
    }

    @Override
    public Map<ResourceLocation, AttributeModifier> getModifiers() {
        return this.modifiers;
    }

    @Override
    public Set<AttributeModifier> getPermanentModifiers() {
        return this.persistentModifiers;
    }

    @Override
    public Set<AttributeModifier> getCachedModifiers() {
        return this.cachedModifiers;
    }

    @Override
    public Collection<AttributeModifier> getModifiersByOperation(AttributeModifier.Operation operation) {
        return this.modifiersByOperation.get((Object)operation);
    }

    @Override
    public void addTransientModifier(AttributeModifier modifier) {
        this.modifiers.put(modifier.id(), modifier);
        this.getModifiersByOperation(modifier.operation()).add(modifier);
        this.flagUpdate();
    }

    @Override
    public void addPermanentModifier(AttributeModifier modifier) {
        this.addTransientModifier(modifier);
        this.persistentModifiers.add(modifier);
    }

    @Override
    public void removeModifier(ResourceLocation id) {
        AttributeModifier modifier = this.modifiers.remove(id);
        if (modifier != null) {
            this.persistentModifiers.remove(modifier);
            this.getModifiersByOperation(modifier.operation()).remove(modifier);
            this.flagUpdate();
        }
    }

    private void flagUpdate() {
        this.update = true;
        if (this.itemHandler != null) {
            this.itemHandler.getUpdatingInventories().remove(this);
            this.itemHandler.getUpdatingInventories().add(this);
        }
    }

    @Override
    public void clearModifiers() {
        HashSet<ResourceLocation> ids = new HashSet<ResourceLocation>(this.modifiers.keySet());
        for (ResourceLocation id : ids) {
            this.removeModifier(id);
        }
    }

    @Override
    public void clearCachedModifiers() {
        for (AttributeModifier cachedModifier : this.cachedModifiers) {
            this.removeModifier(cachedModifier.id());
        }
        this.cachedModifiers.clear();
        this.flagUpdate();
    }

    @Override
    public void update() {
        if (this.update) {
            this.update = false;
            double baseSize = this.baseSize;
            for (AttributeModifier mod : this.getModifiersByOperation(AttributeModifier.Operation.ADD_VALUE)) {
                baseSize += mod.amount();
            }
            double size = baseSize;
            for (AttributeModifier mod : this.getModifiersByOperation(AttributeModifier.Operation.ADD_MULTIPLIED_BASE)) {
                size += (double)this.baseSize * mod.amount();
            }
            for (AttributeModifier mod : this.getModifiersByOperation(AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL)) {
                size *= mod.amount();
            }
            if (size != (double)this.getSlots()) {
                this.resize((int)size);
                if (this.itemHandler != null && this.itemHandler.getWearer() != null) {
                    NeoForge.EVENT_BUS.post((Event)new SlotModifiersUpdatedEvent(this.itemHandler.getWearer(), Set.of(this.identifier)));
                    LivingEntity livingEntity = this.itemHandler.getWearer();
                    if (livingEntity instanceof Player) {
                        Player player = (Player)livingEntity;
                        livingEntity = player.containerMenu;
                        if (livingEntity instanceof ICuriosMenu) {
                            ICuriosMenu curiosMenu = (ICuriosMenu)livingEntity;
                            curiosMenu.resetSlots();
                        }
                    }
                }
            }
        }
    }

    private void resize(int newSize) {
        int currentSize = this.getSlots();
        if (currentSize != newSize) {
            int change = newSize - currentSize;
            if (currentSize > newSize) {
                this.loseStacks(this.stackHandler, this.identifier, change *= -1);
                this.stackHandler.shrink(change);
                this.cosmeticStackHandler.shrink(change);
                NonNullList newList = NonNullList.withSize((int)Math.max(0, newSize), (Object)true);
                for (int i = 0; i < newList.size() && i < this.renderHandler.size(); ++i) {
                    newList.set(i, (Object)((Boolean)this.renderHandler.get(i)));
                }
                this.renderHandler = newList;
            } else {
                this.stackHandler.grow(change);
                this.cosmeticStackHandler.grow(change);
                NonNullList newList = NonNullList.withSize((int)Math.max(0, newSize), (Object)true);
                for (int i = 0; i < newList.size() && i < this.renderHandler.size(); ++i) {
                    newList.set(i, (Object)((Boolean)this.renderHandler.get(i)));
                }
                this.renderHandler = newList;
            }
        }
    }

    private void loseStacks(IDynamicStackHandler stackHandler, String identifier, int amount) {
        if (this.itemHandler == null) {
            return;
        }
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        for (int i = Math.max(0, stackHandler.getSlots() - amount); i >= 0 && i < stackHandler.getSlots(); ++i) {
            ItemStack stack = stackHandler.getStackInSlot(i);
            drops.add(stackHandler.getStackInSlot(i));
            LivingEntity entity = this.itemHandler.getWearer();
            SlotContext slotContext = new SlotContext(identifier, entity, i, false, this.visible);
            if (!stack.isEmpty()) {
                Multimap<Holder<Attribute>, AttributeModifier> map = CuriosApi.getAttributeModifiers(slotContext, CuriosApi.getSlotId(slotContext), stack);
                HashMultimap slots = HashMultimap.create();
                HashSet<Holder> toRemove = new HashSet<Holder>();
                AttributeMap attributeMap = entity.getAttributes();
                for (Holder attribute : map.keySet()) {
                    Object object = attribute.value();
                    if (!(object instanceof SlotAttribute)) continue;
                    SlotAttribute wrapper = (SlotAttribute)((Object)object);
                    slots.putAll((Object)wrapper.getIdentifier(), (Iterable)map.get((Object)attribute));
                    toRemove.add(attribute);
                }
                for (Holder attribute : toRemove) {
                    map.removeAll((Object)attribute);
                }
                map.forEach((key, value) -> {
                    AttributeInstance attInst = attributeMap.getInstance(key);
                    if (attInst != null) {
                        attInst.removeModifier(value);
                    }
                });
                this.itemHandler.removeSlotModifiers((Multimap<String, AttributeModifier>)slots);
                CuriosApi.getCurio(stack).ifPresent(curio -> curio.onUnequip(slotContext, ItemStack.EMPTY));
            }
            stackHandler.setStackInSlot(i, ItemStack.EMPTY);
        }
        drops.forEach(this.itemHandler::loseInvalidStack);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CurioStacksHandler that = (CurioStacksHandler)o;
        return this.identifier.equals(that.identifier);
    }

    public int hashCode() {
        return Objects.hash(this.identifier);
    }
}

