/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.client;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;
import net.neoforged.neoforge.common.util.AttributeUtil;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.client.KeyRegistry;
import top.theillusivec4.curios.common.network.client.CPacketOpenCurios;

public class ClientEventHandler {
    @SubscribeEvent
    public void onClientTick(ClientTickEvent.Post event) {
        if (KeyRegistry.openCurios.consumeClick() && Minecraft.getInstance().isWindowActive()) {
            PacketDistributor.sendToServer((CustomPacketPayload)new CPacketOpenCurios(ItemStack.EMPTY), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        ArrayList<String> slots;
        ItemStack stack = event.getItemStack();
        Player player = event.getEntity();
        if (stack.isEmpty()) {
            return;
        }
        List tooltip = event.getToolTip();
        Set<String> tags = Set.copyOf((player != null ? CuriosApi.getItemStackSlots(stack, (LivingEntity)player) : CuriosApi.getItemStackSlots(stack, FMLLoader.getDist() == Dist.CLIENT)).keySet());
        if (tags.contains("curio")) {
            tags = Set.of("curio");
        }
        if ((slots = new ArrayList<String>(tags)).isEmpty()) {
            return;
        }
        MutableComponent slotsTooltip = Component.translatable((String)"curios.tooltip.slot").append(" ").withStyle(ChatFormatting.GOLD);
        for (int j = 0; j < slots.size(); ++j) {
            String key = "curios.identifier." + slots.get(j);
            MutableComponent type = Component.translatable((String)key);
            if (j < slots.size() - 1) {
                type = type.append(", ");
            }
            type = type.withStyle(ChatFormatting.YELLOW);
            slotsTooltip.append((Component)type);
        }
        Item.TooltipContext context = event.getContext();
        Optional<ICurio> curio = CuriosApi.getCurio(stack);
        tooltip.addAll(1, curio.isPresent() ? curio.get().getSlotsTooltip(Arrays.asList(slotsTooltip), context) : Arrays.asList(slotsTooltip));
        ArrayList<Component> attributesTooltip = new ArrayList<Component>();
        for (String identifier : slots) {
            Multimap<Holder<Attribute>, AttributeModifier> attributes = CuriosApi.getAttributeModifiers(new SlotContext(identifier, (LivingEntity)player, 0, false, true), ResourceLocation.fromNamespaceAndPath((String)"curios", (String)identifier), stack);
            if (attributes.isEmpty()) continue;
            attributesTooltip.add((Component)Component.empty());
            attributesTooltip.add((Component)Component.translatable((String)("curios.modifiers." + identifier)).withStyle(ChatFormatting.GOLD));
            if (player == null) continue;
            AttributeUtil.applyTextFor((ItemStack)stack, attributesTooltip::add, attributes, (AttributeTooltipContext)AttributeTooltipContext.of((Player)player, (Item.TooltipContext)context, (TooltipFlag)event.getFlags()));
        }
        tooltip.addAll(2, curio.isPresent() ? curio.get().getAttributesTooltip(attributesTooltip, context) : attributesTooltip);
    }
}

