/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.util;

import com.google.common.collect.ImmutableSet;
import de.mrjulsen.crn.client.ClientWrapper;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.config.ModCommonConfig;
import de.mrjulsen.crn.exceptions.RuntimeSideException;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.core.IIterableEnum;
import de.mrjulsen.mcdragonlib.core.ITranslatableEnum;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import dev.architectury.utils.GameInstance;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class Lock {
    private static final String NBT_STATE = "State";
    private static final String NBT_TRUSTED = "Trusted";
    public static final String TRANSLATION_KEY_TRUSTED_PLAYERS = "gui.createrailwaysnavigator.lock.trusted_players";
    public static final String TRANSLATION_KEY_TRANSFER_OWNERSHIP = "gui.createrailwaysnavigator.lock.transfer_ownership";
    private final MutableComponent charAllowed = TextUtils.text((String)"\u2714").withStyle(ChatFormatting.GREEN);
    private final MutableComponent charTrusted = TextUtils.text((String)"\u2714").withStyle(ChatFormatting.GOLD);
    private final MutableComponent charLocked = TextUtils.text((String)"\u274c").withStyle(ChatFormatting.RED);
    private final MutableComponent txtPermissions = TextUtils.translate((String)"gui.createrailwaysnavigator.lock.permissions");
    private final MutableComponent txtRightClickOptions = TextUtils.translate((String)"gui.createrailwaysnavigator.lock.right_click_options").withStyle(ChatFormatting.DARK_GRAY).withStyle(ChatFormatting.ITALIC);
    private final MutableComponent txtNoOwner = TextUtils.translate((String)"gui.createrailwaysnavigator.lock.no_owner");
    private final String keyStatus = "gui.createrailwaysnavigator.lock.state";
    private final String keyOwner = "gui.createrailwaysnavigator.lock.owner";
    private Owner owner;
    private LockState state = LockState.UNLOCKED;
    private final Set<Owner> trusted = new HashSet<Owner>();

    private Lock(LockState status, Owner owner, Set<Owner> trusted) {
        this.state = status;
        this.owner = owner;
        this.trusted.addAll(trusted);
    }

    public Lock(Owner owner) {
        this(LockState.UNLOCKED, owner, new HashSet<Owner>());
    }

    public Lock() {
        this(LockState.UNLOCKED, null, new HashSet<Owner>());
    }

    public void set(LockState state) {
        this.state = state;
    }

    public LockState get() {
        return this.state;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAllowed(Owner target) throws RuntimeSideException {
        if (!DragonLib.hasServer()) {
            throw new RuntimeSideException(false);
        }
        if (this.owner == null) return true;
        if (this.isAdmin(target)) return true;
        if (this.owner.equals(target)) return true;
        switch (this.state.ordinal()) {
            case 1: {
                if (!this.isTrusted(target)) return false;
            }
            default: {
                return true;
            }
        }
    }

    public boolean isAdmin(Owner target) throws RuntimeSideException {
        if (!DragonLib.hasServer()) {
            throw new RuntimeSideException(false);
        }
        return this.owner != null && (this.owner.equals(target) || (Integer)ModCommonConfig.GLOBAL_SETTINGS_ADMIN_PERMISSION_LEVEL.get() >= 0 && GameInstance.getServer().getPlayerList().getPlayer(target.uuid()).hasPermissions(((Integer)ModCommonConfig.GLOBAL_SETTINGS_ADMIN_PERMISSION_LEVEL.get()).intValue()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAllowed() throws RuntimeSideException {
        if (Platform.getEnvironment() != Env.CLIENT) {
            throw new RuntimeSideException(true);
        }
        Owner self = ClientWrapper.getMe();
        if (this.owner == null) return true;
        if (this.isAdmin()) return true;
        if (this.owner.equals(self)) return true;
        switch (this.state.ordinal()) {
            case 1: {
                if (!this.isTrusted(self)) return false;
            }
            default: {
                return true;
            }
        }
    }

    public boolean isAdmin() throws RuntimeSideException {
        if (Platform.getEnvironment() != Env.CLIENT) {
            throw new RuntimeSideException(true);
        }
        Owner self = ClientWrapper.getMe();
        return this.owner != null && (this.owner.equals(self) || (Integer)ModCommonConfig.GLOBAL_SETTINGS_ADMIN_PERMISSION_LEVEL.get() >= 0 && ClientWrapper.getClientPlayer().hasPermissions(((Integer)ModCommonConfig.GLOBAL_SETTINGS_ADMIN_PERMISSION_LEVEL.get()).intValue()));
    }

    public Set<Owner> getTrusted() {
        return ImmutableSet.copyOf(this.trusted);
    }

    public void addTrusted(Owner target) {
        this.trusted.add(target);
    }

    public void updateTrusted(Set<Owner> targets) {
        this.trusted.clear();
        this.trusted.addAll(targets);
    }

    public boolean isTrusted(Owner target) {
        return this.trusted.contains(target);
    }

    public void removeTrusted(Owner target) {
        this.trusted.remove(target);
    }

    public Optional<Owner> getOwner() {
        return Optional.ofNullable(this.owner);
    }

    public void setOwner(Owner newOwner) {
        this.owner = newOwner;
    }

    public List<FormattedText> asText(Owner target) {
        ArrayList<FormattedText> texts = new ArrayList<FormattedText>(4);
        texts.add((FormattedText)TextUtils.empty().append((Component)this.txtPermissions).append(" ").append((Component)(this.isTrusted(target) ? this.charTrusted : (this.isAllowed() ? this.charAllowed : this.charLocked))));
        texts.add((FormattedText)TextUtils.translate((String)"gui.createrailwaysnavigator.lock.state", (Object[])new Object[]{this.get().getFormattedText()}).withStyle(ChatFormatting.GRAY));
        texts.add((FormattedText)TextUtils.translate((String)"gui.createrailwaysnavigator.lock.owner", (Object[])new Object[]{this.getOwner().map(x -> x.name().isBlank() ? this.txtNoOwner : TextUtils.text((String)x.name()).withStyle(ChatFormatting.GREEN)).orElse(this.txtNoOwner)}).withStyle(ChatFormatting.GRAY));
        if (this.isAdmin()) {
            texts.add((FormattedText)this.txtRightClickOptions);
        }
        return texts;
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.putByte(NBT_STATE, this.state.getIndex());
        if (this.owner != null) {
            this.owner.toNbt(nbt);
        }
        ListTag list = new ListTag();
        for (Owner t : this.trusted) {
            list.add((Object)t.toNbt());
        }
        nbt.put(NBT_TRUSTED, (Tag)list);
        return nbt;
    }

    public static Lock fromNbt(CompoundTag nbt) {
        return new Lock(LockState.getByIndex(nbt.getByte(NBT_STATE)), Owner.fromNbt(nbt), nbt.getList(NBT_TRUSTED, 10).stream().map(x -> Owner.fromNbt((CompoundTag)x)).collect(Collectors.toSet()));
    }

    public static enum LockState implements ITranslatableEnum,
    IIterableEnum<LockState>
    {
        UNLOCKED("unlocked", 0, ModGuiIcons.UNLOCKED, key -> TextUtils.translate((String)key).withStyle(ChatFormatting.GREEN)),
        LOCKED("locked", 127, ModGuiIcons.LOCKED, key -> TextUtils.translate((String)key).withStyle(ChatFormatting.RED));

        private final String name;
        private final byte index;
        private final ModGuiIcons icon;
        private final Function<String, Component> text;

        private LockState(String name, byte index, ModGuiIcons icon, Function<String, Component> text) {
            this.name = name;
            this.index = index;
            this.icon = icon;
            this.text = text;
        }

        public byte getIndex() {
            return this.index;
        }

        public String getName() {
            return this.name;
        }

        public Component getFormattedText() {
            return this.text.apply(this.getValueTranslationKey("createrailwaysnavigator"));
        }

        public Sprite getIcon() {
            return this.icon.getAsSprite(16, 16);
        }

        public static LockState getByIndex(int i) {
            return Arrays.stream(LockState.values()).filter(x -> x.getIndex() == i).findFirst().orElse(UNLOCKED);
        }

        public String getEnumName() {
            return "lock_state";
        }

        public String getEnumValueName() {
            return this.getName();
        }

        public LockState[] getValues() {
            return LockState.values();
        }
    }

    public record PermissionsUpdateData(UUID id, Owner newOwner, LockState state, Set<Owner> trusted) {
        private static final String NBT_ID = "Id";
        private static final String NBT_STATE = "State";
        private static final String NBT_NEW_OWNER = "NewOwner";
        private static final String NBT_TRUSTED = "Trusted";

        public CompoundTag toNbt() {
            CompoundTag nbt = new CompoundTag();
            nbt.putUUID(NBT_ID, this.id);
            if (this.state != null) {
                nbt.putByte("State", this.state.getIndex());
            }
            if (this.trusted != null) {
                ListTag list = new ListTag();
                for (Owner t : this.trusted) {
                    list.add((Object)t.toNbt());
                }
                nbt.put("Trusted", (Tag)list);
            }
            if (this.newOwner != null) {
                nbt.put(NBT_NEW_OWNER, (Tag)this.newOwner.toNbt());
            }
            return nbt;
        }

        public static PermissionsUpdateData fromNbt(CompoundTag nbt) {
            return new PermissionsUpdateData(nbt.getUUID(NBT_ID), nbt.contains(NBT_NEW_OWNER) ? Owner.fromNbt(nbt.getCompound(NBT_NEW_OWNER)) : null, nbt.contains("State") ? LockState.getByIndex(nbt.getByte("State")) : null, nbt.contains("Trusted") ? nbt.getList("Trusted", 10).stream().map(x -> Owner.fromNbt((CompoundTag)x)).collect(Collectors.toSet()) : null);
        }
    }
}

