/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.item;

import com.mojang.blaze3d.vertex.PoseStack;
import de.mrjulsen.crn.block.NavigatorLecternBlock;
import de.mrjulsen.crn.client.ClientWrapper;
import de.mrjulsen.crn.registry.ModBlocks;
import de.mrjulsen.mcdragonlib.client.ber.RenderGraphics;
import de.mrjulsen.mcdragonlib.client.render.ICustomItemRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LecternBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class NavigatorItem
extends Item
implements ICustomItemRenderer {
    public NavigatorItem(Item.Properties props) {
        super(props);
    }

    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = level.getBlockState(pos);
        ItemStack stack = context.getItemInHand();
        if (player.mayBuild()) {
            if (player.isShiftKeyDown()) {
                if (ModBlocks.NAVIGATOR_LECTERN.has(state)) {
                    if (!level.isClientSide) {
                        ((NavigatorLecternBlock)((Object)ModBlocks.NAVIGATOR_LECTERN.get())).withBlockEntityDo((BlockGetter)level, pos, be -> be.swapControllers(stack, player, context.getHand(), state));
                    }
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (state.is(Blocks.LECTERN) && !((Boolean)state.getValue((Property)LecternBlock.HAS_BOOK)).booleanValue()) {
                    if (!level.isClientSide) {
                        ItemStack lecternStack = player.isCreative() ? stack.copy() : stack.split(1);
                        ((NavigatorLecternBlock)((Object)ModBlocks.NAVIGATOR_LECTERN.get())).replaceLectern(state, level, pos, lecternStack);
                    }
                    return InteractionResult.SUCCESS;
                }
                if (ModBlocks.NAVIGATOR_LECTERN.has(state)) {
                    return InteractionResult.PASS;
                }
            }
        }
        return player.isShiftKeyDown() ? InteractionResult.FAIL : this.use(level, player, context.getHand()).getResult();
    }

    public InteractionResultHolder<ItemStack> use(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        if (pLevel.isClientSide) {
            ClientWrapper.showNavigatorGui();
            return InteractionResultHolder.success((Object)pPlayer.getItemInHand(pUsedHand));
        }
        return super.use(pLevel, pPlayer, pUsedHand);
    }

    public void renderAdditional(RenderGraphics graphics, ItemStack itemStack, ItemDisplayContext context, boolean leftHand, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay, BakedModel model) {
        ClientWrapper.renderNavigatorItem(graphics, itemStack, context, leftHand, poseStack, buffer, combinedLight, combinedOverlay, model);
    }
}

