/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.storage;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.station.GlobalStation;
import de.mrjulsen.crn.CreateRailwaysNavigator;
import de.mrjulsen.crn.config.ModCommonConfig;
import de.mrjulsen.crn.data.StationTag;
import de.mrjulsen.crn.data.TagName;
import de.mrjulsen.crn.data.TrainCategory;
import de.mrjulsen.crn.data.TrainLine;
import de.mrjulsen.crn.data.UserSettings;
import de.mrjulsen.crn.data.train.ScheduleSection;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.data.train.TrainPrediction;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.data.train.TrainUtils;
import de.mrjulsen.crn.event.ModCommonEvents;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.crn.util.Owner;
import de.mrjulsen.mcdragonlib.data.INBTSerializable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;

public class GlobalSettings
implements INBTSerializable {
    @Deprecated
    public static final String LEGACY_FILENAME = "createrailwaysnavigator_global_settings.dat";
    @Deprecated
    private static final String LEGACY_NBT_TRAIN_GROUPS = "TrainGroups";
    public static final String FILENAME = "createrailwaysnavigator_global_settings.nbt";
    public static final int DATA_VERSION = 2;
    private static final String NBT_VERSION = "Version";
    private static final String NBT_STATION_TAGS = "StationTags";
    private static final String NBT_TRAIN_CATEGORIES = "TrainCategories";
    private static final String NBT_STATION_BLACKLIST = "StationBlacklist";
    private static final String NBT_TRAIN_BLACKLIST = "TrainBlacklist";
    private static final String NBT_TRAIN_LINES = "TrainLines";
    private final MinecraftServer server;
    private final Map<UUID, StationTag> stationTags = new HashMap<UUID, StationTag>();
    private final Map<UUID, TrainCategory> trainCategories = new HashMap<UUID, TrainCategory>();
    private final Map<UUID, TrainLine> trainLines = new HashMap<UUID, TrainLine>();
    private final Set<String> stationBlacklist = new HashSet<String>();
    private final Set<String> trainBlacklist = new HashSet<String>();
    private static GlobalSettings instance;

    private GlobalSettings(MinecraftServer server) {
        this.server = server;
    }

    public static boolean modificationsAllowed(Player player) {
        return player.hasPermissions(((Integer)ModCommonConfig.GLOBAL_SETTINGS_PERMISSION_LEVEL.get()).intValue());
    }

    public static synchronized GlobalSettings getInstance() {
        if (instance == null) {
            try {
                instance = GlobalSettings.open(ModCommonEvents.getCurrentServer().get());
            }
            catch (Exception e) {
                CreateRailwaysNavigator.LOGGER.error("Unable to open settings file.", (Throwable)e);
                instance = new GlobalSettings(ModCommonEvents.getCurrentServer().get());
            }
        }
        return instance;
    }

    public static boolean hasInstance() {
        return instance != null;
    }

    public static void clearInstance() {
        if (instance != null) {
            instance.close();
        }
        instance = null;
    }

    public synchronized void save() {
        CompoundTag nbt = this.serializeNbt();
        try {
            NbtIo.writeCompressed((CompoundTag)nbt, (Path)this.server.getWorldPath(new LevelResource("data/createrailwaysnavigator_global_settings.nbt")));
            if (((Boolean)ModCommonConfig.ADVANCED_LOGGING.get()).booleanValue()) {
                CreateRailwaysNavigator.LOGGER.info("Saved global settings.");
            }
        }
        catch (IOException e) {
            CreateRailwaysNavigator.LOGGER.error("Unable to save global settings.", (Throwable)e);
        }
    }

    public static synchronized GlobalSettings open(MinecraftServer server) throws Exception {
        Path legacyPath = server.getWorldPath(new LevelResource("data/createrailwaysnavigator_global_settings.dat"));
        Path settingsPath = server.getWorldPath(new LevelResource("data/createrailwaysnavigator_global_settings.nbt"));
        GlobalSettings file = new GlobalSettings(server);
        if (legacyPath.toFile().exists()) {
            CreateRailwaysNavigator.LOGGER.warn("A legacy global settings file was found. Try to load it.");
            file.deserializeNbtLegacy(NbtIo.readCompressed((Path)legacyPath, (NbtAccounter)NbtAccounter.unlimitedHeap()).getCompound("data"));
            legacyPath.toFile().delete();
        } else if (settingsPath.toFile().exists()) {
            file.deserializeNbt(NbtIo.readCompressed((Path)settingsPath, (NbtAccounter)NbtAccounter.unlimitedHeap()));
        }
        return file;
    }

    public synchronized CompoundTag serializeNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.putInt(NBT_VERSION, 2);
        CompoundTag stationsComp = new CompoundTag();
        this.stationTags.entrySet().forEach(x -> stationsComp.put(((UUID)x.getKey()).toString(), (Tag)((StationTag)x.getValue()).toNbt()));
        nbt.put(NBT_STATION_TAGS, (Tag)stationsComp);
        CompoundTag trainCategoriesComp = new CompoundTag();
        this.trainCategories.entrySet().forEach(x -> trainCategoriesComp.put(((UUID)x.getKey()).toString(), (Tag)((TrainCategory)x.getValue()).toNbt()));
        nbt.put(NBT_TRAIN_CATEGORIES, (Tag)trainCategoriesComp);
        ListTag stationsBlacklist = new ListTag();
        this.stationBlacklist.forEach(x -> stationsBlacklist.add((Object)StringTag.valueOf((String)x)));
        nbt.put(NBT_STATION_BLACKLIST, (Tag)stationsBlacklist);
        ListTag trainsBlacklist = new ListTag();
        this.trainBlacklist.forEach(x -> trainsBlacklist.add((Object)StringTag.valueOf((String)x)));
        nbt.put(NBT_TRAIN_BLACKLIST, (Tag)trainsBlacklist);
        CompoundTag trainLinesComp = new CompoundTag();
        this.trainLines.entrySet().forEach(x -> trainLinesComp.put(((UUID)x.getKey()).toString(), (Tag)((TrainLine)x.getValue()).toNbt()));
        nbt.put(NBT_TRAIN_LINES, (Tag)trainLinesComp);
        return nbt;
    }

    public void deserializeNbt(CompoundTag nbt) {
        int version = nbt.getInt(NBT_VERSION);
        CompoundTag stationsComp = nbt.getCompound(NBT_STATION_TAGS);
        this.stationTags.putAll(stationsComp.getAllKeys().stream().map(x -> StationTag.fromNbt(stationsComp.getCompound(x), UUID.fromString(x))).collect(Collectors.toMap(x -> x.getId(), x -> x)));
        CompoundTag trainCategoiesComp = version <= 1 ? nbt.getCompound(LEGACY_NBT_TRAIN_GROUPS) : nbt.getCompound(NBT_TRAIN_CATEGORIES);
        this.trainCategories.putAll(trainCategoiesComp.getAllKeys().stream().map(x -> TrainCategory.fromNbt(trainCategoiesComp.getCompound(x))).collect(Collectors.toMap(x -> x.getId(), x -> x)));
        this.stationBlacklist.addAll(nbt.getList(NBT_STATION_BLACKLIST, 8).stream().map(x -> ((StringTag)x).getAsString()).toList());
        this.trainBlacklist.addAll(nbt.getList(NBT_TRAIN_BLACKLIST, 8).stream().map(x -> ((StringTag)x).getAsString()).toList());
        CompoundTag trainLinesComp = nbt.getCompound(NBT_TRAIN_LINES);
        this.trainLines.putAll(trainLinesComp.getAllKeys().stream().map(x -> TrainLine.fromNbt(trainLinesComp.getCompound(x))).collect(Collectors.toMap(x -> x.getId(), x -> x)));
    }

    @Deprecated
    private void deserializeNbtLegacy(CompoundTag nbt) {
        String NBT_ALIAS_REGISTRY = "RegisteredAliasData";
        String NBT_BLACKLIST = NBT_STATION_BLACKLIST;
        String NBT_TRAIN_BLACKLIST = NBT_TRAIN_BLACKLIST;
        String NBT_TRAIN_GROUP_REGISTRY = "RegisteredTrainGroups";
        List<Object> aliasData = new ArrayList();
        List<Object> trainGroupData = new ArrayList();
        List<Object> blacklistData = new ArrayList();
        List<Object> trainBlacklistData = new ArrayList();
        if (nbt.contains("RegisteredAliasData")) {
            aliasData = nbt.getList("RegisteredAliasData", 10).stream().map(x -> (CompoundTag)x).toList();
        }
        if (nbt.contains("RegisteredTrainGroups")) {
            trainGroupData = nbt.getList("RegisteredTrainGroups", 10).stream().map(x -> (CompoundTag)x).toList();
        }
        if (nbt.contains(NBT_STATION_BLACKLIST)) {
            blacklistData = nbt.getList(NBT_STATION_BLACKLIST, 8).stream().map(x -> ((StringTag)x).getAsString()).toList();
        }
        if (nbt.contains(NBT_TRAIN_BLACKLIST)) {
            trainBlacklistData = nbt.getList(NBT_TRAIN_BLACKLIST, 8).stream().map(x -> ((StringTag)x).getAsString()).toList();
        }
        LinkedHashSet usedIds = new LinkedHashSet();
        this.stationTags.putAll(aliasData.stream().map(x -> {
            UUID id;
            while (usedIds.contains(id = UUID.randomUUID())) {
            }
            usedIds.add(id);
            return StationTag.fromNbt(x, id);
        }).collect(Collectors.toMap(x -> x.getId(), x -> x)));
        usedIds.clear();
        this.trainCategories.putAll(trainGroupData.stream().map(x -> TrainCategory.fromNbt(x)).collect(Collectors.toMap(x -> x.getId(), x -> x)));
        this.stationBlacklist.addAll(blacklistData);
        this.trainBlacklist.addAll(trainBlacklistData);
        this.save();
    }

    public void close() {
        this.save();
    }

    public boolean hasStationTag(GlobalStation station) {
        return this.hasStationTag(station.name);
    }

    public boolean hasStationTag(String stationName) {
        for (StationTag tag : this.stationTags.values()) {
            if (!tag.contains(stationName)) continue;
            return true;
        }
        return false;
    }

    public boolean stationTagExists(String tagName) {
        return this.stationTagExists(TagName.of(tagName));
    }

    public boolean stationTagExists(TagName tagName) {
        for (StationTag tag : this.stationTags.values()) {
            if (!tag.getTagName().equals(tagName)) continue;
            return true;
        }
        return false;
    }

    public boolean stationTagExists(UUID id) {
        return this.stationTags.containsKey(id);
    }

    public StationTag getOrCreateStationTagFor(GlobalStation station) {
        return this.getOrCreateStationTagFor(station.name);
    }

    public StationTag getOrCreateStationTagFor(TagName tagName) {
        return this.getTagByName(tagName).orElse(this.getOrCreateStationTagFor(tagName.get()));
    }

    public StationTag getOrCreateStationTagFor(String stationName) {
        return this.getOrCreateStationTagFor(stationName, null);
    }

    public StationTag getOrCreateStationTagFor(String stationName, Owner owner) {
        if (stationName.contains("*")) {
            return this.getOrCreateTagForWildcard(stationName, owner);
        }
        for (StationTag tag : this.stationTags.values()) {
            if (!tag.contains(stationName)) continue;
            return tag;
        }
        return new StationTag(null, TagName.of(stationName), owner, Map.of(stationName, StationTag.StationInfo.empty()));
    }

    private StationTag getOrCreateTagForWildcard(String stationName, Owner owner) {
        String regex = stationName.isBlank() ? stationName : "\\Q" + stationName.replace("*", "\\E.*\\Q") + "\\E";
        for (StationTag tag : this.stationTags.values()) {
            for (String name : tag.getAllStationNames()) {
                if (!name.matches(regex)) continue;
                return tag;
            }
        }
        return new StationTag(null, TagName.of(stationName), owner, Map.of(stationName, StationTag.StationInfo.empty()));
    }

    public StationTag createOrGetStationTag(String name) {
        return this.createOrGetStationTag(TagName.of(name));
    }

    public StationTag createOrGetStationTag(TagName name) {
        return this.createOrGetStationTag(name, null);
    }

    public StationTag createOrGetStationTag(TagName name, Owner owner) {
        UUID newId;
        Optional<StationTag> tag = this.getTagByName(name);
        if (tag.isPresent()) {
            return tag.get();
        }
        while (this.stationTags.containsKey(newId = UUID.randomUUID())) {
        }
        StationTag newTag = new StationTag(newId, name, owner);
        this.stationTags.put(newId, newTag);
        return newTag;
    }

    public StationTag registerStationTag(StationTag tag) {
        UUID newId;
        while (this.stationTags.containsKey(newId = UUID.randomUUID())) {
        }
        tag.setId(newId);
        this.stationTags.put(newId, tag);
        return tag;
    }

    public Optional<StationTag> getTagByName(TagName name) {
        for (StationTag tag : this.stationTags.values()) {
            if (!tag.getTagName().equals(name)) continue;
            return Optional.ofNullable(tag);
        }
        return Optional.empty();
    }

    public Optional<StationTag> getStationTag(UUID id) {
        return Optional.ofNullable(this.stationTagExists(id) ? this.stationTags.get(id) : null);
    }

    public boolean removeStationTag(String name) {
        return this.removeStationTag(TagName.of(name));
    }

    public boolean removeStationTag(TagName name) {
        return this.stationTags.values().removeIf(x -> x.getTagName().equals(name));
    }

    public StationTag removeStationTag(UUID id) {
        return this.stationTags.remove(id);
    }

    public List<StationTag> getAllStationTags() {
        return new ArrayList<StationTag>(this.stationTags.values());
    }

    public boolean trainCategoryExists(UUID id) {
        return this.trainCategories.containsKey(id);
    }

    public TrainCategory createOrGetTrainCategory(String name) {
        return this.createOrGetTrainCategory(name, null);
    }

    public TrainCategory createOrGetTrainCategory(String name, Owner owner) {
        UUID id;
        Optional<TrainCategory> tag = this.getTrainCategoryByName(name);
        if (tag.isPresent()) {
            return tag.get();
        }
        while (this.trainCategories.containsKey(id = UUID.randomUUID())) {
        }
        TrainCategory newCategory = new TrainCategory(id, name, owner);
        this.trainCategories.put(newCategory.getId(), newCategory);
        return newCategory;
    }

    public Optional<TrainCategory> getTrainCategory(UUID id) {
        return Optional.ofNullable(this.trainCategoryExists(id) ? this.trainCategories.get(id) : null);
    }

    public Optional<TrainCategory> getTrainCategoryByName(String name) {
        for (TrainCategory category : this.trainCategories.values()) {
            if (!category.getCategoryName().equals(name)) continue;
            return Optional.of(category);
        }
        return Optional.empty();
    }

    public TrainCategory removeTrainCategory(UUID id) {
        return this.trainCategories.remove(id);
    }

    public ImmutableList<TrainCategory> getAllTrainCategories() {
        return ImmutableList.copyOf(this.trainCategories.values());
    }

    public boolean isTrainExcludedByUser(Train train, UserSettings settings) {
        return TrainListener.getTrainData(train.id).map(data -> {
            if (data.getSections().isEmpty()) {
                return false;
            }
            for (ScheduleSection section : data.getSections()) {
                if (!section.isUsable() || section.getTrainCategory().map(x -> settings.navigationExcludedTrainCategories.getValue().contains(x.getId())).orElse(false).booleanValue()) continue;
                return false;
            }
            return true;
        }).orElse(false);
    }

    public boolean isTrainStationExcludedByUser(Train train, TrainPrediction at, UserSettings settings) {
        return at.getSection().getTrainCategory().map(x -> !at.getSection().isUsable() || settings.navigationExcludedTrainCategories.getValue().contains(x.getId())).orElse(false);
    }

    public boolean isTrainStationExcludedByUser(Train train, TrainStop at, UserSettings settings) {
        return TrainListener.getTrainData(train.id).map(data -> {
            ScheduleSection section = data.getSectionByIndex(at.getSectionIndex());
            return section.getTrainCategory().map(x -> !section.isUsable() || settings.navigationExcludedTrainCategories.getValue().contains(x.getId())).orElse(false);
        }).orElse(false);
    }

    public boolean isStationBlacklisted(GlobalStation station) {
        return this.isStationBlacklisted(station.name);
    }

    public boolean isStationBlacklisted(String name) {
        return this.stationBlacklist.contains(name);
    }

    public void blacklistStation(GlobalStation station) {
        this.blacklistStation(station.name);
    }

    public void blacklistStation(String stationName) {
        if (ModUtils.hasWildcards(stationName)) {
            this.stationBlacklist.addAll(ModUtils.wildcardMatches(stationName, TrainUtils.getAllStationNames()));
            return;
        }
        this.stationBlacklist.add(stationName);
    }

    public boolean removeStationFromBlacklist(GlobalStation station) {
        return this.removeStationFromBlacklist(station.name);
    }

    public boolean removeStationFromBlacklist(String stationName) {
        return this.stationBlacklist.removeIf(x -> x.equals(stationName));
    }

    public boolean isEntireStationTagBlacklisted(StationTag tag) {
        if (tag == null) {
            return true;
        }
        Set<String> names = tag.getAllStationNames();
        for (String name : names) {
            if (this.isStationBlacklisted(name)) continue;
            return false;
        }
        return !names.isEmpty();
    }

    public ImmutableList<String> getAllBlacklistedStations() {
        return ImmutableList.copyOf(this.stationBlacklist);
    }

    public boolean isTrainBlacklisted(Train train) {
        return this.isTrainBlacklisted(train.name.getString());
    }

    public boolean isTrainBlacklisted(String trainName) {
        return this.trainBlacklist.contains(trainName);
    }

    public void blacklistTrain(Train train) {
        this.blacklistTrain(train.name.getString());
    }

    public void blacklistTrain(String trainName) {
        if (ModUtils.hasWildcards(trainName)) {
            this.trainBlacklist.addAll(ModUtils.wildcardMatches(trainName, TrainUtils.getTrainNames()));
            return;
        }
        this.trainBlacklist.add(trainName);
    }

    public boolean removeTrainFromBlacklist(Train train) {
        return this.removeTrainFromBlacklist(train.name.getString());
    }

    public boolean removeTrainFromBlacklist(String trainName) {
        return this.trainBlacklist.removeIf(x -> x.equals(trainName));
    }

    public ImmutableList<String> getAllBlacklistedTrains() {
        return ImmutableList.copyOf(this.trainBlacklist);
    }

    public boolean trainLineExists(UUID id) {
        return this.trainLines.containsKey(id);
    }

    public TrainLine createOrGetTrainLine(String name) {
        return this.createOrGetTrainLine(name, null);
    }

    public TrainLine createOrGetTrainLine(String name, Owner owner) {
        UUID id;
        Optional<TrainLine> tag = this.getTrainLineByName(name);
        if (tag.isPresent()) {
            return tag.get();
        }
        while (this.trainCategories.containsKey(id = UUID.randomUUID())) {
        }
        TrainLine newLine = new TrainLine(id, name, owner);
        this.trainLines.put(newLine.getId(), newLine);
        return newLine;
    }

    public Optional<TrainLine> getTrainLine(UUID id) {
        return Optional.ofNullable(this.trainLineExists(id) ? this.trainLines.get(id) : null);
    }

    public Optional<TrainLine> getTrainLineByName(String name) {
        for (TrainLine line : this.trainLines.values()) {
            if (!line.getLineName().equals(name)) continue;
            return Optional.of(line);
        }
        return Optional.empty();
    }

    public TrainLine removeTrainLine(UUID id) {
        return this.trainLines.remove(id);
    }

    public ImmutableList<TrainLine> getAllTrainLines() {
        return ImmutableList.copyOf(this.trainLines.values());
    }
}

