/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.display.properties;

import de.mrjulsen.crn.block.display.properties.BasicDisplaySettings;
import de.mrjulsen.crn.block.display.properties.IDisplaySettings;
import de.mrjulsen.crn.block.display.properties.components.ICarriageIndexSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowLineColorSetting;
import de.mrjulsen.crn.client.gui.widgets.modular.GuiBuilderContext;
import net.minecraft.nbt.CompoundTag;

public class TrainDestinationDetailedSettings
extends BasicDisplaySettings
implements ICarriageIndexSetting,
IShowLineColorSetting {
    protected byte carriageIndexOffset = 0;
    protected boolean overwriteCarriageIndex = false;
    protected boolean showLineColor = false;

    @Override
    public void deserializeNbt(CompoundTag nbt) {
        super.deserializeNbt(nbt);
        if (nbt.contains("CarriageIndexOffset")) {
            this.carriageIndexOffset = nbt.getByte("CarriageIndexOffset");
        }
        if (nbt.contains("OverwriteCarriageIndex")) {
            this.overwriteCarriageIndex = nbt.getBoolean("OverwriteCarriageIndex");
        }
        if (nbt.contains("ShowLineColor")) {
            this.showLineColor = nbt.getBoolean("ShowLineColor");
        }
    }

    @Override
    public void serializeNbt(CompoundTag nbt) {
        super.serializeNbt(nbt);
        nbt.putByte("CarriageIndexOffset", this.carriageIndexOffset);
        nbt.putBoolean("OverwriteCarriageIndex", this.overwriteCarriageIndex);
        nbt.putBoolean("ShowLineColor", this.showLineColor);
    }

    @Override
    public void buildGui(GuiBuilderContext context) {
        super.buildGui(context);
        this.buildCarriageIndexGui(context);
        this.buildShowLineColorGui(context);
    }

    @Override
    public void onChangeSettings(IDisplaySettings oldSettings) {
        super.onChangeSettings(oldSettings);
        this.copyCarriageIndexSetting(oldSettings);
        this.copyShowLineColorSetting(oldSettings);
    }

    @Override
    public byte getCarriageIndex() {
        return this.carriageIndexOffset;
    }

    @Override
    public boolean shouldOverwriteCarriageIndex() {
        return this.overwriteCarriageIndex;
    }

    @Override
    public void setCarriageIndex(byte b) {
        this.carriageIndexOffset = b;
    }

    @Override
    public void setOverwriteCarriageIndex(boolean b) {
        this.overwriteCarriageIndex = b;
    }

    @Override
    public boolean showLineColor() {
        return this.showLineColor;
    }

    @Override
    public void setShowLineColor(boolean b) {
        this.showLineColor = b;
    }
}

