/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.display.properties;

import de.mrjulsen.crn.block.display.properties.BasicDisplaySettings;
import de.mrjulsen.crn.block.display.properties.IDisplaySettings;
import de.mrjulsen.crn.block.display.properties.components.IShowExitDirectionSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowTimeAndDateSetting;
import de.mrjulsen.crn.block.display.properties.components.IShowTrainStatsSetting;
import de.mrjulsen.crn.block.display.properties.components.ITrainTextSetting;
import de.mrjulsen.crn.client.gui.widgets.modular.GuiBuilderContext;
import net.minecraft.nbt.CompoundTag;

public class PassengerInformationScrollingTextSettings
extends BasicDisplaySettings
implements IShowTrainStatsSetting,
IShowExitDirectionSetting,
IShowTimeAndDateSetting,
ITrainTextSetting {
    protected boolean showStats = true;
    protected boolean showExit = true;
    protected boolean showTimeAndDate = true;
    protected ITrainTextSetting.ETrainTextComponents trainTextComponents = ITrainTextSetting.ETrainTextComponents.ALL;

    @Override
    public void deserializeNbt(CompoundTag nbt) {
        super.deserializeNbt(nbt);
        if (nbt.contains("ShowStats")) {
            this.showStats = nbt.getBoolean("ShowStats");
        }
        if (nbt.contains("ShowExit")) {
            this.showExit = nbt.getBoolean("ShowExit");
        }
        if (nbt.contains("ShowTime")) {
            this.showTimeAndDate = nbt.getBoolean("ShowTime");
        }
        if (nbt.contains("TrainText")) {
            this.trainTextComponents = ITrainTextSetting.ETrainTextComponents.getById(nbt.getByte("TrainText"));
        }
    }

    @Override
    public void serializeNbt(CompoundTag nbt) {
        super.serializeNbt(nbt);
        nbt.putBoolean("ShowStats", this.showStats);
        nbt.putBoolean("ShowExit", this.showExit);
        nbt.putBoolean("ShowTime", this.showTimeAndDate);
        nbt.putByte("TrainText", this.trainTextComponents.getId());
    }

    @Override
    public void buildGui(GuiBuilderContext context) {
        super.buildGui(context);
        this.buildShowStatsGui(context);
        this.buildShowExitGui(context);
        this.buildShowTimeAndDateGui(context);
        this.buildTrainTextGui(context);
    }

    @Override
    public void onChangeSettings(IDisplaySettings oldSettings) {
        super.onChangeSettings(oldSettings);
        this.copyShowExitSetting(oldSettings);
        this.copyShowStatsSetting(oldSettings);
        this.copyShowTimeAndDateSetting(oldSettings);
        this.copyTrainTextSetting(oldSettings);
    }

    @Override
    public boolean showStats() {
        return this.showStats;
    }

    @Override
    public void setShowStats(boolean b) {
        this.showStats = b;
    }

    @Override
    public boolean showExit() {
        return this.showExit;
    }

    @Override
    public void setShowExit(boolean b) {
        this.showExit = b;
    }

    @Override
    public ITrainTextSetting.ETrainTextComponents getTrainTextComponents() {
        return this.trainTextComponents;
    }

    @Override
    public void setTrainTextComponents(ITrainTextSetting.ETrainTextComponents v) {
        this.trainTextComponents = v;
    }

    @Override
    public boolean showTimeAndDate() {
        return this.showTimeAndDate;
    }

    @Override
    public void setShowTimeAndDate(boolean b) {
        this.showTimeAndDate = b;
    }
}

