/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block.blockentity;

import de.mrjulsen.crn.CreateRailwaysNavigator;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public interface IMultiblockBlockEntity<T extends BlockEntity, B extends Block> {
    public byte getWidth();

    public byte getHeight();

    public byte getMaxWidth();

    public byte getMaxHeight();

    public boolean isController();

    public Class<B> getBlockType();

    public Class<T> getBlockEntityType();

    default public T getBlockEntityCasted(Level level, BlockPos otherpos) {
        if (!this.getBlockEntityType().isInstance(level.getBlockEntity(otherpos))) {
            return null;
        }
        return (T)((BlockEntity)this.getBlockEntityType().cast(level.getBlockEntity(otherpos)));
    }

    public boolean connectable(BlockGetter var1, BlockPos var2, BlockPos var3);

    default public void applyToAll(Consumer<T> apply) {
        BlockEntity be = (BlockEntity)this;
        BlockState blockState = be.getBlockState();
        if (!this.getBlockType().isInstance(blockState.getBlock())) {
            return;
        }
        BlockPos.MutableBlockPos pos = be.getBlockPos().mutable();
        Direction side = ((Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING)).getCounterClockWise();
        for (int i = 0; i < this.getWidth() && i < this.getMaxWidth(); ++i) {
            BlockPos newPos = pos.relative(side, i);
            for (int j = 0; j < this.getHeight() && j < this.getMaxHeight(); ++j) {
                BlockPos newPos2 = newPos.relative(Direction.DOWN, j);
                T otherBlockEntity = this.getBlockEntityCasted(be.getLevel(), newPos2);
                if (otherBlockEntity != null) {
                    apply.accept(otherBlockEntity);
                    continue;
                }
                CreateRailwaysNavigator.LOGGER.error(String.format("BlockEntity at %s does not exist!", newPos2));
            }
        }
    }
}

