/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.block;

import de.mrjulsen.crn.block.AbstractAdvancedSidedDisplayBlock;
import de.mrjulsen.crn.block.properties.EBlockAlignment;
import de.mrjulsen.mcdragonlib.data.Pair;
import de.mrjulsen.mcdragonlib.data.Tripple;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AdvancedDisplayPanelBlock
extends AbstractAdvancedSidedDisplayBlock {
    public static final EnumProperty<EBlockAlignment> Z_ALIGN = EnumProperty.create((String)"z_alignment", EBlockAlignment.class);
    private static final Map<ShapeKey, VoxelShape> SHAPES = Map.ofEntries(Map.entry(new ShapeKey(Direction.SOUTH, EBlockAlignment.NEGATIVE), Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0)), Map.entry(new ShapeKey(Direction.NORTH, EBlockAlignment.NEGATIVE), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0)), Map.entry(new ShapeKey(Direction.EAST, EBlockAlignment.NEGATIVE), Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)), Map.entry(new ShapeKey(Direction.WEST, EBlockAlignment.NEGATIVE), Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0)), Map.entry(new ShapeKey(Direction.SOUTH, EBlockAlignment.CENTER), Block.box((double)0.0, (double)0.0, (double)6.5, (double)16.0, (double)16.0, (double)9.5)), Map.entry(new ShapeKey(Direction.NORTH, EBlockAlignment.CENTER), Block.box((double)0.0, (double)0.0, (double)6.5, (double)16.0, (double)16.0, (double)9.5)), Map.entry(new ShapeKey(Direction.EAST, EBlockAlignment.CENTER), Block.box((double)6.5, (double)0.0, (double)0.0, (double)9.5, (double)16.0, (double)16.0)), Map.entry(new ShapeKey(Direction.WEST, EBlockAlignment.CENTER), Block.box((double)6.5, (double)0.0, (double)0.0, (double)9.5, (double)16.0, (double)16.0)), Map.entry(new ShapeKey(Direction.SOUTH, EBlockAlignment.POSITIVE), Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0)), Map.entry(new ShapeKey(Direction.NORTH, EBlockAlignment.POSITIVE), Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0)), Map.entry(new ShapeKey(Direction.EAST, EBlockAlignment.POSITIVE), Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0)), Map.entry(new ShapeKey(Direction.WEST, EBlockAlignment.POSITIVE), Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0)));

    public AdvancedDisplayPanelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(Z_ALIGN, (Comparable)((Object)EBlockAlignment.POSITIVE)));
    }

    @Override
    public Collection<Property<?>> getExcludedProperties() {
        return List.of(Z_ALIGN);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPES.get(new ShapeKey((Direction)pState.getValue((Property)FACING), (EBlockAlignment)((Object)pState.getValue(Z_ALIGN))));
    }

    @Override
    public BlockState getDefaultPlacementState(BlockPlaceContext context, BlockState state, BlockState other) {
        BlockState stateForPlacement = super.getDefaultPlacementState(context, state, other);
        Direction direction = context.getClickedFace();
        Direction looking = context.getHorizontalDirection();
        Direction.Axis axis = looking.getAxis();
        Direction.AxisDirection axisDirection = looking.getAxisDirection();
        double xzPos = 0.5;
        if (axis == Direction.Axis.X) {
            xzPos = context.getClickLocation().x - (double)context.getClickedPos().getX();
        } else if (axis == Direction.Axis.Z) {
            xzPos = context.getClickLocation().z - (double)context.getClickedPos().getZ();
        }
        EBlockAlignment zAlign = EBlockAlignment.POSITIVE;
        if (direction == context.getPlayer().getDirection() || (axisDirection == Direction.AxisDirection.POSITIVE ? xzPos < 0.5 : xzPos > 0.5)) {
            zAlign = EBlockAlignment.NEGATIVE;
        }
        return (BlockState)stateForPlacement.setValue(Z_ALIGN, (Comparable)((Object)zAlign));
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)pBuilder.add(new Property[]{Z_ALIGN}));
    }

    @Override
    public BlockState appendOnPlace(BlockPlaceContext context, BlockState state, BlockState other) {
        return (BlockState)super.appendOnPlace(context, state, other).setValue(Z_ALIGN, (Comparable)((Object)((EBlockAlignment)((Object)other.getValue(Z_ALIGN)))));
    }

    @Override
    public boolean canConnectWithBlock(BlockGetter level, BlockState selfState, BlockState otherState) {
        return super.canConnectWithBlock(level, selfState, otherState) && selfState.getValue(Z_ALIGN) == otherState.getValue(Z_ALIGN);
    }

    @Override
    protected boolean canConnect(LevelAccessor level, BlockPos pos, BlockState state, BlockState other) {
        return super.canConnect(level, pos, state, other) && state.getValue(Z_ALIGN) == other.getValue(Z_ALIGN);
    }

    @Override
    public Pair<Float, Float> getRenderAspectRatio(Level level, BlockState blockState, BlockPos pos) {
        return Pair.of((Object)Float.valueOf(1.0f), (Object)Float.valueOf(1.0f));
    }

    @Override
    public Pair<Float, Float> getRenderOffset(Level level, BlockState blockState, BlockPos pos) {
        return Pair.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
    }

    @Override
    public Pair<Float, Float> getRenderZOffset(Level level, BlockState blockState, BlockPos pos) {
        float z1;
        return Pair.of((Object)Float.valueOf(z1), (Object)Float.valueOf(switch ((EBlockAlignment)((Object)blockState.getValue(Z_ALIGN))) {
            case EBlockAlignment.NEGATIVE -> {
                z1 = 16.05f;
                yield 3.05f;
            }
            case EBlockAlignment.POSITIVE -> {
                z1 = 3.05f;
                yield 16.05f;
            }
            default -> {
                z1 = 9.55f;
                yield 9.55f;
            }
        }));
    }

    @Override
    public Tripple<Float, Float, Float> getRenderRotation(Level level, BlockState blockState, BlockPos pos) {
        return Tripple.of((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
    }

    @Override
    public boolean isSingleLined() {
        return false;
    }

    private static final class ShapeKey {
        private final Direction facing;
        private final EBlockAlignment zAlign;

        public ShapeKey(Direction facing, EBlockAlignment zAlign) {
            this.facing = facing;
            this.zAlign = zAlign;
        }

        public boolean equals(Object o) {
            if (o instanceof ShapeKey) {
                ShapeKey other = (ShapeKey)o;
                return this.facing == other.facing && this.zAlign == other.zAlign;
            }
            return false;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.facing, this.zAlign});
        }
    }
}

